/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.domainservice;

import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgTagRelQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.model.role.ISysRoleInfoModel;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysAdmUserQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysCustExtMapQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserTagRelQryBo;
import com.tydic.dyc.authority.model.user.sub.SysCustExtMapSubDo;
import com.tydic.dyc.authority.model.user.sub.SysCustInfoSubDo;
import com.tydic.dyc.authority.model.user.sub.SysUserTagRelSubDo;
import com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterRefillService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRefillReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRefillRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRegisterRefillOrgInfoBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRegisterRefillUserInfoBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRegisterRefillUserRoleInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustExtMapBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterRefillService"})
public class AuthEnterpriseUserRegisterRefillServiceImpl
implements AuthEnterpriseUserRegisterRefillService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;
    @Autowired
    private ISysRoleInfoModel iSysRoleInfoModel;

    @PostMapping(value={"dealEnterpriseUserRegisterRefill"})
    public AuthEnterpriseUserRegisterRefillRspBo dealEnterpriseUserRegisterRefill(@RequestBody AuthEnterpriseUserRegisterRefillReqBo reqBo) {
        this.validateArg(reqBo);
        AuthOrgInfoBo authOrgInfoBo = this.modifyOrg(reqBo.getAuthRegisterRefillOrgInfoBo());
        AuthUserInfoBo DoToBo = this.modifyUser(reqBo.getAuthRegisterRefillUserInfoBo());
        this.modifyUserRole(reqBo.getAuthRegisterRefillUserRoleInfoBo());
        return this.getRspBo(authOrgInfoBo, DoToBo);
    }

    private AuthEnterpriseUserRegisterRefillRspBo getRspBo(AuthOrgInfoBo authOrgInfoBo, AuthUserInfoBo DoToBo) {
        AuthEnterpriseUserRegisterRefillRspBo rspBo = AuthRu.success(AuthEnterpriseUserRegisterRefillRspBo.class);
        rspBo.setOrgInfoBo(authOrgInfoBo);
        rspBo.setUserInfoBo(DoToBo);
        return rspBo;
    }

    private void modifyUserRole(AuthRegisterRefillUserRoleInfoBo authRegisterRefillUserRoleInfoBo) {
        this.getManageLevel(authRegisterRefillUserRoleInfoBo);
        SysUserInfoDo reqDo = AuthRu.js(authRegisterRefillUserRoleInfoBo, SysUserInfoDo.class);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(authRegisterRefillUserRoleInfoBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        qryBo.setDisAgFLagList(Collections.singletonList(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY));
        SysUserInfoDo userRoleDo = this.iSysUserInfoModel.getRoleInfoListByUser(qryBo);
        List<SysRoleInfoSubDo> oldRoleList = userRoleDo.getUserRoleList();
        List<SysAuthDistributeSubDo> addSubDo = reqDo.getAuthDistributeList();
        ArrayList<SysAuthDistributeSubDo> eqaulsSubDo = new ArrayList<SysAuthDistributeSubDo>();
        ArrayList<SysRoleInfoSubDo> eqaulsRoleList = new ArrayList<SysRoleInfoSubDo>();
        block0: for (SysRoleInfoSubDo oldSubDo : oldRoleList) {
            for (SysAuthDistributeSubDo reqDistributeSubDo : addSubDo) {
                if (!oldSubDo.getRoleId().equals(reqDistributeSubDo.getRoleId())) continue;
                eqaulsSubDo.add(reqDistributeSubDo);
                eqaulsRoleList.add(oldSubDo);
                continue block0;
            }
        }
        oldRoleList.removeAll(eqaulsRoleList);
        addSubDo.removeAll(eqaulsSubDo);
        this.addUserRole(reqDo, addSubDo, authRegisterRefillUserRoleInfoBo);
        this.deleteUserRole(reqDo, oldRoleList);
        this.addDistributRoles(authRegisterRefillUserRoleInfoBo, reqDo, addSubDo);
    }

    private AuthUserInfoBo modifyUser(AuthRegisterRefillUserInfoBo reqBo) {
        SysUserInfoDo sysUserInfoDo;
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo userInfoDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (userInfoDo == null || userInfoDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoDo reqDo = this.buildUserDo(reqBo);
        if (reqDo.getCustInfo() != null && reqDo.getCustInfo().getCustId() == null) {
            reqDo.getCustInfo().setCustId(userInfoDo.getCustId());
        }
        SysUserInfoDo rspDo = this.iSysUserInfoModel.modifyUserInfo(reqDo);
        if (!CollectionUtils.isEmpty(reqDo.getAuthDistributeList())) {
            this.iSysUserInfoModel.addUserRoleList(reqDo);
        }
        if ("1".equals(reqBo.getIsChngTag())) {
            SysUserTagRelQryBo qryTagBo = new SysUserTagRelQryBo();
            qryTagBo.setUserId(reqBo.getUserId());
            sysUserInfoDo = this.iSysUserInfoModel.getUserTagList(qryTagBo);
            List<SysUserTagRelSubDo> oldTagList = sysUserInfoDo.getUserTagRelList();
            List<SysUserTagRelSubDo> reqTagList = reqDo.getUserTagRelList();
            ArrayList<SysUserTagRelSubDo> equalsOldSubDo = new ArrayList<SysUserTagRelSubDo>();
            ArrayList<SysUserTagRelSubDo> equalsreqSubDo = new ArrayList<SysUserTagRelSubDo>();
            for (SysUserTagRelSubDo tagRelSubDo : oldTagList) {
                for (SysUserTagRelSubDo reqTagRelSubDo : reqDo.getUserTagRelList()) {
                    if (!tagRelSubDo.getTagId().equals(reqTagRelSubDo.getTagId())) continue;
                    equalsOldSubDo.add(tagRelSubDo);
                    equalsreqSubDo.add(reqTagRelSubDo);
                }
            }
            oldTagList.removeAll(equalsOldSubDo);
            reqTagList.removeAll(equalsreqSubDo);
            this.addUserTag(reqDo, reqTagList);
            this.deleteUserTag(reqDo, oldTagList);
        }
        if (!CollectionUtils.isEmpty(reqDo.getCustExtMapList())) {
            SysCustExtMapQryBo extMapQryBo = new SysCustExtMapQryBo();
            extMapQryBo.setCustId(reqDo.getCustId());
            extMapQryBo.setFieldCodes(reqDo.getFieldCodes());
            sysUserInfoDo = this.iSysUserInfoModel.getCustExtMapList(extMapQryBo);
            List<SysCustExtMapSubDo> extMapList = sysUserInfoDo.getCustExtMapList();
            ArrayList<SysCustExtMapSubDo> updateList = new ArrayList<SysCustExtMapSubDo>();
            List<SysCustExtMapSubDo> addList = reqDo.getCustExtMapList();
            block2: for (SysCustExtMapSubDo newCustExtMap : reqDo.getCustExtMapList()) {
                for (SysCustExtMapSubDo oldCustExtMap : extMapList) {
                    if (!oldCustExtMap.getFieldCode().equals(newCustExtMap.getFieldCode())) continue;
                    SysCustExtMapSubDo updateSubDo = AuthRu.js(newCustExtMap, SysCustExtMapSubDo.class);
                    updateList.add(updateSubDo);
                    continue block2;
                }
            }
            addList.removeAll(updateList);
            this.addCustExtMap(reqDo, addList);
            this.updateCustExtMap(reqDo, updateList);
        }
        return AuthRu.js(rspDo, AuthUserInfoBo.class);
    }

    private AuthOrgInfoBo modifyOrg(AuthRegisterRefillOrgInfoBo authRegisterRefillOrgInfoBo) {
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        qryBo.setOrgId(authRegisterRefillOrgInfoBo.getOrgId());
        SysOrgInfoDo rspDoDetail = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        SysOrgInfoDo reqDo = this.buildOrgDo(authRegisterRefillOrgInfoBo);
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.modifyOrgInfo(reqDo);
        return AuthRu.js(rspDo, AuthOrgInfoBo.class);
    }

    private SysOrgInfoDo buildOrgDo(AuthRegisterRefillOrgInfoBo authRegisterRefillOrgInfoBo) {
        authRegisterRefillOrgInfoBo.setUpdateTime(new Date());
        SysOrgInfoDo reqDo = AuthRu.js(authRegisterRefillOrgInfoBo, SysOrgInfoDo.class);
        if ("1".equals(authRegisterRefillOrgInfoBo.getChngTagFlag())) {
            SysOrgTagRelQryBo qryTagBo = new SysOrgTagRelQryBo();
            qryTagBo.setOrgId(authRegisterRefillOrgInfoBo.getOrgId());
            SysOrgInfoDo sysOrgInfoDo = this.iSysOrgInfoModel.getOrgTagList(qryTagBo);
            List<SysOrgTagRelSubDo> oldTagList = sysOrgInfoDo.getOrgTagList();
            List<SysOrgTagRelSubDo> reqTagList = reqDo.getOrgTagList();
            ArrayList<SysOrgTagRelSubDo> equalsOldSubDo = new ArrayList<SysOrgTagRelSubDo>();
            ArrayList<SysOrgTagRelSubDo> equalsreqSubDo = new ArrayList<SysOrgTagRelSubDo>();
            for (SysOrgTagRelSubDo tagRelSubDo : oldTagList) {
                for (SysOrgTagRelSubDo reqTagRelSubDo : reqDo.getOrgTagList()) {
                    if (!tagRelSubDo.getTagId().equals(reqTagRelSubDo.getTagId())) continue;
                    equalsOldSubDo.add(tagRelSubDo);
                    equalsreqSubDo.add(reqTagRelSubDo);
                }
            }
            oldTagList.removeAll(equalsOldSubDo);
            reqTagList.removeAll(equalsreqSubDo);
            this.addOrgTag(reqDo, reqTagList);
            this.deleteOrgTag(reqDo, oldTagList);
        }
        return reqDo;
    }

    private void addOrgTag(SysOrgInfoDo reqDo, List<SysOrgTagRelSubDo> addTagList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        for (SysOrgTagRelSubDo subDo : addTagList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setOrgId(reqDo.getOrgId());
            subDo.setDelFlag("0");
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getCreateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setOrgTagList(addTagList);
        this.iSysOrgInfoModel.addOrgTagList(addReqBo);
    }

    private void deleteOrgTag(SysOrgInfoDo sysOrgInfoDo, List<SysOrgTagRelSubDo> deleteTagList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        for (SysOrgTagRelSubDo subDo : deleteTagList) {
            subDo.setUpdateOperId(sysOrgInfoDo.getUpdateOperId());
            subDo.setUpdateOperName(sysOrgInfoDo.getCreateOperName());
            subDo.setUpdateTime(sysOrgInfoDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        addReqBo.setOrgTagList(deleteTagList);
        this.iSysOrgInfoModel.updateOrgTagList(addReqBo);
    }

    private SysUserInfoDo buildUserDo(AuthRegisterRefillUserInfoBo reqBo) {
        Serializable subDo;
        reqBo.setUpdateTime(new Date());
        SysUserInfoDo reqDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysUserInfoDo.class));
        if (reqBo.getCustInfo() != null && reqBo.getCustId() == null) {
            SysCustInfoSubDo custSubDo = StrUtil.noNullStringAttr(AuthRu.js(reqBo.getCustInfo(), SysCustInfoSubDo.class));
            custSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            custSubDo.setUpdateOperName(reqDo.getUpdateOperName());
            custSubDo.setUpdateTime(reqDo.getUpdateTime());
            reqDo.setCustInfo(custSubDo);
            if (reqBo.getCustInfo().getClearInitialPassword() == 1 && reqBo.getCustInfo().getCustId() != null) {
                this.iSysUserInfoModel.updateCustInfoClearInitialPassword(custSubDo);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCustExtMapList())) {
            ArrayList<SysCustExtMapSubDo> custExtMapList = new ArrayList<SysCustExtMapSubDo>();
            ArrayList<String> fieldCodes = new ArrayList<String>();
            for (AuthCustExtMapBo bo : reqBo.getCustExtMapList()) {
                SysCustExtMapSubDo subDo2 = AuthRu.js(bo, SysCustExtMapSubDo.class);
                subDo2.setCustId(reqDo.getCustId());
                subDo2.setUpdateOperId(reqDo.getUpdateOperId());
                subDo2.setUpdateOperName(reqDo.getUpdateOperName());
                subDo2.setUpdateTime(reqDo.getUpdateTime());
                fieldCodes.add(bo.getFieldCode());
                custExtMapList.add(subDo2);
            }
            reqDo.setCustExtMapList(custExtMapList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            ArrayList<SysUserTagRelSubDo> sysUserTagRelList = new ArrayList<SysUserTagRelSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getUserTagRelList()) {
                subDo = AuthRu.js(bo, SysUserTagRelSubDo.class);
                ((SysUserTagRelSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysUserTagRelSubDo)subDo).setUpdateOperName(reqDo.getUpdateOperName());
                ((SysUserTagRelSubDo)subDo).setUpdateTime(reqDo.getUpdateTime());
                sysUserTagRelList.add((SysUserTagRelSubDo)subDo);
            }
            reqDo.setUserTagRelList(sysUserTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthDistributeList())) {
            ArrayList<SysAuthDistributeSubDo> authDistributeList = new ArrayList<SysAuthDistributeSubDo>();
            for (AuthUserTagRelBo bo : reqBo.getAuthDistributeList()) {
                subDo = AuthRu.js(bo, SysAuthDistributeSubDo.class);
                ((SysAuthDistributeSubDo)subDo).setUpdateOperId(reqDo.getUpdateOperId());
                ((SysAuthDistributeSubDo)subDo).setUpdateOperName(reqDo.getUpdateOperName());
                ((SysAuthDistributeSubDo)subDo).setUpdateTime(reqDo.getUpdateTime());
                authDistributeList.add((SysAuthDistributeSubDo)subDo);
            }
            reqDo.setAuthDistributeList(authDistributeList);
        }
        return reqDo;
    }

    private void validateArg(AuthEnterpriseUserRegisterRefillReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthRegisterRefillOrgInfoBo()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthRegisterRefillOrgInfoBo().getOrgId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthRegisterRefillUserInfoBo()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuthRegisterRefillUserInfoBo().getCustInfo() && null == reqBo.getAuthRegisterRefillUserInfoBo().getCustId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5ba2\u6237\u4fe1\u606f\u548c\u5ba2\u6237ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthRegisterRefillUserInfoBo().getCustExtMapList())) {
            for (AuthCustExtMapBo bo : reqBo.getAuthRegisterRefillUserInfoBo().getCustExtMapList()) {
                if (bo.getFieldCode() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[FieldCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthRegisterRefillUserInfoBo().getUserTagRelList())) {
            for (AuthCustExtMapBo bo : reqBo.getAuthRegisterRefillUserInfoBo().getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u7528\u6237\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (null != reqBo.getAuthRegisterRefillUserRoleInfoBo()) {
            if (null == reqBo.getAuthRegisterRefillUserRoleInfoBo().getUserId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u89d2\u8272\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)reqBo.getAuthRegisterRefillUserRoleInfoBo().getAuthDistributeList())) {
                for (AuthCustExtMapBo bo : reqBo.getAuthRegisterRefillUserRoleInfoBo().getAuthDistributeList()) {
                    if (bo.getRoleId() != null) continue;
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u89d2\u8272ID\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
                }
            }
        }
    }

    private void addUserTag(SysUserInfoDo reqDo, List<SysUserTagRelSubDo> addTagList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysUserTagRelSubDo subDo : addTagList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDelFlag("0");
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getCreateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setUserTagRelList(addTagList);
        this.iSysUserInfoModel.addUserTagList(addReqBo);
    }

    private void deleteUserTag(SysUserInfoDo reqDo, List<SysUserTagRelSubDo> deleteTagList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysUserTagRelSubDo subDo : deleteTagList) {
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        addReqBo.setUserTagRelList(deleteTagList);
        this.iSysUserInfoModel.updateUserTagList(addReqBo);
    }

    private void addCustExtMap(SysUserInfoDo reqDo, List<SysCustExtMapSubDo> addCustExtMapList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysCustExtMapSubDo subDo : addCustExtMapList) {
            subDo.setExtId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setCustId(reqDo.getUserId());
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setCustExtMapList(addCustExtMapList);
        this.iSysUserInfoModel.addCustExtMapList(addReqBo);
    }

    private void updateCustExtMap(SysUserInfoDo reqDo, List<SysCustExtMapSubDo> updateCustExtMapList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysCustExtMapSubDo extMapSubDo : updateCustExtMapList) {
            extMapSubDo.setUpdateOperId(reqDo.getUpdateOperId());
            extMapSubDo.setUpdateOperName(reqDo.getCreateOperName());
            extMapSubDo.setUpdateTime(reqDo.getCreateTime());
        }
        addReqBo.setCustExtMapList(updateCustExtMapList);
        this.iSysUserInfoModel.updateCustExtMapList(addReqBo);
    }

    private void addDistributRoles(AuthRegisterRefillUserRoleInfoBo reqBo, SysUserInfoDo reqDo, List<SysAuthDistributeSubDo> addSubDo) {
        SysAdmUserQryBo admUserQryBo = new SysAdmUserQryBo();
        admUserQryBo.setUserId(reqBo.getUserId());
        List admOrgList = new ArrayList();
        admOrgList = this.iSysUserInfoModel.getAdmOrgList(admUserQryBo).getRows();
        if (!CollectionUtils.isEmpty(admOrgList)) {
            SysRoleInfoDo addReqBo = new SysRoleInfoDo();
            ArrayList<SysAuthDistributeSubDo> addAdmList = new ArrayList<SysAuthDistributeSubDo>();
            for (SysAuthDistributeSubDo subDo : addSubDo) {
                if ("0".equals(subDo.getRoleType())) continue;
                SysAuthDistributeSubDo addDo = new SysAuthDistributeSubDo();
                addDo.setAuthId(IdUtil.nextId());
                addDo.setManageLevel(reqBo.getManagerLevelIn());
                addDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                addDo.setRoleId(subDo.getRoleId());
                addDo.setCreateOperId(reqDo.getUpdateOperId());
                addDo.setCreateOperName(reqDo.getUpdateOperName());
                addDo.setCreateTime(reqDo.getUpdateTime());
                addDo.setUpdateOperId(reqDo.getUpdateOperId());
                addDo.setUpdateOperName(reqDo.getUpdateOperName());
                addDo.setUpdateTime(reqDo.getUpdateTime());
                addDo.setUserId(reqBo.getUserId());
                addAdmList.add(addDo);
            }
            addReqBo.setAuthDistributeList(addAdmList);
            this.iSysRoleInfoModel.addAuthDistribute(addReqBo);
        }
    }

    private void addUserRole(SysUserInfoDo reqDo, List<SysAuthDistributeSubDo> addRoleList, AuthRegisterRefillUserRoleInfoBo reqBo) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        for (SysAuthDistributeSubDo subDo : addRoleList) {
            subDo.setAuthId(IdUtil.nextId());
            subDo.setTenantId(reqDo.getTenantId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ALL_AUTHORITY);
            subDo.setManageLevel(reqBo.getManagerLevelIn());
            subDo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.USER);
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getUpdateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getUpdateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setAuthDistributeList(addRoleList);
        this.iSysUserInfoModel.addUserRoleList(addReqBo);
    }

    private void deleteUserRole(SysUserInfoDo reqDo, List<SysRoleInfoSubDo> deleteRoleList) {
        SysUserInfoDo addReqBo = new SysUserInfoDo();
        ArrayList<SysAuthDistributeSubDo> delRoleList = new ArrayList<SysAuthDistributeSubDo>();
        for (SysRoleInfoSubDo roleSubDo : deleteRoleList) {
            SysAuthDistributeSubDo subDo = new SysAuthDistributeSubDo();
            subDo.setRoleId(roleSubDo.getRoleId());
            subDo.setUserId(reqDo.getUserId());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
            delRoleList.add(subDo);
        }
        addReqBo.setAuthDistributeList(delRoleList);
        this.iSysUserInfoModel.updateUserRoleList(addReqBo);
    }

    private void getManageLevel(AuthRegisterRefillUserRoleInfoBo reqBo) {
        if (reqBo.getManagerLevelIn() == null && reqBo.getOrgIdIn() != null) {
            SysOrgInfoQryBo orgInfoQryBo = new SysOrgInfoQryBo();
            orgInfoQryBo.setOrgId(reqBo.getOrgIdIn());
            SysOrgInfoDo orgInfoDetails = this.iSysOrgInfoModel.getOrgInfoDetails(orgInfoQryBo);
            reqBo.setManagerLevelIn(orgInfoDetails.getManageLevel());
        }
    }
}

