/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysCustInfoQryBo;
import com.tydic.dyc.authority.service.user.AuthGetCustInfoListService;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetCustInfoListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetCustInfoListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.StrUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthGetCustInfoListService"})
public class AuthGetCustInfoListServiceImpl
implements AuthGetCustInfoListService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"getCustInfoList"})
    public AuthGetCustInfoListRspBo getCustInfoList(@RequestBody AuthGetCustInfoListReqBo reqBo) {
        AuthGetCustInfoListRspBo rspBo = AuthRu.success(AuthGetCustInfoListRspBo.class);
        this.validateArg(reqBo);
        SysCustInfoQryBo qryBo = StrUtil.noNullStringAttr(AuthRu.js(reqBo, SysCustInfoQryBo.class));
        SysUserInfoDo sysUserInfoDo = this.iSysUserInfoModel.getCustInfoList(qryBo);
        List<AuthCustInfoBo> DoToBo = AuthRu.jsl(sysUserInfoDo.getSysCustInfoSubDos(), AuthCustInfoBo.class);
        rspBo.setCustInfoList(DoToBo);
        return rspBo;
    }

    private void validateArg(AuthGetCustInfoListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetCustInfoListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

