/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.model.user.qrybo.SysUserInfoQryBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRoleInfoBo;
import com.tydic.dyc.authority.service.user.AuthGetUserRoleListService;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserRoleListReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserRoleListRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthGetUserRoleListService"})
public class AuthGetUserRoleListServiceImpl
implements AuthGetUserRoleListService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"getUserRoleList"})
    public AuthGetUserRoleListRspBo getUserRoleList(@RequestBody AuthGetUserRoleListReqBo reqBo) {
        AuthGetUserRoleListRspBo rspBo = AuthRu.success(AuthGetUserRoleListRspBo.class);
        this.validateArg(reqBo);
        SysUserInfoQryBo qryBo = new SysUserInfoQryBo();
        qryBo.setUserId(reqBo.getUserId());
        SysUserInfoDo rspDo = this.iSysUserInfoModel.getUserInfoDetails(qryBo);
        if (rspDo == null || rspDo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        SysUserInfoQryBo roleQryBo = new SysUserInfoQryBo();
        roleQryBo.setUserId(rspDo.getUserId());
        SysUserInfoDo roleInfoDo = this.iSysUserInfoModel.getRoleInfoListByUser(roleQryBo);
        List<AuthRoleInfoBo> roleBoList = AuthRu.jsl(roleInfoDo.getUserRoleList(), AuthRoleInfoBo.class);
        rspBo.setRoleInfoBoList(roleBoList);
        return rspBo;
    }

    private void validateArg(AuthGetUserRoleListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthGetUserRoleListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

