/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.model.sysdictionary.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.authority.model.sysdictionary.ISysDictionaryModel;
import com.tydic.dyc.authority.model.sysdictionary.SysDictionaryDo;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryBo;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryMapBo;
import com.tydic.dyc.authority.model.sysdictionary.qrybo.SysDictionaryQryBo;
import com.tydic.dyc.authority.repository.SysDictionaryRepository;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ISysDictionaryModelImpl
implements ISysDictionaryModel {
    private static final Logger log = LoggerFactory.getLogger(ISysDictionaryModelImpl.class);
    @Autowired
    private SysDictionaryRepository sysDictionaryRepository;
    public static final String ERROR_DESC = "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";

    @Override
    public SysDictionaryBo qryDicList(SysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", ERROR_DESC);
        }
        return this.sysDictionaryRepository.qryDicList(reqBO);
    }

    @Override
    public SysDictionaryBo qryDicListByPCodes(SysDictionaryQryBo pCodes) {
        return this.sysDictionaryRepository.qryDicListByPCodes(pCodes);
    }

    @Override
    public SysDictionaryMapBo getDictionaryMap(SysDictionaryQryBo pCodes) {
        SysDictionaryBo sysDictionaryBo = this.sysDictionaryRepository.qryDicListByPCodes(pCodes);
        List<SysDictionaryDo> SysDictionaryDos = sysDictionaryBo.getSysDictionaryDos();
        HashMap<String, Map<String, String>> dicPCodeAndCodeMap = new HashMap<String, Map<String, String>>();
        if (ObjectUtil.isNotEmpty(SysDictionaryDos)) {
            Map<String, List<SysDictionaryDo>> dicPCodeMap = SysDictionaryDos.stream().collect(Collectors.groupingBy(SysDictionaryDo::getPCode));
            for (String pCode : dicPCodeMap.keySet()) {
                Map<String, String> dicCodeMap = dicPCodeMap.get(pCode).stream().collect(Collectors.toMap(SysDictionaryDo::getCode, SysDictionaryDo::getDescrip, (k1, k2) -> k2));
                dicPCodeAndCodeMap.put(pCode, dicCodeMap);
            }
        }
        SysDictionaryMapBo sysDictionaryMapBo = new SysDictionaryMapBo();
        sysDictionaryMapBo.setDictionaryMap(dicPCodeAndCodeMap);
        return sysDictionaryMapBo;
    }

    @Override
    public SysDictionaryDo getModelBy(SysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", ERROR_DESC);
        }
        return this.sysDictionaryRepository.getModelBy(reqBO);
    }

    @Override
    public SysDictionaryDo createDic(SysDictionaryDo SysDictionaryDo2) {
        if (null == SysDictionaryDo2) {
            throw new BaseBusinessException("102001", ERROR_DESC);
        }
        SysDictionaryQryBo qryBo = new SysDictionaryQryBo();
        qryBo.setPCode(SysDictionaryDo2.getPCode());
        qryBo.setCode(SysDictionaryDo2.getCode());
        SysDictionaryDo model = this.getModelBy(qryBo);
        if (null != model) {
            throw new BaseBusinessException("102002", ERROR_DESC);
        }
        return this.sysDictionaryRepository.createDic(SysDictionaryDo2);
    }

    @Override
    public SysDictionaryDo updateDic(SysDictionaryDo SysDictionaryDo2) {
        if (null == SysDictionaryDo2) {
            throw new BaseBusinessException("102001", ERROR_DESC);
        }
        return this.sysDictionaryRepository.updateDic(SysDictionaryDo2);
    }

    @Override
    public SysDictionaryQryBo deleteDic(SysDictionaryQryBo reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", ERROR_DESC);
        }
        return this.sysDictionaryRepository.deleteDic(reqBO);
    }
}

