/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.admmanager;

import com.tydic.dyc.authority.model.admmanager.ISysAdministratorModel;
import com.tydic.dyc.authority.model.admmanager.SysAdmOrgRelDo;
import com.tydic.dyc.authority.model.admmanager.qrybo.SysAdmOrgRelListRspBo;
import com.tydic.dyc.authority.model.admmanager.qrybo.SysAdministratorQryBo;
import com.tydic.dyc.authority.model.authDistribute.ISysAuthDistributeModel;
import com.tydic.dyc.authority.model.authDistribute.SysAuthDistributeDo;
import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.SysUserInfoDo;
import com.tydic.dyc.authority.service.admmanager.AuthDeleteAdministratorService;
import com.tydic.dyc.authority.service.admmanager.bo.AuthDeleteAdministratorServiceReqBo;
import com.tydic.dyc.authority.service.admmanager.bo.AuthDeleteAdministratorServiceRspBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.admmanager.AuthDeleteAdministratorService"})
public class AuthDeleteAdministratorServiceImpl
implements AuthDeleteAdministratorService {
    @Autowired
    private ISysAdministratorModel iSysAdministratorModel;
    @Autowired
    private ISysAuthDistributeModel iSysAuthDistributeModel;
    @Value(value="${default_manager_role:4}")
    private Long default_manager_role;
    @Value(value="${default_delete_manager_type:auth:default:manage}")
    private String default_delete_manager_type;
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"deleteAdministrator"})
    public AuthDeleteAdministratorServiceRspBo deleteAdministrator(@RequestBody AuthDeleteAdministratorServiceReqBo reqBo) {
        SysAdministratorQryBo sysAdministratorQryBo = new SysAdministratorQryBo();
        sysAdministratorQryBo.setAdmOrgRelId((Long)reqBo.getAdmOrgRelIds().get(0));
        SysAdmOrgRelListRspBo administratorPageList = this.iSysAdministratorModel.getAdministratorPageList(sysAdministratorQryBo);
        if (CollectionUtils.isEmpty((Collection)administratorPageList.getRows())) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u7ba1\u7406\u5458\u4fe1\u606f\u4e3a\u7a7a");
        }
        SysAdmOrgRelDo sysAdmOrgRelDo = (SysAdmOrgRelDo)administratorPageList.getRows().get(0);
        SysAdmOrgRelDo js = AuthRu.js(reqBo, SysAdmOrgRelDo.class);
        js.setUpdateOperId(reqBo.getUserIdIn());
        js.setUpdateOperName(reqBo.getUserName());
        js.setAdmOrgRelIds(reqBo.getAdmOrgRelIds());
        this.iSysAdministratorModel.deleteBatch(js);
        SysAuthDistributeDo sysAuthDistributeDo = new SysAuthDistributeDo();
        sysAuthDistributeDo.setUserId(sysAdmOrgRelDo.getUserId());
        sysAuthDistributeDo.setRoleId(this.default_manager_role);
        this.iSysAuthDistributeModel.delete(sysAuthDistributeDo);
        SysUserInfoDo sysUserInfoDo = new SysUserInfoDo();
        sysUserInfoDo.setUserId(sysAdmOrgRelDo.getUserId());
        sysUserInfoDo.setAuthorityType(this.default_delete_manager_type);
        this.iSysUserInfoModel.modifyUserInfo(sysUserInfoDo);
        return AuthRu.success(AuthDeleteAdministratorServiceRspBo.class);
    }
}

