/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.organization;

import com.tydic.dyc.authority.model.organization.ISysOrgInfoModel;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgTagRelQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.model.orgtype.ISysOrgTypeModel;
import com.tydic.dyc.authority.model.orgtype.SysOrgTypeDo;
import com.tydic.dyc.authority.model.orgtype.qrybo.SysOrgTypeQryBo;
import com.tydic.dyc.authority.model.orgtype.qrybo.SysOrgTypeRspBo;
import com.tydic.dyc.authority.service.organization.AuthModifyOrgInfoService;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgInfoReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthModifyOrgInfoRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.organization.AuthModifyOrgInfoService"})
public class AuthModifyOrgInfoServiceImpl
implements AuthModifyOrgInfoService {
    @Autowired
    private ISysOrgInfoModel iSysOrgInfoModel;
    @Autowired
    private ISysOrgTypeModel iSysOrgTypeModel;
    private static final int DEFAULT_MANAGE_LEVEL = 10;

    @PostMapping(value={"modifyOrgInfo"})
    public AuthModifyOrgInfoRspBo modifyOrgInfo(@RequestBody AuthModifyOrgInfoReqBo reqBo) {
        AuthModifyOrgInfoRspBo rspBo = AuthRu.success(AuthModifyOrgInfoRspBo.class);
        this.validateArg(reqBo);
        SysOrgInfoQryBo qryBo = new SysOrgInfoQryBo();
        qryBo.setOrgId(reqBo.getOrgId());
        SysOrgInfoDo rspDoDetail = this.iSysOrgInfoModel.getOrgInfoDetails(qryBo);
        if (rspDoDetail == null || rspDoDetail.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f");
        }
        SysOrgInfoDo reqDo = this.buildDoByBO(reqBo, rspDoDetail);
        SysOrgInfoDo rspDo = this.iSysOrgInfoModel.modifyOrgInfo(reqDo);
        AuthOrgInfoBo DoToBo = AuthRu.js(rspDo, AuthOrgInfoBo.class);
        rspBo.setOrgInfoBo(DoToBo);
        return rspBo;
    }

    private SysOrgInfoDo buildDoByBO(AuthModifyOrgInfoReqBo reqBo, SysOrgInfoDo rspDoDetail) {
        reqBo.setUpdateTime(new Date());
        SysOrgInfoDo reqDo = AuthRu.js(reqBo, SysOrgInfoDo.class);
        if (null != reqBo.getOrgType() && !reqBo.getOrgType().equals(rspDoDetail.getOrgType())) {
            reqDo.setManageLevel(10);
            if (null != reqDo.getOrgType()) {
                SysOrgTypeQryBo sysOrgTypeQryBo = new SysOrgTypeQryBo();
                sysOrgTypeQryBo.setOrgTypeId(reqDo.getOrgType());
                SysOrgTypeRspBo orgTypePageList = this.iSysOrgTypeModel.getOrgTypePageList(sysOrgTypeQryBo);
                if (!CollectionUtils.isEmpty((Collection)orgTypePageList.getRows()) && null != ((SysOrgTypeDo)orgTypePageList.getRows().get(0)).getManageLevel()) {
                    reqDo.setManageLevel(((SysOrgTypeDo)orgTypePageList.getRows().get(0)).getManageLevel());
                }
            }
        }
        if ("1".equals(reqBo.getChngTagFlag())) {
            SysOrgTagRelQryBo qryTagBo = new SysOrgTagRelQryBo();
            qryTagBo.setOrgId(reqBo.getOrgId());
            SysOrgInfoDo sysOrgInfoDo = this.iSysOrgInfoModel.getOrgTagList(qryTagBo);
            List<SysOrgTagRelSubDo> oldTagList = sysOrgInfoDo.getOrgTagList();
            List<SysOrgTagRelSubDo> reqTagList = reqDo.getOrgTagList();
            ArrayList<SysOrgTagRelSubDo> equalsOldSubDo = new ArrayList<SysOrgTagRelSubDo>();
            ArrayList<SysOrgTagRelSubDo> equalsreqSubDo = new ArrayList<SysOrgTagRelSubDo>();
            for (SysOrgTagRelSubDo tagRelSubDo : oldTagList) {
                for (SysOrgTagRelSubDo reqTagRelSubDo : reqDo.getOrgTagList()) {
                    if (!tagRelSubDo.getTagId().equals(reqTagRelSubDo.getTagId())) continue;
                    equalsOldSubDo.add(tagRelSubDo);
                    equalsreqSubDo.add(reqTagRelSubDo);
                }
            }
            oldTagList.removeAll(equalsOldSubDo);
            reqTagList.removeAll(equalsreqSubDo);
            this.addOrgTag(reqDo, reqTagList);
            this.deleteOrgTag(reqDo, oldTagList);
        }
        return reqDo;
    }

    private void addOrgTag(SysOrgInfoDo reqDo, List<SysOrgTagRelSubDo> addTagList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        for (SysOrgTagRelSubDo subDo : addTagList) {
            subDo.setRelId(IdUtil.nextId());
            subDo.setOrgId(reqDo.getOrgId());
            subDo.setDelFlag("0");
            subDo.setCreateOperId(reqDo.getUpdateOperId());
            subDo.setCreateOperName(reqDo.getCreateOperName());
            subDo.setCreateTime(reqDo.getUpdateTime());
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getUpdateTime());
        }
        addReqBo.setOrgTagList(addTagList);
        this.iSysOrgInfoModel.addOrgTagList(addReqBo);
    }

    private void deleteOrgTag(SysOrgInfoDo reqDo, List<SysOrgTagRelSubDo> deleteTagList) {
        SysOrgInfoDo addReqBo = new SysOrgInfoDo();
        for (SysOrgTagRelSubDo subDo : deleteTagList) {
            subDo.setUpdateOperId(reqDo.getUpdateOperId());
            subDo.setUpdateOperName(reqDo.getCreateOperName());
            subDo.setUpdateTime(reqDo.getCreateTime());
            subDo.setDelFlag("1");
        }
        addReqBo.setOrgTagList(deleteTagList);
        this.iSysOrgInfoModel.updateOrgTagList(addReqBo);
    }

    private void validateArg(AuthModifyOrgInfoReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthModifyOrgInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[orgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

