/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.service.user;

import com.tydic.dyc.authority.model.user.ISysUserInfoModel;
import com.tydic.dyc.authority.model.user.sub.SysThirdBindSubDo;
import com.tydic.dyc.authority.service.user.AuthAddThirdBindService;
import com.tydic.dyc.authority.service.user.bo.AuthAddThirdBindReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthAddThirdBindRspBo;
import com.tydic.dyc.authority.service.user.bo.AuthThirdBindBo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"AUTHORITY_CENTER_DEV/2.0.0/com.tydic.dyc.authority.service.user.AuthAddThirdBindService"})
public class AuthAddThirdBindServiceImpl
implements AuthAddThirdBindService {
    @Autowired
    private ISysUserInfoModel iSysUserInfoModel;

    @PostMapping(value={"addThirdBind"})
    public AuthAddThirdBindRspBo addThirdBind(@RequestBody AuthAddThirdBindReqBo reqBo) {
        AuthAddThirdBindRspBo rspBo = AuthRu.success(AuthAddThirdBindRspBo.class);
        this.validateArg(reqBo);
        SysThirdBindSubDo reqDo = this.buildDoByBO(reqBo);
        reqDo.setBindId(IdUtil.nextId());
        SysThirdBindSubDo rspDo = this.iSysUserInfoModel.addThirdBind(reqDo);
        AuthThirdBindBo DoToBo = AuthRu.js(rspDo, AuthThirdBindBo.class);
        rspBo.setThirdBindBo(DoToBo);
        return rspBo;
    }

    private SysThirdBindSubDo buildDoByBO(AuthAddThirdBindReqBo reqBo) {
        reqBo.setCreateTime(new Date());
        reqBo.setUpdateTime(reqBo.getCreateTime());
        SysThirdBindSubDo reqDo = AuthRu.js(reqBo, SysThirdBindSubDo.class);
        return reqDo;
    }

    private void validateArg(AuthAddThirdBindReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getCustId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[CustId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

