/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.model.application.SysApplicationDo;
import com.tydic.dyc.authority.model.application.qrybo.SysApplicationQryBo;
import com.tydic.dyc.authority.repository.SysApplicationRepository;
import com.tydic.dyc.authority.repository.dao.SysApplicationMapper;
import com.tydic.dyc.authority.repository.po.SysApplicationPo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysApplicationRepositoryImpl
implements SysApplicationRepository {
    private static final Logger log = LoggerFactory.getLogger(SysApplicationRepositoryImpl.class);
    @Autowired
    private SysApplicationMapper sysApplicationMapper;

    public SysApplicationDo createApplicationInfo(SysApplicationDo sysApplicationDo) {
        SysApplicationPo sysApplicationPo = (SysApplicationPo)AuthRu.js((Object)sysApplicationDo, SysApplicationPo.class);
        this.sysApplicationMapper.insert(sysApplicationPo);
        return sysApplicationDo;
    }

    public SysApplicationDo modifyApplicationInfo(SysApplicationDo reqDo, SysApplicationQryBo qryBo) {
        SysApplicationPo sysApplicationPo = (SysApplicationPo)AuthRu.js((Object)reqDo, SysApplicationPo.class);
        SysApplicationPo wherePo = (SysApplicationPo)AuthRu.js((Object)qryBo, SysApplicationPo.class);
        this.sysApplicationMapper.updateBy(sysApplicationPo, wherePo);
        return reqDo;
    }

    public BasePageRspBo<SysApplicationDo> getApplicationPageList(SysApplicationQryBo qryBo) {
        SysApplicationPo sysApplicationPo = (SysApplicationPo)AuthRu.js((Object)qryBo, SysApplicationPo.class);
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<SysApplicationPo> listPage = this.sysApplicationMapper.getListPage(sysApplicationPo, (Page<SysApplicationPo>)page);
        BasePageRspBo rspDo = new BasePageRspBo();
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setRows(AuthRu.jsl(listPage, SysApplicationDo.class));
        return rspDo;
    }

    public SysApplicationDo getApplicationInfoDetails(SysApplicationQryBo qryBo) {
        SysApplicationPo sysApplicationPo = new SysApplicationPo();
        sysApplicationPo.setApplicationId(qryBo.getApplicationId());
        sysApplicationPo.setApplicationCode(qryBo.getApplicationCode());
        SysApplicationPo modelBy = this.sysApplicationMapper.getModelBy(sysApplicationPo);
        SysApplicationDo rspBo = (SysApplicationDo)AuthRu.js((Object)modelBy, SysApplicationDo.class);
        return rspBo;
    }
}

