/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.model.common.sub.SysRoleInfoSubDo;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgInfoQryBo;
import com.tydic.dyc.authority.model.organization.qrybo.SysOrgTagRelQryBo;
import com.tydic.dyc.authority.model.organization.sub.SysOrgTagRelSubDo;
import com.tydic.dyc.authority.repository.SysOrgInfoRepository;
import com.tydic.dyc.authority.repository.dao.SysAuthDistributeMapper;
import com.tydic.dyc.authority.repository.dao.SysOrgInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysOrgTagRelMapper;
import com.tydic.dyc.authority.repository.po.SysAuthDistributePo;
import com.tydic.dyc.authority.repository.po.SysOrgInfoPo;
import com.tydic.dyc.authority.repository.po.SysOrgTagRelPo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysOrgInfoRepositoryImpl
implements SysOrgInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(SysOrgInfoRepositoryImpl.class);
    @Autowired
    private SysOrgInfoMapper sysOrgInfoMapper;
    @Autowired
    private SysOrgTagRelMapper sysOrgTagRelMapper;
    @Autowired
    private SysAuthDistributeMapper sysAuthDistributeMapper;

    public SysOrgInfoDo createOrgInfo(SysOrgInfoDo sysOrgInfoDo) {
        SysOrgInfoPo sysOrgInfoPo = (SysOrgInfoPo)AuthRu.js((Object)sysOrgInfoDo, SysOrgInfoPo.class);
        this.sysOrgInfoMapper.insert(sysOrgInfoPo);
        if (!CollectionUtils.isEmpty((Collection)sysOrgInfoDo.getOrgTagList())) {
            List tagPoList = AuthRu.jsl((List)sysOrgInfoDo.getOrgTagList(), SysOrgTagRelPo.class);
            this.sysOrgTagRelMapper.insertBatch(tagPoList);
        }
        return sysOrgInfoDo;
    }

    public SysOrgInfoDo modifyOrgInfo(SysOrgInfoDo sysOrgInfoDo, SysOrgInfoQryBo qryBo) {
        SysOrgInfoPo sysOrgInfoPo = (SysOrgInfoPo)AuthRu.js((Object)sysOrgInfoDo, SysOrgInfoPo.class);
        SysOrgInfoPo wherePo = (SysOrgInfoPo)AuthRu.js((Object)qryBo, SysOrgInfoPo.class);
        this.sysOrgInfoMapper.updateBy(sysOrgInfoPo, wherePo);
        return sysOrgInfoDo;
    }

    public BasePageRspBo<SysOrgInfoDo> getOrgPageList(SysOrgInfoQryBo qryBo) {
        SysOrgInfoPo sysApplicationPo = (SysOrgInfoPo)AuthRu.js((Object)qryBo, SysOrgInfoPo.class);
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<SysOrgInfoPo> listPage = this.sysOrgInfoMapper.getListPage(sysApplicationPo, (Page<SysOrgInfoPo>)page);
        BasePageRspBo rspDo = new BasePageRspBo();
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setRows(AuthRu.jsl(listPage, SysOrgInfoDo.class));
        return rspDo;
    }

    public SysOrgInfoDo getOrgInfoDetails(SysOrgInfoQryBo qryBo) {
        SysOrgInfoPo wherePo = (SysOrgInfoPo)AuthRu.js((Object)qryBo, SysOrgInfoPo.class);
        SysOrgInfoPo modelBy = this.sysOrgInfoMapper.getModelBy(wherePo);
        SysOrgInfoDo rspBo = (SysOrgInfoDo)AuthRu.js((Object)modelBy, SysOrgInfoDo.class);
        return rspBo;
    }

    public List<SysOrgTagRelSubDo> getOrgTagList(SysOrgTagRelQryBo qryBo) {
        SysOrgTagRelPo wherePo = (SysOrgTagRelPo)AuthRu.js((Object)qryBo, SysOrgTagRelPo.class);
        List<SysOrgTagRelPo> list = this.sysOrgTagRelMapper.getList(wherePo);
        List rspBo = AuthRu.jsl(list, SysOrgTagRelSubDo.class);
        return rspBo;
    }

    public SysOrgInfoDo addOrgTagList(SysOrgInfoDo sysOrgInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)sysOrgInfoDo.getOrgTagList())) {
            List addPo = AuthRu.jsl((List)sysOrgInfoDo.getOrgTagList(), SysOrgTagRelPo.class);
            this.sysOrgTagRelMapper.insertBatch(addPo);
        }
        return sysOrgInfoDo;
    }

    public SysOrgInfoDo updateOrgTagList(SysOrgInfoDo sysOrgInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)sysOrgInfoDo.getOrgTagList())) {
            List updatePo = AuthRu.jsl((List)sysOrgInfoDo.getOrgTagList(), SysOrgTagRelPo.class);
            for (SysOrgTagRelPo po : updatePo) {
                SysOrgTagRelPo wherePo = new SysOrgTagRelPo();
                wherePo.setOrgId(po.getOrgId());
                wherePo.setTagId(po.getTagId());
                this.sysOrgTagRelMapper.updateBy(po, wherePo);
            }
        }
        return sysOrgInfoDo;
    }

    public SysOrgInfoDo addOrgRoleList(SysOrgInfoDo sysOrgInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)sysOrgInfoDo.getAuthDistributeList())) {
            List addPo = AuthRu.jsl((List)sysOrgInfoDo.getAuthDistributeList(), SysAuthDistributePo.class);
            this.sysAuthDistributeMapper.insertBatch(addPo);
        }
        return sysOrgInfoDo;
    }

    public SysOrgInfoDo updateOrgRoleList(SysOrgInfoDo sysOrgInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)sysOrgInfoDo.getAuthDistributeList())) {
            List updatePo = AuthRu.jsl((List)sysOrgInfoDo.getAuthDistributeList(), SysAuthDistributePo.class);
            for (SysAuthDistributePo po : updatePo) {
                SysAuthDistributePo wherePo = new SysAuthDistributePo();
                wherePo.setOrgTreePath(po.getOrgTreePath());
                wherePo.setRoleId(po.getRoleId());
                this.sysAuthDistributeMapper.updateBy(po, wherePo);
            }
        }
        return sysOrgInfoDo;
    }

    public SysOrgInfoDo getRoleInfoListByOrg(SysOrgInfoDo sysOrgInfoDo) {
        SysAuthDistributePo roleListwherePo = new SysAuthDistributePo();
        ArrayList<SysRoleInfoSubDo> rspList = new ArrayList<SysRoleInfoSubDo>();
        roleListwherePo.setOrgTreePath(sysOrgInfoDo.getOrgTreePath());
        roleListwherePo.setOrgExtend(0);
        List<SysRoleInfoSubDo> orgRoleList = this.sysAuthDistributeMapper.getRoleListByOrg(roleListwherePo);
        if (!CollectionUtils.isEmpty(orgRoleList)) {
            rspList.addAll(orgRoleList);
        }
        roleListwherePo.setOrgTreePath(sysOrgInfoDo.getOrgTreePath());
        roleListwherePo.setOrgExtend(1);
        SysAuthDistributePo roleExtendListWherePo = new SysAuthDistributePo();
        List<SysRoleInfoSubDo> orgExtendRoleList = this.sysAuthDistributeMapper.getRoleListByOrg(roleExtendListWherePo);
        if (!CollectionUtils.isEmpty(orgExtendRoleList)) {
            for (SysRoleInfoSubDo extendRoleBO : orgExtendRoleList) {
                boolean newFlag = true;
                for (SysRoleInfoSubDo roleDo : orgRoleList) {
                    if (!roleDo.getRoleId().equals(extendRoleBO.getRoleId())) continue;
                    newFlag = false;
                    break;
                }
                if (!newFlag) continue;
                rspList.add(extendRoleBO);
            }
        }
        sysOrgInfoDo.setOrgRoleList(rspList);
        return sysOrgInfoDo;
    }
}

