/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuPowerSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuRelSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleRolePowerSubDo;
import com.tydic.dyc.authority.repository.SysRoleInfoRepository;
import com.tydic.dyc.authority.repository.dao.SysAuthDistributeMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuPowerMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuRelMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleRolePowerMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleStationPowerMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleStationRelMapper;
import com.tydic.dyc.authority.repository.po.SysAuthDistributePo;
import com.tydic.dyc.authority.repository.po.SysRoleInfoPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuPowerPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuRelPo;
import com.tydic.dyc.authority.repository.po.SysRoleRolePowerPo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysRoleInfoRepositoryImpl
implements SysRoleInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(SysRoleInfoRepositoryImpl.class);
    @Autowired
    private SysRoleInfoMapper sysRoleInfoMapper;
    @Autowired
    private SysRoleMenuRelMapper sysRoleMenuRelMapper;
    @Autowired
    private SysRoleMenuPowerMapper sysRoleMenuPowerMapper;
    @Autowired
    private SysRoleStationRelMapper sysRoleStationRelMapper;
    @Autowired
    private SysRoleStationPowerMapper sysRoleStationPowerMapper;
    @Autowired
    private SysRoleRolePowerMapper sysRoleRolePowerMapper;
    @Autowired
    private SysAuthDistributeMapper sysAuthDistributeMapper;

    public SysRoleInfoDo createRoleInfo(SysRoleInfoDo sysRoleDo) {
        SysRoleInfoPo sysRoleInfoPo = (SysRoleInfoPo)AuthRu.js((Object)sysRoleDo, SysRoleInfoPo.class);
        this.sysRoleInfoMapper.insert(sysRoleInfoPo);
        return sysRoleDo;
    }

    public SysRoleInfoDo modifyRoleInfo(SysRoleInfoDo sysRoleInfoDo, SysRoleInfoQryBo qryBo) {
        SysRoleInfoPo sysRoleInfoPo = (SysRoleInfoPo)AuthRu.js((Object)sysRoleInfoDo, SysRoleInfoPo.class);
        SysRoleInfoPo wherePo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        this.sysRoleInfoMapper.updateBy(sysRoleInfoPo, wherePo);
        return sysRoleInfoDo;
    }

    public BasePageRspBo<SysRoleInfoDo> getRolePageList(SysRoleInfoQryBo qryBo) {
        SysRoleInfoPo sysApplicationPo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<SysRoleInfoPo> listPage = this.sysRoleInfoMapper.getListPage(sysApplicationPo, (Page<SysRoleInfoPo>)page);
        BasePageRspBo rspDo = new BasePageRspBo();
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setRows(AuthRu.jsl(listPage, SysRoleInfoDo.class));
        return rspDo;
    }

    public SysRoleInfoDo getRoleInfoDetails(SysRoleInfoQryBo qryBo) {
        SysRoleInfoPo wherePo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        SysRoleInfoPo modelBy = this.sysRoleInfoMapper.getModelBy(wherePo);
        SysRoleInfoDo rspBo = (SysRoleInfoDo)AuthRu.js((Object)modelBy, SysRoleInfoDo.class);
        return rspBo;
    }

    public SysRoleInfoDo addRoleMenuRel(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuRelList())) {
            List addPo = AuthRu.jsl((List)reqDo.getMenuRelList(), SysRoleMenuRelPo.class);
            this.sysRoleMenuRelMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateRoleMenuRel(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuRelList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getMenuRelList(), SysRoleMenuRelPo.class);
            for (SysRoleMenuRelPo po : updatePo) {
                SysRoleMenuRelPo wherePo = new SysRoleMenuRelPo();
                wherePo.setMenuId(po.getMenuId());
                wherePo.setRoleId(po.getRoleId());
                this.sysRoleMenuRelMapper.updateBy(po, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getRoleMenuRelList(SysRoleInfoQryBo reqDo) {
        SysRoleMenuRelPo wherePo = new SysRoleMenuRelPo();
        wherePo.setRoleId(reqDo.getRoleId());
        List<SysRoleMenuRelPo> poList = this.sysRoleMenuRelMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysRoleMenuRelSubDo.class);
        rspBo.setMenuRelList(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo addRoleMenuPower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuPowerList())) {
            List addPo = AuthRu.jsl((List)reqDo.getMenuPowerList(), SysRoleMenuPowerPo.class);
            this.sysRoleMenuPowerMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateRoleMenuPower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuPowerList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getMenuPowerList(), SysRoleMenuPowerPo.class);
            for (SysRoleMenuPowerPo po : updatePo) {
                SysRoleMenuPowerPo wherePo = new SysRoleMenuPowerPo();
                wherePo.setMenuId(po.getMenuId());
                wherePo.setRoleId(po.getRoleId());
                this.sysRoleMenuPowerMapper.updateBy(po, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getRoleMenuPowerList(SysRoleInfoQryBo reqDo) {
        SysRoleMenuPowerPo wherePo = new SysRoleMenuPowerPo();
        wherePo.setRoleId(reqDo.getRoleId());
        List<SysRoleMenuPowerPo> poList = this.sysRoleMenuPowerMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysRoleMenuPowerSubDo.class);
        rspBo.setMenuPowerList(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo addRolePower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getRolePowerList())) {
            List addPo = AuthRu.jsl((List)reqDo.getRolePowerList(), SysRoleRolePowerPo.class);
            this.sysRoleRolePowerMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateRolePower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getRolePowerList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getRolePowerList(), SysRoleRolePowerPo.class);
            for (SysRoleRolePowerPo po : updatePo) {
                SysRoleRolePowerPo wherePo = new SysRoleRolePowerPo();
                wherePo.setPowerRoleId(po.getPowerRoleId());
                wherePo.setRoleId(po.getRoleId());
                this.sysRoleRolePowerMapper.updateBy(po, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getRolePowerList(SysRoleInfoQryBo reqDo) {
        SysRoleRolePowerPo wherePo = new SysRoleRolePowerPo();
        wherePo.setRoleId(reqDo.getRoleId());
        List<SysRoleRolePowerPo> poList = this.sysRoleRolePowerMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysRoleRolePowerSubDo.class);
        rspBo.setRolePowerList(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo addAuthDistribute(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getAuthDistributeList())) {
            List addPo = AuthRu.jsl((List)reqDo.getAuthDistributeList(), SysAuthDistributePo.class);
            this.sysAuthDistributeMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateAuthDistribute(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getAuthDistributeList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getAuthDistributeList(), SysAuthDistributePo.class);
            for (SysAuthDistributePo po : updatePo) {
                SysAuthDistributePo wherePo = new SysAuthDistributePo();
                wherePo.setUserId(po.getUserId());
                wherePo.setOrgTreePath(po.getOrgTreePath());
                wherePo.setRoleId(po.getRoleId());
                this.sysAuthDistributeMapper.updateBy(po, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getAuthDistributeList(SysRoleInfoQryBo reqDo) {
        SysAuthDistributePo wherePo = new SysAuthDistributePo();
        wherePo.setRoleId(reqDo.getRoleId());
        wherePo.setDisFlag(reqDo.getDisFlag());
        List<SysAuthDistributePo> poList = this.sysAuthDistributeMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysAuthDistributeSubDo.class);
        rspBo.setAuthDistributeList(subDoList);
        return rspBo;
    }
}

