/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.constants.AuthDicConstant;
import com.tydic.dyc.authority.model.common.sub.SysAuthDistributeSubDo;
import com.tydic.dyc.authority.model.common.sub.SysAuthRoleMenuDataOrgSubDo;
import com.tydic.dyc.authority.model.common.sub.SysRoleMenuBtnSubDo;
import com.tydic.dyc.authority.model.organization.SysOrgInfoDo;
import com.tydic.dyc.authority.model.role.SysRoleInfoDo;
import com.tydic.dyc.authority.model.role.qrybo.AuthSelectAlreadyAndNorUsersQryBo;
import com.tydic.dyc.authority.model.role.qrybo.SysAuthRoleUserSubRspBo;
import com.tydic.dyc.authority.model.role.qrybo.SysOrgInfoQryRspBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryAuthDataRspBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryBo;
import com.tydic.dyc.authority.model.role.qrybo.SysRoleInfoQryRspBo;
import com.tydic.dyc.authority.model.role.sub.AuthRoleUserSubDo;
import com.tydic.dyc.authority.model.role.sub.SysMenuSubDo;
import com.tydic.dyc.authority.model.role.sub.SysRoleMenuDataAuthSubDo;
import com.tydic.dyc.authority.repository.SysRoleInfoRepository;
import com.tydic.dyc.authority.repository.dao.SysAuthDistributeMapper;
import com.tydic.dyc.authority.repository.dao.SysMenuMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleInfoMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuBtnMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuDataAuthMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuDataOrgMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuPowerMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuRelMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleRolePowerMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleStationPowerMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleStationRelMapper;
import com.tydic.dyc.authority.repository.po.AuthRoleUserSubPo;
import com.tydic.dyc.authority.repository.po.AuthSelectAlreadyAndNorUsersQryPo;
import com.tydic.dyc.authority.repository.po.SysAuthDistributePo;
import com.tydic.dyc.authority.repository.po.SysMenuPo;
import com.tydic.dyc.authority.repository.po.SysOrgInfoPo;
import com.tydic.dyc.authority.repository.po.SysRoleInfoPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuBtnPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuDataAuthPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuDataOrgPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuPowerPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuRelPo;
import com.tydic.dyc.authority.repository.po.SysRoleRolePowerPo;
import com.tydic.dyc.authority.utils.AuthRu;
import com.tydic.dyc.authority.utils.IdUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SysRoleInfoRepositoryImpl
implements SysRoleInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(SysRoleInfoRepositoryImpl.class);
    @Autowired
    private SysRoleInfoMapper sysRoleInfoMapper;
    @Autowired
    private SysRoleMenuRelMapper sysRoleMenuRelMapper;
    @Autowired
    private SysRoleMenuPowerMapper sysRoleMenuPowerMapper;
    @Autowired
    private SysRoleStationRelMapper sysRoleStationRelMapper;
    @Autowired
    private SysRoleStationPowerMapper sysRoleStationPowerMapper;
    @Autowired
    private SysRoleRolePowerMapper sysRoleRolePowerMapper;
    @Autowired
    private SysAuthDistributeMapper sysAuthDistributeMapper;
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysRoleMenuBtnMapper sysRoleMenuBtnMapper;
    @Autowired
    private SysRoleMenuDataOrgMapper sysRoleMenuDataOrgMapper;
    @Autowired
    private SysRoleMenuDataAuthMapper sysRoleMenuDataAuthMapper;

    public SysRoleInfoDo createRoleInfo(SysRoleInfoDo sysRoleDo) {
        SysRoleInfoPo sysRoleInfoPo = (SysRoleInfoPo)AuthRu.js((Object)sysRoleDo, SysRoleInfoPo.class);
        sysRoleInfoPo.setRoleStatus("1");
        sysRoleInfoPo.setCustFlag("1");
        this.sysRoleInfoMapper.insert(sysRoleInfoPo);
        if (!CollectionUtils.isEmpty((Collection)sysRoleDo.getOrgIdList())) {
            List<SysAuthDistributePo> sysAuthDistributePoStream = sysRoleDo.getOrgIdList().stream().map(e -> {
                SysAuthDistributePo sysAuthDistributePo = new SysAuthDistributePo();
                sysAuthDistributePo.setAuthId(IdUtil.nextId());
                sysAuthDistributePo.setCreateOperId(sysRoleDo.getCreateOperId());
                sysAuthDistributePo.setRoleId(sysRoleDo.getRoleId());
                sysAuthDistributePo.setOrgId((Long)e);
                sysAuthDistributePo.setManageLevel(sysRoleDo.getManageLevel());
                sysAuthDistributePo.setOrgExtend(0);
                sysAuthDistributePo.setCreateTime(new Date());
                sysAuthDistributePo.setCreateOperName(sysRoleDo.getCreateOperName());
                sysAuthDistributePo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                return sysAuthDistributePo;
            }).collect(Collectors.toList());
            this.sysAuthDistributeMapper.insertBatch(sysAuthDistributePoStream);
        }
        return sysRoleDo;
    }

    public SysRoleInfoDo modifyRoleInfo(SysRoleInfoDo sysRoleInfoDo) {
        SysRoleInfoQryBo qryBo = new SysRoleInfoQryBo();
        qryBo.setRoleId(sysRoleInfoDo.getRoleId());
        SysRoleInfoPo sysRoleInfoPo = (SysRoleInfoPo)AuthRu.js((Object)sysRoleInfoDo, SysRoleInfoPo.class);
        SysRoleInfoPo wherePo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        this.sysRoleInfoMapper.updateBy(sysRoleInfoPo, wherePo);
        if (!StringUtils.isEmpty((Object)qryBo.getRoleId())) {
            if (!CollectionUtils.isEmpty((Collection)sysRoleInfoDo.getOrgIdListDelete())) {
                SysAuthDistributePo deleteWhere = new SysAuthDistributePo();
                SysAuthDistributePo deleteSet = new SysAuthDistributePo();
                deleteWhere.setRoleId(qryBo.getRoleId());
                deleteSet.setDelFlag("1");
                deleteWhere.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                deleteWhere.setOrgIdListDelete(sysRoleInfoDo.getOrgIdListDelete());
                this.sysAuthDistributeMapper.updateBy(deleteSet, deleteWhere);
            }
            if (!CollectionUtils.isEmpty((Collection)sysRoleInfoDo.getOrgIdList())) {
                List<SysAuthDistributePo> sysAuthDistributePoStream = sysRoleInfoDo.getOrgIdList().stream().map(e -> {
                    SysAuthDistributePo sysAuthDistributePo = new SysAuthDistributePo();
                    sysAuthDistributePo.setAuthId(IdUtil.nextId());
                    sysAuthDistributePo.setCreateOperId(sysRoleInfoDo.getCreateOperId());
                    sysAuthDistributePo.setRoleId(sysRoleInfoDo.getRoleId());
                    sysAuthDistributePo.setOrgId((Long)e);
                    sysAuthDistributePo.setDisFlag(AuthDicConstant.ROLE_DIS_FLAG.ORG);
                    sysAuthDistributePo.setOrgExtend(0);
                    sysAuthDistributePo.setCreateTime(new Date());
                    sysAuthDistributePo.setCreateOperName(sysRoleInfoDo.getUpdateOperName());
                    sysAuthDistributePo.setDisAgFlag(AuthDicConstant.DIS_AG_FLAG.ONLY_DISTRIBUTE);
                    sysAuthDistributePo.setOrgTreePath(sysRoleInfoDo.getOrgTreePath());
                    return sysAuthDistributePo;
                }).collect(Collectors.toList());
                this.sysAuthDistributeMapper.insertBatch(sysAuthDistributePoStream);
            }
        }
        return sysRoleInfoDo;
    }

    public SysRoleInfoQryRspBo getRolePageList(SysRoleInfoQryBo qryBo) {
        SysRoleInfoPo sysApplicationPo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        sysApplicationPo.setOrderBy("role_type asc,s.update_time desc");
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<SysRoleInfoPo> listPage = this.sysRoleInfoMapper.getListPage(sysApplicationPo, (Page<SysRoleInfoPo>)page);
        SysRoleInfoQryRspBo rspDo = new SysRoleInfoQryRspBo();
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setRows(AuthRu.jsl(listPage, SysRoleInfoDo.class));
        return rspDo;
    }

    public SysRoleInfoDo getRoleInfoDetails(SysRoleInfoQryBo qryBo) {
        SysRoleInfoPo wherePo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        SysRoleInfoPo modelBy = this.sysRoleInfoMapper.getModelBy(wherePo);
        SysRoleInfoDo rspBo = (SysRoleInfoDo)AuthRu.js((Object)modelBy, SysRoleInfoDo.class);
        return rspBo;
    }

    public SysRoleInfoDo addRoleMenuRel(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuRelList())) {
            List addPo = AuthRu.jsl((List)reqDo.getMenuRelList(), SysRoleMenuRelPo.class);
            this.sysRoleMenuRelMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateRoleMenuRel(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuRelList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getMenuRelList(), SysRoleMenuRelPo.class);
            for (SysRoleMenuRelPo po : updatePo) {
                SysRoleMenuRelPo wherePo = new SysRoleMenuRelPo();
                wherePo.setMenuId(po.getMenuId());
                wherePo.setRoleId(po.getRoleId());
                SysRoleMenuRelPo setPo = new SysRoleMenuRelPo();
                setPo.setDelFlag(po.getDelFlag());
                this.sysRoleMenuRelMapper.updateBy(setPo, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getRoleMenuRelList(SysRoleInfoQryBo reqDo) {
        SysMenuPo wherePo = new SysMenuPo();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(reqDo.getRoleId());
        wherePo.setRoleIdList(roleIds);
        wherePo.setApplicationCode(reqDo.getApplicationCode());
        List<SysMenuPo> poList = this.sysMenuMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysMenuSubDo.class);
        rspBo.setMenuList(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo addRoleMenuPower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuPowerList())) {
            List addPo = AuthRu.jsl((List)reqDo.getMenuPowerList(), SysRoleMenuPowerPo.class);
            this.sysRoleMenuPowerMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateRoleMenuPower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getMenuPowerList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getMenuPowerList(), SysRoleMenuPowerPo.class);
            for (SysRoleMenuPowerPo po : updatePo) {
                SysRoleMenuPowerPo wherePo = new SysRoleMenuPowerPo();
                wherePo.setMenuId(po.getMenuId());
                wherePo.setRoleId(po.getRoleId());
                SysRoleMenuPowerPo setPo = new SysRoleMenuPowerPo();
                setPo.setDelFlag("1");
                this.sysRoleMenuPowerMapper.updateBy(setPo, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getRoleMenuPowerList(SysRoleInfoQryBo reqDo) {
        SysMenuPo wherePo = new SysMenuPo();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(reqDo.getRoleId());
        wherePo.setPowerRoleIdList(roleIds);
        wherePo.setApplicationCode(reqDo.getApplicationCode());
        List<SysMenuPo> poList = this.sysMenuMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysMenuSubDo.class);
        rspBo.setMenuList(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo addRolePower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getRolePowerList())) {
            List addPo = AuthRu.jsl((List)reqDo.getRolePowerList(), SysRoleRolePowerPo.class);
            this.sysRoleRolePowerMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateRolePower(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getRolePowerList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getRolePowerList(), SysRoleRolePowerPo.class);
            for (SysRoleRolePowerPo po : updatePo) {
                SysRoleRolePowerPo wherePo = new SysRoleRolePowerPo();
                wherePo.setPowerRoleId(po.getPowerRoleId());
                wherePo.setRoleId(po.getRoleId());
                this.sysRoleRolePowerMapper.updateBy(po, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getRolePowerList(SysRoleInfoQryBo reqDo) {
        SysRoleInfoPo wherePo = new SysRoleInfoPo();
        ArrayList<Long> roleIds = new ArrayList<Long>();
        roleIds.add(reqDo.getRoleId());
        wherePo.setRoleIdList(roleIds);
        wherePo.setRoleName(reqDo.getRoleName());
        List<SysRoleInfoPo> poList = this.sysRoleInfoMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysRoleInfoDo.class);
        rspBo.setPowerRoleList(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo addAuthDistribute(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getAuthDistributeList())) {
            List addPo = AuthRu.jsl((List)reqDo.getAuthDistributeList(), SysAuthDistributePo.class);
            this.sysAuthDistributeMapper.insertBatch(addPo);
        }
        return reqDo;
    }

    public SysRoleInfoDo updateAuthDistribute(SysRoleInfoDo reqDo) {
        if (!CollectionUtils.isEmpty((Collection)reqDo.getAuthDistributeList())) {
            List updatePo = AuthRu.jsl((List)reqDo.getAuthDistributeList(), SysAuthDistributePo.class);
            for (SysAuthDistributePo po : updatePo) {
                SysAuthDistributePo wherePo = new SysAuthDistributePo();
                wherePo.setUserId(po.getUserId());
                wherePo.setOrgTreePath(po.getOrgTreePath());
                wherePo.setRoleId(po.getRoleId());
                this.sysAuthDistributeMapper.updateBy(po, wherePo);
            }
        }
        return reqDo;
    }

    public SysRoleInfoDo getAuthDistributeList(SysRoleInfoQryBo reqDo) {
        SysAuthDistributePo wherePo = new SysAuthDistributePo();
        if (!StringUtils.isEmpty((Object)reqDo.getRoleId())) {
            wherePo.setRoleId(reqDo.getRoleId());
        }
        wherePo.setDisFlag(reqDo.getDisFlag());
        wherePo.setDisAgFlag(reqDo.getDisAgFlag());
        wherePo.setOrgId(reqDo.getOrgId());
        List<SysAuthDistributePo> poList = this.sysAuthDistributeMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysAuthDistributeSubDo.class);
        rspBo.setAuthDistributeList(subDoList);
        return rspBo;
    }

    public SysOrgInfoQryRspBo getCheckDistributeList(SysRoleInfoQryBo reqDo) {
        SysAuthDistributePo wherePo = new SysAuthDistributePo();
        if (!StringUtils.isEmpty((Object)reqDo.getRoleId())) {
            wherePo.setRoleId(reqDo.getRoleId());
        }
        wherePo.setDisFlag(reqDo.getDisFlag());
        wherePo.setDisAgFlag(reqDo.getDisAgFlag());
        wherePo.setOrgId(reqDo.getOrgId());
        List<SysOrgInfoPo> poList = this.sysAuthDistributeMapper.getCheckDistributeList(wherePo);
        SysOrgInfoQryRspBo rspBo = new SysOrgInfoQryRspBo();
        List rspBos = AuthRu.jsl(poList, SysOrgInfoDo.class);
        rspBo.setRows(rspBos);
        return rspBo;
    }

    public SysRoleInfoDo getAuthRoleMenuDataOrgList(SysRoleInfoQryBo reqDo) {
        SysRoleMenuDataOrgPo wherePo = new SysRoleMenuDataOrgPo();
        wherePo.setRoleId(reqDo.getRoleId());
        wherePo.setMenuId(reqDo.getMenuId());
        wherePo.setOrgId(reqDo.getOrgId());
        wherePo.setAuthIds(reqDo.getAuthIds());
        List<SysRoleMenuDataOrgPo> poList = this.sysRoleMenuDataOrgMapper.getList(wherePo);
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysAuthRoleMenuDataOrgSubDo.class);
        rspBo.setAuthRoleMenuDataOrgList(subDoList);
        return rspBo;
    }

    public SysOrgInfoQryRspBo getRoleMenuDataList(SysRoleInfoQryBo reqDo) {
        SysRoleMenuDataOrgPo wherePo = new SysRoleMenuDataOrgPo();
        if (ObjectUtil.isNotEmpty((Object)reqDo.getRoleId())) {
            wherePo.setRoleId(reqDo.getRoleId());
        }
        if (ObjectUtil.isNotEmpty((Object)reqDo.getMenuId())) {
            wherePo.setMenuId(reqDo.getMenuId());
        }
        wherePo.setOrgId(reqDo.getOrgId());
        List<SysOrgInfoPo> poList = this.sysRoleMenuDataOrgMapper.getRoleMenuDataList(wherePo);
        SysOrgInfoQryRspBo rspBo = new SysOrgInfoQryRspBo();
        List subDoList = AuthRu.jsl(poList, SysOrgInfoDo.class);
        rspBo.setRows(subDoList);
        return rspBo;
    }

    public SysRoleInfoDo getAuthRoleMenuBtnList(SysRoleInfoQryBo reqDo) {
        List<SysRoleMenuBtnPo> list = this.sysRoleMenuBtnMapper.getListByRoleIds(reqDo.getRoleIds(), reqDo.getMenuId());
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(list, SysRoleMenuBtnSubDo.class);
        rspBo.setRoleMenuBtnList(subDoList);
        return rspBo;
    }

    public SysRoleInfoQryRspBo getRoleInfoListByRolePower(SysRoleInfoQryBo reqDo) {
        SysRoleInfoPo wherePo = new SysRoleInfoPo();
        wherePo.setRoleIdList(reqDo.getPowerRoleIdList());
        wherePo.setTenantId(reqDo.getTenantId());
        List<SysRoleInfoPo> poList = this.sysRoleInfoMapper.getList(wherePo);
        List sysRoleInfoDoList = AuthRu.jsl(poList, SysRoleInfoDo.class);
        SysRoleInfoQryRspBo sysRoleInfoQryRspBo = new SysRoleInfoQryRspBo();
        sysRoleInfoQryRspBo.setRows(sysRoleInfoDoList);
        return sysRoleInfoQryRspBo;
    }

    public SysAuthRoleUserSubRspBo selectAlreadyDistributeUser(AuthSelectAlreadyAndNorUsersQryBo qryBo) {
        List<AuthRoleUserSubPo> list = this.sysRoleInfoMapper.selectAlreadyDistributeUser((AuthSelectAlreadyAndNorUsersQryPo)AuthRu.js((Object)qryBo, AuthSelectAlreadyAndNorUsersQryPo.class));
        List authRoleUserSubDoList = AuthRu.jsl(list, AuthRoleUserSubDo.class);
        SysAuthRoleUserSubRspBo sysAuthRoleUserSubRspBo = new SysAuthRoleUserSubRspBo();
        sysAuthRoleUserSubRspBo.setAuthRoleUserSubDos(authRoleUserSubDoList);
        return sysAuthRoleUserSubRspBo;
    }

    public SysRoleInfoQryRspBo getRoleList(SysRoleInfoQryBo qryBo) {
        SysRoleInfoPo sysRoleInfoPo = (SysRoleInfoPo)AuthRu.js((Object)qryBo, SysRoleInfoPo.class);
        sysRoleInfoPo.setRoleIdList(qryBo.getRoleIds());
        List sysRoleInfoDoList = AuthRu.jsl(this.sysRoleInfoMapper.getRoleList(sysRoleInfoPo), SysRoleInfoDo.class);
        SysRoleInfoQryRspBo sysRoleInfoQryRspBo = new SysRoleInfoQryRspBo();
        sysRoleInfoQryRspBo.setRows(sysRoleInfoDoList);
        return sysRoleInfoQryRspBo;
    }

    public SysRoleInfoDo deleteRoleMenuBtnByRole(SysRoleInfoDo sysRoleInfoDo) {
        SysRoleMenuBtnPo where = new SysRoleMenuBtnPo();
        where.setRoleId(sysRoleInfoDo.getRoleId());
        where.setMenuIds(sysRoleInfoDo.getMenuIds());
        SysRoleMenuBtnPo set = new SysRoleMenuBtnPo();
        set.setDelFlag("1");
        this.sysRoleMenuBtnMapper.updateBy(set, where);
        return sysRoleInfoDo;
    }

    public SysRoleInfoDo deleteRoleMenuDataOrg(SysRoleInfoDo sysRoleInfoDo) {
        SysRoleMenuDataOrgPo where = new SysRoleMenuDataOrgPo();
        where.setRoleId(sysRoleInfoDo.getRoleId());
        where.setMenuIds(sysRoleInfoDo.getMenuIds());
        SysRoleMenuDataOrgPo set = new SysRoleMenuDataOrgPo();
        set.setDelFlag("1");
        this.sysRoleMenuDataOrgMapper.updateBy(set, where);
        return sysRoleInfoDo;
    }

    public SysRoleInfoDo deleteRoleMenuDataAuth(SysRoleInfoDo sysRoleInfoDo) {
        SysRoleMenuDataAuthPo where = new SysRoleMenuDataAuthPo();
        where.setRoleId(sysRoleInfoDo.getRoleId());
        where.setMenuIds(sysRoleInfoDo.getMenuIds());
        SysRoleMenuDataAuthPo set = new SysRoleMenuDataAuthPo();
        set.setDelFlag("1");
        this.sysRoleMenuDataAuthMapper.updateBy(set, where);
        return sysRoleInfoDo;
    }

    public SysRoleInfoQryAuthDataRspBo getRoleMenuDataAuthList(SysRoleInfoQryBo qryBo) {
        SysRoleMenuDataAuthPo sysRoleMenuDataAuthPo = new SysRoleMenuDataAuthPo();
        sysRoleMenuDataAuthPo.setMenuId(qryBo.getMenuId());
        sysRoleMenuDataAuthPo.setRoleIds(qryBo.getRoleIds());
        List<SysRoleMenuDataAuthPo> dataAuthPos = this.sysRoleMenuDataAuthMapper.getList(sysRoleMenuDataAuthPo);
        SysRoleInfoQryAuthDataRspBo rspBo = new SysRoleInfoQryAuthDataRspBo();
        rspBo.setRows(AuthRu.jsl(dataAuthPos, SysRoleMenuDataAuthSubDo.class));
        return rspBo;
    }

    public void addRoleMenuBtn(SysRoleInfoDo subDoList) {
        if (!CollectionUtils.isEmpty((Collection)subDoList.getRoleMenuBtnList())) {
            this.sysRoleMenuBtnMapper.insertBatch(AuthRu.jsl((List)subDoList.getRoleMenuBtnList(), SysRoleMenuBtnPo.class));
        }
    }

    public void addRoleMenuDataOrg(SysRoleInfoDo subDoList) {
        if (!CollectionUtils.isEmpty((Collection)subDoList.getAuthRoleMenuDataOrgList())) {
            this.sysRoleMenuDataOrgMapper.insertBatch(AuthRu.jsl((List)subDoList.getAuthRoleMenuDataOrgList(), SysRoleMenuDataOrgPo.class));
        }
    }

    public void addRoleMenuDataAuth(SysRoleInfoDo subDoList) {
        if (!CollectionUtils.isEmpty((Collection)subDoList.getRoleMenuDataAuths())) {
            this.sysRoleMenuDataAuthMapper.insertBatch(AuthRu.jsl((List)subDoList.getRoleMenuDataAuths(), SysRoleMenuDataAuthPo.class));
        }
    }

    public SysRoleInfoDo getRoleMenuRelListByRoleId(SysRoleInfoQryBo reqDo) {
        List<SysRoleMenuRelPo> poList = this.sysRoleMenuRelMapper.getList((SysRoleMenuRelPo)AuthRu.js((Object)reqDo, SysRoleMenuRelPo.class));
        SysRoleInfoDo rspBo = new SysRoleInfoDo();
        List subDoList = AuthRu.jsl(poList, SysMenuSubDo.class);
        rspBo.setMenuList(subDoList);
        return rspBo;
    }

    public void delMenuRoleRelByMenuIdAndRoleId(SysRoleInfoDo sysRoleInfoDo) {
        if (!CollectionUtils.isEmpty((Collection)sysRoleInfoDo.getMenuRelList())) {
            this.sysRoleMenuRelMapper.delByMenuIdAndRoleId(AuthRu.jsl((List)sysRoleInfoDo.getMenuRelList(), SysRoleMenuRelPo.class));
        }
    }
}

