/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.authority.model.tenant.SysTenantInfoDo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantApplicationRelQryBo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantInfoListRspBo;
import com.tydic.dyc.authority.model.tenant.qrybo.SysTenantInfoQryBo;
import com.tydic.dyc.authority.model.tenant.sub.SysApplicationSubDo;
import com.tydic.dyc.authority.repository.SysTenantRepository;
import com.tydic.dyc.authority.repository.dao.SysApplicationMapper;
import com.tydic.dyc.authority.repository.dao.SysTenantApplicationRelMapper;
import com.tydic.dyc.authority.repository.dao.SysTenantInfoMapper;
import com.tydic.dyc.authority.repository.po.SysApplicationPo;
import com.tydic.dyc.authority.repository.po.SysTenantApplicationRelPo;
import com.tydic.dyc.authority.repository.po.SysTenantInfoPo;
import com.tydic.dyc.authority.utils.AuthRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysTenantRepositoryImpl
implements SysTenantRepository {
    private static final Logger log = LoggerFactory.getLogger(SysTenantRepositoryImpl.class);
    @Autowired
    private SysTenantInfoMapper sysTenantInfoMapper;
    @Autowired
    private SysTenantApplicationRelMapper sysTenantApplicationRelMapper;
    @Autowired
    private SysApplicationMapper sysApplicationMapper;

    public SysTenantInfoDo createTenantInfo(SysTenantInfoDo reqDo) {
        SysTenantInfoPo sysTenantInfoPo = (SysTenantInfoPo)AuthRu.js((Object)reqDo, SysTenantInfoPo.class);
        this.sysTenantInfoMapper.insert(sysTenantInfoPo);
        return reqDo;
    }

    public SysTenantInfoDo modifyTenantInfo(SysTenantInfoDo reqDo) {
        SysTenantInfoPo sysApplicationPo = (SysTenantInfoPo)AuthRu.js((Object)reqDo, SysTenantInfoPo.class);
        SysTenantInfoPo wherePo = new SysTenantInfoPo();
        wherePo.setTenantId(reqDo.getTenantId());
        this.sysTenantInfoMapper.updateBy(sysApplicationPo, wherePo);
        return reqDo;
    }

    public SysTenantInfoListRspBo getTenantInfoPageList(SysTenantInfoQryBo qryBo) {
        SysTenantInfoPo sysTenantInfoPo = (SysTenantInfoPo)AuthRu.js((Object)qryBo, SysTenantInfoPo.class);
        Page page = new Page();
        page.setPageSize(qryBo.getPageSize());
        page.setPageNo(qryBo.getPageNo());
        List<SysTenantInfoPo> listPage = this.sysTenantInfoMapper.getListPage(sysTenantInfoPo, (Page<SysTenantInfoPo>)page);
        SysTenantInfoListRspBo rspDo = new SysTenantInfoListRspBo();
        rspDo.setPageNo(page.getPageNo());
        rspDo.setTotal(page.getTotalPages());
        rspDo.setRecordsTotal(page.getTotalCount());
        rspDo.setRows(AuthRu.jsl(listPage, SysTenantInfoDo.class));
        return rspDo;
    }

    public SysTenantInfoDo getTenantInfoDetails(SysTenantInfoQryBo qryBo) {
        SysTenantInfoPo sysTenantInfoPo = (SysTenantInfoPo)AuthRu.js((Object)qryBo, SysTenantInfoPo.class);
        SysTenantInfoPo modelBy = this.sysTenantInfoMapper.getModelBy(sysTenantInfoPo);
        SysTenantInfoDo rspBo = (SysTenantInfoDo)AuthRu.js((Object)modelBy, SysTenantInfoDo.class);
        return rspBo;
    }

    public SysTenantInfoDo addTenantApplicationRel(SysTenantInfoDo reqDo) {
        List sysTenantApplicationRelPoList = AuthRu.jsl((List)reqDo.getTenantApplicationRelList(), SysTenantApplicationRelPo.class);
        this.sysTenantApplicationRelMapper.insertBatch(sysTenantApplicationRelPoList);
        return reqDo;
    }

    public SysTenantInfoDo updateTenantApplicationRel(SysTenantInfoDo reqDo) {
        List sysApplicationPoList = AuthRu.jsl((List)reqDo.getTenantApplicationRelList(), SysTenantApplicationRelPo.class);
        for (SysTenantApplicationRelPo updatePo : sysApplicationPoList) {
            SysTenantApplicationRelPo wherePo = new SysTenantApplicationRelPo();
            wherePo.setApplicationId(updatePo.getApplicationId());
            wherePo.setTenantId(reqDo.getTenantId());
            this.sysTenantApplicationRelMapper.updateBy(updatePo, wherePo);
        }
        return reqDo;
    }

    public SysTenantInfoDo getTenantApplicationRelList(SysTenantApplicationRelQryBo qryBo) {
        SysTenantApplicationRelPo sysTenantApplicationRelPo = (SysTenantApplicationRelPo)AuthRu.js((Object)qryBo, SysTenantApplicationRelPo.class);
        List<SysApplicationPo> list = this.sysApplicationMapper.getListByTenantId(sysTenantApplicationRelPo);
        List rspList = AuthRu.jsl(list, SysApplicationSubDo.class);
        SysTenantInfoDo sysTenantInfoDo = new SysTenantInfoDo();
        sysTenantInfoDo.setSysApplicationSubDos(rspList);
        return sysTenantInfoDo;
    }

    public List<SysTenantInfoDo> getList(SysTenantInfoDo sysTenantInfoDo) {
        SysTenantInfoPo sysTenantInfoPo = new SysTenantInfoPo();
        BeanUtils.copyProperties((Object)sysTenantInfoDo, (Object)sysTenantInfoPo);
        List<SysTenantInfoPo> sysTenantInfoPos = this.sysTenantInfoMapper.getList(sysTenantInfoPo);
        ArrayList<SysTenantInfoDo> sysTenantInfoDos = new ArrayList<SysTenantInfoDo>();
        if (!CollectionUtils.isEmpty(sysTenantInfoPos)) {
            sysTenantInfoPos.forEach(sysTenantInfo -> {
                SysTenantInfoDo tenantInfoDo = new SysTenantInfoDo();
                BeanUtils.copyProperties((Object)sysTenantInfo, (Object)tenantInfoDo);
                sysTenantInfoDos.add(tenantInfoDo);
            });
        }
        return sysTenantInfoDos;
    }
}

