/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.authority.repository.impl;

import com.tydic.dyc.authority.model.menu.SysMenuDo;
import com.tydic.dyc.authority.model.menu.qrybo.SysMenuQryBo;
import com.tydic.dyc.authority.model.menu.sub.SysMenuBtnDo;
import com.tydic.dyc.authority.model.menu.sub.SysMenuDomainSubDo;
import com.tydic.dyc.authority.model.menu.sub.SysRoleMenuBtnDo;
import com.tydic.dyc.authority.repository.SysMenuRepository;
import com.tydic.dyc.authority.repository.dao.SysMenuBtnMapper;
import com.tydic.dyc.authority.repository.dao.SysMenuDomainMapper;
import com.tydic.dyc.authority.repository.dao.SysMenuMapper;
import com.tydic.dyc.authority.repository.dao.SysRoleMenuBtnMapper;
import com.tydic.dyc.authority.repository.po.SysMenuBtnPo;
import com.tydic.dyc.authority.repository.po.SysMenuDomainPo;
import com.tydic.dyc.authority.repository.po.SysMenuPo;
import com.tydic.dyc.authority.repository.po.SysRoleMenuBtnPo;
import com.tydic.dyc.authority.utils.AuthRu;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuRepositoryImpl
implements SysMenuRepository {
    private static final Logger log = LoggerFactory.getLogger(SysMenuRepositoryImpl.class);
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysMenuDomainMapper sysMenuDomainMapper;
    @Autowired
    private SysMenuBtnMapper sysMenuBtnMapper;
    @Autowired
    private SysRoleMenuBtnMapper sysRoleMenuBtnMapper;

    public SysMenuDo createMenuInfo(SysMenuDo reqDo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)reqDo, SysMenuPo.class);
        SysMenuPo countWherePo = new SysMenuPo();
        if (sysMenuPo.getParentId() != null) {
            countWherePo.setParentId(sysMenuPo.getParentId());
        } else {
            countWherePo.setParentIdNull(0L);
        }
        int menuCount = this.sysMenuMapper.getCheckBy(countWherePo);
        sysMenuPo.setSort(menuCount + 1);
        this.sysMenuMapper.insert(sysMenuPo);
        return reqDo;
    }

    public SysMenuDo modifyMenuInfo(SysMenuDo reqDo, SysMenuQryBo qryBo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)reqDo, SysMenuPo.class);
        SysMenuPo wherePo = (SysMenuPo)AuthRu.js((Object)qryBo, SysMenuPo.class);
        this.sysMenuMapper.updateBy(sysMenuPo, wherePo);
        return reqDo;
    }

    public List<SysMenuDo> getMenuList(SysMenuQryBo qryBo) {
        SysMenuPo sysMenuPo = (SysMenuPo)AuthRu.js((Object)qryBo, SysMenuPo.class);
        sysMenuPo.setOrderBy("deep,sort");
        List<SysMenuPo> listPage = this.sysMenuMapper.getList(sysMenuPo);
        List rspDo = AuthRu.jsl(listPage, SysMenuDo.class);
        return rspDo;
    }

    public SysMenuDo getMenuInfoDetails(SysMenuQryBo qryBo) {
        SysMenuPo sysMenuPo = new SysMenuPo();
        sysMenuPo.setMenuId(qryBo.getMenuId());
        sysMenuPo.setParentId(qryBo.getParentId());
        sysMenuPo.setSort(qryBo.getSort());
        SysMenuPo modelBy = this.sysMenuMapper.getModelBy(sysMenuPo);
        SysMenuDo rspBo = (SysMenuDo)AuthRu.js((Object)modelBy, SysMenuDo.class);
        return rspBo;
    }

    public List<SysMenuDomainSubDo> getMenuDomainList() {
        SysMenuDomainPo sysMenuDomainPo = new SysMenuDomainPo();
        List<SysMenuDomainPo> list = this.sysMenuDomainMapper.getList(sysMenuDomainPo);
        return AuthRu.jsl(list, SysMenuDomainSubDo.class);
    }

    public void updateSortBatch(List<SysMenuDo> sysMenuDos) {
        List sysMenuPos = AuthRu.jsl(sysMenuDos, SysMenuPo.class);
        for (SysMenuPo sysMenuPo : sysMenuPos) {
            this.sysMenuMapper.updateById(sysMenuPo);
        }
    }

    public List<SysMenuBtnDo> getMenuBtnList(SysMenuQryBo qryBo) {
        SysMenuBtnPo sysMenuBtnPo = new SysMenuBtnPo();
        sysMenuBtnPo.setMenuId(qryBo.getMenuId());
        List<SysMenuBtnPo> list = this.sysMenuBtnMapper.getList(sysMenuBtnPo);
        return AuthRu.jsl(list, SysMenuBtnDo.class);
    }

    public List<SysRoleMenuBtnDo> getRoleMenuBtnList(SysMenuQryBo qryBo) {
        SysRoleMenuBtnPo sysRoleMenuBtnPo = new SysRoleMenuBtnPo();
        sysRoleMenuBtnPo.setRoleId(qryBo.getRoleId());
        sysRoleMenuBtnPo.setMenuId(qryBo.getMenuId());
        List<SysRoleMenuBtnPo> list = this.sysRoleMenuBtnMapper.getList(sysRoleMenuBtnPo);
        return AuthRu.jsl(list, SysRoleMenuBtnDo.class);
    }
}

