/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.station;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.mzlion.easyokhttp.HttpClient;
import com.mzlion.easyokhttp.request.PostRequest;
import com.mzlion.easyokhttp.response.HttpResponse;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.station.bo.AddStationBindReqBO;
import com.ohaotian.authority.station.bo.AddStationConfigReqBO;
import com.ohaotian.authority.station.bo.DataSourceRspBO;
import com.ohaotian.authority.station.bo.DeleteStationBindByIdReqBO;
import com.ohaotian.authority.station.bo.DeleteStationConfigReqBO;
import com.ohaotian.authority.station.bo.SelectByBusiCodeAndSourceTypeReqBO;
import com.ohaotian.authority.station.bo.SelectListDataSourceReqBO;
import com.ohaotian.authority.station.bo.SelectStaConfigByStaCodeReqBO;
import com.ohaotian.authority.station.bo.SelectStationBindReqBO;
import com.ohaotian.authority.station.bo.SelectStationBusiByCodeReqBO;
import com.ohaotian.authority.station.bo.SelectStationBusiByCodeRspBO;
import com.ohaotian.authority.station.bo.SelectStationConfigByIdReqBO;
import com.ohaotian.authority.station.bo.SelectStationConfigByIdRspBO;
import com.ohaotian.authority.station.bo.SelectStationSourceRspBO;
import com.ohaotian.authority.station.bo.SelectTreeDataSourceReqBO;
import com.ohaotian.authority.station.bo.StationConfigBO;
import com.ohaotian.authority.station.bo.UpdateStationConfigReqBO;
import com.ohaotian.authority.station.service.AddStationBindService;
import com.ohaotian.authority.station.service.AddStationConfigService;
import com.ohaotian.authority.station.service.DeleteStationBindByIdService;
import com.ohaotian.authority.station.service.SelectByBusiCodeAndSourceTypeService;
import com.ohaotian.authority.station.service.SelectStaConfigByStaCodeService;
import com.ohaotian.authority.station.service.SelectStationBindPageService;
import com.ohaotian.authority.station.service.SelectStationBusiByCodeService;
import com.ohaotian.authority.station.service.SelectStationBusinessService;
import com.ohaotian.authority.station.service.SelectStationConfigByIdService;
import com.ohaotian.authority.station.service.UpdateStationConfigService;
import com.ohaotian.authority.utils.DecodeResponseUtils;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/stationConfig"}, method={RequestMethod.GET, RequestMethod.POST})
public class StationConfigController {
    public static final Logger logger = LoggerFactory.getLogger(StationConfigController.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private AddStationConfigService addStationConfigService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UpdateStationConfigService updateStationConfigService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectStaConfigByStaCodeService selectStaConfigByStaCodeService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectByBusiCodeAndSourceTypeService selectByBusiCodeAndSourceTypeService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectStationBusiByCodeService selectStationBusiByCodeService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectStationBusinessService selectStationBusinessService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectStationConfigByIdService selectStationConfigByIdService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private AddStationBindService addStationBindService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private DeleteStationBindByIdService deleteStationBindByIdService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectStationBindPageService selectStationBindPageService;

    @RequestMapping(value={"/add"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u914d\u7f6e\u6570\u636e\u6743\u9650", operat="\u65b0\u589e")
    public Object addStationConfig(AddStationConfigReqBO addStationConfigReqBO, final HttpServletRequest request) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u65b0\u589e\u6570\u636e\u6743\u9650\uff01");
        }
        LinkedHashSet<String> dataIds = new LinkedHashSet<String>();
        dataIds.add(addStationConfigReqBO.getDataId());
        final HashMap<String, String> dataNames = new HashMap<String, String>();
        dataNames.put(addStationConfigReqBO.getDataId(), addStationConfigReqBO.getDataName());
        if (addStationConfigReqBO.getIsthrough() == 0) {
            SelectByBusiCodeAndSourceTypeReqBO reqBO = new SelectByBusiCodeAndSourceTypeReqBO();
            reqBO.setBusiCode(addStationConfigReqBO.getBusiCode());
            reqBO.setSourceTypeCode(addStationConfigReqBO.getSourceTypeCode());
            SelectStationSourceRspBO selectStationSourceRspBO = this.selectByBusiCodeAndSourceTypeService.selectByBusiCodeAndSourceType(reqBO);
            if (selectStationSourceRspBO != null && StringUtils.isNotEmpty((CharSequence)selectStationSourceRspBO.getUrl())) {
                final String url = selectStationSourceRspBO.getUrl();
                class InnerThrow {
                    private Set<String> throwIds = new LinkedHashSet<String>();

                    InnerThrow() {
                    }

                    public Set<String> queryThrowIds(String parentId) {
                        this.throwIds.add(parentId);
                        HttpResponse responseData = ((PostRequest)HttpClient.post((String)url).header("auth-token", request.getHeader("auth-token"))).param("parentId", parentId).execute();
                        List dateSourceRspBOS = DecodeResponseUtils.decodeResponse(responseData, List.class);
                        if (dateSourceRspBOS != null && dateSourceRspBOS.size() > 0) {
                            for (JSONObject bo : dateSourceRspBOS) {
                                DataSourceRspBO dataSourceRspBO = (DataSourceRspBO)bo.toJavaObject(DataSourceRspBO.class);
                                dataNames.put(dataSourceRspBO.getDataId(), dataSourceRspBO.getDataName());
                                if (dataSourceRspBO.getHadSublevel().booleanValue()) {
                                    this.queryThrowIds(dataSourceRspBO.getDataId());
                                    continue;
                                }
                                this.throwIds.add(dataSourceRspBO.getDataId());
                            }
                        }
                        return this.throwIds;
                    }
                }
                Set<String> strings = new InnerThrow().queryThrowIds(addStationConfigReqBO.getDataId());
                dataIds.addAll(strings);
            }
        }
        for (String dataId : dataIds) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addStationConfigReqBO.setAuthId(Long.valueOf(l));
            addStationConfigReqBO.setDataId(dataId);
            addStationConfigReqBO.setDataName((String)dataNames.get(dataId));
            this.addStationConfigService.addStationConfig(addStationConfigReqBO);
            try {
                SelectStationBusiByCodeReqBO selectStationBusiByCodeReqBO = new SelectStationBusiByCodeReqBO();
                selectStationBusiByCodeReqBO.setBusiCode(addStationConfigReqBO.getBusiCode());
                SelectStationBusiByCodeRspBO rspBO = this.selectStationBusiByCodeService.selectStationBusiByCode(selectStationBusiByCodeReqBO);
                if (rspBO.getStationBusinessBO() == null || !StringUtils.isNotEmpty((CharSequence)rspBO.getStationBusinessBO().getWebhook())) continue;
                HttpClient.post((String)rspBO.getStationBusinessBO().getWebhook()).param("actionType", "add").param("stationConfigId", addStationConfigReqBO.getAuthId().toString()).param("stationCode", addStationConfigReqBO.getStationCode()).param("sourceTypeCode", addStationConfigReqBO.getSourceTypeCode()).param("busiCode", addStationConfigReqBO.getBusiCode()).param("dataId", addStationConfigReqBO.getDataId()).param("dataName", addStationConfigReqBO.getDataName()).execute();
            }
            catch (Exception e) {
                logger.error("webhook\u63a8\u9001\u4e1a\u52a1" + addStationConfigReqBO.getBusiCode() + "\u6570\u636e\u6743\u9650\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38");
                e.printStackTrace();
            }
        }
        return null;
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u914d\u7f6e\u6570\u636e\u6743\u9650", operat="\u5220\u9664")
    public Object delete(DeleteStationConfigReqBO deleteStationConfigReqBO) {
        UpdateStationConfigReqBO updateStationConfigReqBO = new UpdateStationConfigReqBO();
        updateStationConfigReqBO.setAuthId(deleteStationConfigReqBO.getAuthId());
        updateStationConfigReqBO.setStatus(Integer.valueOf(1));
        this.updateStationConfigService.updateStationConfig(updateStationConfigReqBO);
        try {
            SelectStationConfigByIdReqBO selectStationConfigByIdReqBO = new SelectStationConfigByIdReqBO();
            selectStationConfigByIdReqBO.setStationConfigId(deleteStationConfigReqBO.getAuthId());
            SelectStationConfigByIdRspBO selectStationConfigByIdRspBO = this.selectStationConfigByIdService.selStationConfigById(selectStationConfigByIdReqBO);
            StationConfigBO stationConfigBO = selectStationConfigByIdRspBO.getStationConfigBO();
            if (stationConfigBO != null) {
                SelectStationBusiByCodeReqBO selectStationBusiByCodeReqBO = new SelectStationBusiByCodeReqBO();
                selectStationBusiByCodeReqBO.setBusiCode(stationConfigBO.getBusiCode());
                SelectStationBusiByCodeRspBO rspBO = this.selectStationBusiByCodeService.selectStationBusiByCode(selectStationBusiByCodeReqBO);
                if (rspBO.getStationBusinessBO() != null && StringUtils.isNotEmpty((CharSequence)rspBO.getStationBusinessBO().getWebhook())) {
                    HttpClient.post((String)rspBO.getStationBusinessBO().getWebhook()).param("actionType", "delete").param("stationConfigId", deleteStationConfigReqBO.getAuthId().toString()).param("stationCode", stationConfigBO.getStationCode()).param("sourceTypeCode", stationConfigBO.getSourceTypeCode()).param("busiCode", stationConfigBO.getBusiCode()).param("dataId", stationConfigBO.getDataId()).param("dataName", stationConfigBO.getDataName()).execute();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @RequestMapping(value={"/search"})
    @BusiResponseBody
    public Object search(SelectStaConfigByStaCodeReqBO selectStaConfigByStaCodeReqBO) {
        return this.selectStaConfigByStaCodeService.selectStaConfigByStaCode(selectStaConfigByStaCodeReqBO);
    }

    @RequestMapping(value={"/getListData"})
    @BusiResponseBody
    public Object getListData(SelectListDataSourceReqBO selectListDataSourceReqBO, HttpServletRequest request) throws Exception {
        HttpResponse responseData = ((PostRequest)HttpClient.post((String)selectListDataSourceReqBO.getUrl()).header("auth-token", request.getHeader("auth-token"))).param("record", selectListDataSourceReqBO.getRecord()).execute();
        List tenantRspBO = DecodeResponseUtils.decodeResponse(responseData, List.class);
        return tenantRspBO;
    }

    @RequestMapping(value={"/getTreeData"})
    @BusiResponseBody
    public Object getTreeData(SelectTreeDataSourceReqBO selectTreeDataSourceReqBO, HttpServletRequest request) {
        HttpResponse responseData = ((PostRequest)HttpClient.post((String)selectTreeDataSourceReqBO.getUrl()).header("auth-token", request.getHeader("auth-token"))).param("parentId", selectTreeDataSourceReqBO.getParentId()).param("record", selectTreeDataSourceReqBO.getRecord()).execute();
        List dateSourceRspBOS = DecodeResponseUtils.decodeResponse(responseData, List.class);
        return dateSourceRspBOS;
    }

    @RequestMapping(value={"/addBusinessBind"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ed1\u5b9a\u4e1a\u52a1", operat="\u65b0\u589e")
    public Object addStationBusiBind(AddStationBindReqBO addStationBindReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            throw new ZTBusinessException("\u673a\u6784\u7ba1\u7406\u5458\u65e0\u6cd5\u65b0\u589e\u4e1a\u52a1\u7ed1\u5b9a\uff01");
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        addStationBindReqBO.setAuthId(Long.valueOf(l));
        addStationBindReqBO.setCreateUserId(SecurityHelper.getCurrentUser().getUserId());
        this.addStationBindService.addStationBind(addStationBindReqBO);
        return null;
    }

    @RequestMapping(value={"/deleteBusinessBind"})
    @BusiResponseBody
    @BussinessLog(module="\u5c97\u4f4d\u7ed1\u5b9a\u4e1a\u52a1", operat="\u5220\u9664")
    public Object deleteBind(String authIds) {
        List longList = JSON.parseArray((String)authIds, Long.class);
        DeleteStationBindByIdReqBO reqBO = new DeleteStationBindByIdReqBO();
        reqBO.setAuthIds(longList);
        this.deleteStationBindByIdService.deleteStationBind(reqBO);
        return null;
    }

    @RequestMapping(value={"/selectBusinessBind"})
    @BusiResponseBody
    public Object selectBusinessBind(SelectStationBindReqBO reqBO) {
        return this.selectStationBindPageService.selectStationBind(reqBO);
    }
}

