/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.application;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.authority.application.bo.ChangeAppOrderReqBO;
import com.ohaotian.authority.application.bo.DeleteApplicationReqBO;
import com.ohaotian.authority.application.bo.SaveApplicationReqBO;
import com.ohaotian.authority.application.bo.SelectAppforUserHaveReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByIdReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByIdRspBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.UpdateApplicationByRecReqBO;
import com.ohaotian.authority.application.service.ChangeAppOrderDownBusiService;
import com.ohaotian.authority.application.service.ChangeAppOrderUpBusiService;
import com.ohaotian.authority.application.service.DeleteApplicationBusiServcie;
import com.ohaotian.authority.application.service.SaveApplicationBusiService;
import com.ohaotian.authority.application.service.SelectAllApplicationsBusiService;
import com.ohaotian.authority.application.service.SelectAppforUserHaveService;
import com.ohaotian.authority.application.service.SelectApplicationByIdBusiService;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.application.service.SelectByValidBusiService;
import com.ohaotian.authority.application.service.UpdateApplicationByRecBusiService;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.gray.bo.DeleteGrayByAppIdReqBO;
import com.ohaotian.authority.gray.bo.GraySwitchReqBO;
import com.ohaotian.authority.gray.service.DeleteGrayByAppIdBusiService;
import com.ohaotian.authority.gray.service.InsertGraySwitchService;
import com.ohaotian.authority.gray.service.UpdateGraySwitchByAppIdBusiService;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/application"}, method={RequestMethod.GET, RequestMethod.POST})
public class ApplicationController {
    private Logger logger = LoggerFactory.getLogger(ApplicationController.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectByValidBusiService selectByValidBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SaveApplicationBusiService saveApplicationBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectAllApplicationsBusiService selectAllApplicationsBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UpdateApplicationByRecBusiService updateApplicationByRecBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectApplicationByIdBusiService selectApplicationByIdBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private ChangeAppOrderUpBusiService changeAppOrderUpBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private ChangeAppOrderDownBusiService changeAppOrderDownBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private DeleteApplicationBusiServcie deleteApplicationBusiServcie;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private InsertGraySwitchService insertGraySwitchService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UpdateGraySwitchByAppIdBusiService updateGraySwitchByAppIdBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private DeleteGrayByAppIdBusiService deleteGrayByAppIdBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectAppforUserHaveService selectAppforUserHaveService;

    @RequestMapping(value={"/select"})
    @BusiResponseBody
    public Object selectValidApplication() {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectByValidBusiService.selectByValid();
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/save"})
    @BusiResponseBody
    @BussinessLog(module="\u5b50\u7cfb\u7edf\u7ba1\u7406", operat="\u65b0\u589e")
    public Object save(SaveApplicationReqBO saveApplicationReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            saveApplicationReqBO.setApplicationId(Long.valueOf(l));
            Long appId = this.saveApplicationBusiService.saveApplication(saveApplicationReqBO);
            GraySwitchReqBO graySwitchReqBO = new GraySwitchReqBO();
            long l1 = sequence.nextId();
            graySwitchReqBO.setSwitchId(Long.valueOf(l1));
            graySwitchReqBO.setApplyId(appId);
            graySwitchReqBO.setContextPath(saveApplicationReqBO.getContentPath());
            graySwitchReqBO.setGrayDomain(saveApplicationReqBO.getGrayDomain());
            graySwitchReqBO.setStatus(Constants.COMMON_INVALID_STATUS);
            graySwitchReqBO.setOperater(SecurityHelper.getCurrentUser().getUserId());
            graySwitchReqBO.setOperatingTime(new Date());
            this.insertGraySwitchService.InsertGraySwitchService(graySwitchReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/list"})
    @BusiResponseBody
    public Object selectApplicationPage() {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectAllApplicationsBusiService.selectAllApplys();
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u5b50\u7cfb\u7edf\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(UpdateApplicationByRecReqBO updateApplicationByRecReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            SelectApplicationByIdReqBO reqBO = new SelectApplicationByIdReqBO();
            reqBO.setApplicationId(updateApplicationByRecReqBO.getApplicationId());
            SelectApplicationByIdRspBO rspBO = this.selectApplicationByIdBusiService.selectApplicationById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
            this.updateApplicationByRecBusiService.updateApplicationByRecord(updateApplicationByRecReqBO);
            GraySwitchReqBO graySwitchReqBO = new GraySwitchReqBO();
            graySwitchReqBO.setApplyId(updateApplicationByRecReqBO.getApplicationId());
            graySwitchReqBO.setContextPath(updateApplicationByRecReqBO.getContentPath());
            graySwitchReqBO.setGrayDomain(updateApplicationByRecReqBO.getGrayDomain());
            graySwitchReqBO.setOperater(SecurityHelper.getCurrentUser().getUserId());
            graySwitchReqBO.setOperatingTime(new Date());
            this.updateGraySwitchByAppIdBusiService.updateGarySwitch(graySwitchReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/selectById"})
    @BusiResponseBody
    public Object selectById(SelectApplicationByIdReqBO selectApplicationByIdReqBO) {
        return this.selectApplicationByIdBusiService.selectApplicationById(selectApplicationByIdReqBO);
    }

    @RequestMapping(value={"/selectByUser"})
    @BusiResponseBody
    public Object selectByUser(@RequestBody SelectApplicationByUserReqBO applicationByUserReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (currentUser != null && currentUser.getTenantId() == null && !SecurityHelper.hasAuthority((String)"auth:system:manage") && !SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return null;
        }
        return this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
    }

    @RequestMapping(value={"/selectforUserHave"})
    @BusiResponseBody
    public Object selectforUserHave(SelectAppforUserHaveReqBO selectAppforUserHaveReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        if (currentUser != null && currentUser.getTenantId() == null && !SecurityHelper.hasAuthority((String)"auth:system:manage") && !SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            return null;
        }
        Map menus = SecurityHelper.getCurrentUser().getMenus();
        LinkedList<String> appCode = new LinkedList<String>();
        for (String key : menus.keySet()) {
            appCode.add(key);
        }
        selectAppforUserHaveReqBO.setAppCodeList(appCode);
        return this.selectAppforUserHaveService.selectAppforUser(selectAppforUserHaveReqBO);
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u5b50\u7cfb\u7edf\u7ba1\u7406", operat="\u505c\u7528")
    public Object delete(DeleteApplicationReqBO deleteApplicationReqBO) {
        UpdateApplicationByRecReqBO update = new UpdateApplicationByRecReqBO();
        update.setApplicationId(deleteApplicationReqBO.getApplicationId());
        update.setIsDel(Constants.COMMON_INVALID_STATUS);
        this.updateApplicationByRecBusiService.updateApplicationByRecord(update);
        return null;
    }

    @RequestMapping(value={"/selectByCode"})
    @BusiResponseBody
    public Object selectById(SelectByApplicationCodeReqBO selectByApplicationCodeReqBO) {
        return this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
    }

    @RequestMapping(value={"/reOpen"})
    @BusiResponseBody
    @BussinessLog(module="\u5b50\u7cfb\u7edf\u7ba1\u7406", operat="\u542f\u52a8")
    public Object reOpen(DeleteApplicationReqBO deleteApplicationReqBO) {
        UpdateApplicationByRecReqBO update = new UpdateApplicationByRecReqBO();
        update.setApplicationId(deleteApplicationReqBO.getApplicationId());
        update.setIsDel(Constants.COMMON_VALID_STATUS);
        this.updateApplicationByRecBusiService.updateApplicationByRecord(update);
        return null;
    }

    @RequestMapping(value={"/up"})
    @BusiResponseBody
    public Object up(ChangeAppOrderReqBO changeAppOrderReqBO) {
        this.changeAppOrderUpBusiService.changeAppOrderUp(changeAppOrderReqBO);
        return null;
    }

    @RequestMapping(value={"/down"})
    @BusiResponseBody
    public Object down(ChangeAppOrderReqBO changeAppOrderReqBO) {
        this.changeAppOrderDownBusiService.changeAppOrderDown(changeAppOrderReqBO);
        return null;
    }

    @RequestMapping(value={"phyDel"})
    @BusiResponseBody
    @BussinessLog(module="\u5b50\u7cfb\u7edf\u7ba1\u7406", operat="\u5220\u9664")
    public Object phyDel(DeleteApplicationReqBO deleteApplicationReqBO) {
        try {
            SelectApplicationByIdReqBO reqBO = new SelectApplicationByIdReqBO();
            reqBO.setApplicationId(deleteApplicationReqBO.getApplicationId());
            SelectApplicationByIdRspBO rspBO = this.selectApplicationByIdBusiService.selectApplicationById(reqBO);
            LogObjectHolder.me().set((Object)rspBO);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u5b50\u7cfb\u7edf", (Throwable)e);
        }
        this.deleteApplicationBusiServcie.deleteApplication(deleteApplicationReqBO);
        DeleteGrayByAppIdReqBO deleteGrayByAppIdReqBO = new DeleteGrayByAppIdReqBO();
        deleteGrayByAppIdReqBO.setApplicationId(deleteApplicationReqBO.getApplicationId());
        this.deleteGrayByAppIdBusiService.deleteGrayByAppId(deleteGrayByAppIdReqBO);
        return null;
    }
}

