/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.menu;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.log.LogObjectHolder;
import com.ohaotian.authority.menu.bo.AddMenuCatalogReqBO;
import com.ohaotian.authority.menu.bo.AddSublevelMenuReqBO;
import com.ohaotian.authority.menu.bo.ChangeMenuOrderReqBO;
import com.ohaotian.authority.menu.bo.ChangeMenuStatusReqBO;
import com.ohaotian.authority.menu.bo.DeleteMenuReqBO;
import com.ohaotian.authority.menu.bo.SaveMenusByOrgTreePathReqBO;
import com.ohaotian.authority.menu.bo.SelMenuTreeToManagerReqBO;
import com.ohaotian.authority.menu.bo.SelectDetailByMenuIdReqBO;
import com.ohaotian.authority.menu.bo.SelectDetailByMenuIdRspBO;
import com.ohaotian.authority.menu.bo.SelectMenuByPIdReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuCatalogReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeByOrgReqBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeByOrgRspBO;
import com.ohaotian.authority.menu.bo.SelectMenuTreeReqBO;
import com.ohaotian.authority.menu.bo.UpdateByMenuIdReqBO;
import com.ohaotian.authority.menu.service.AddMenuCatalogBusiService;
import com.ohaotian.authority.menu.service.AddSublevelMenuBusiService;
import com.ohaotian.authority.menu.service.ChangeMenuOrderDownBusiService;
import com.ohaotian.authority.menu.service.ChangeMenuOrderUpBusiService;
import com.ohaotian.authority.menu.service.ChangeMenuStatusBusiService;
import com.ohaotian.authority.menu.service.DeleteMenuBusiService;
import com.ohaotian.authority.menu.service.SaveMenusByOrgTreePathBusiService;
import com.ohaotian.authority.menu.service.SelMenuTreeToManagerBusiService;
import com.ohaotian.authority.menu.service.SelectAllMenuTreeBusiService;
import com.ohaotian.authority.menu.service.SelectDetailByMenuIdBusiService;
import com.ohaotian.authority.menu.service.SelectMenuByPIdBusiService;
import com.ohaotian.authority.menu.service.SelectMenuCatalogBusiService;
import com.ohaotian.authority.menu.service.SelectMenuTreeByOrgBusiService;
import com.ohaotian.authority.menu.service.SelectMenuTreeByUserBusiService;
import com.ohaotian.authority.menu.service.SelectMgrMenuTreeBusiService;
import com.ohaotian.authority.menu.service.UpdateByMenuIdBusiService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.security.entity.UserInfo;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/menu"}, method={RequestMethod.GET, RequestMethod.POST})
public class MenuController {
    private Logger logger = LoggerFactory.getLogger(MenuController.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectMenuCatalogBusiService selectMenuCatalogBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private AddMenuCatalogBusiService addMenuCatalogBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectDetailByMenuIdBusiService selectDetailByMenuIdBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectMenuByPIdBusiService selectMenuByPIdBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private AddSublevelMenuBusiService addSublevelMenuBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private UpdateByMenuIdBusiService updateByMenuIdBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private ChangeMenuStatusBusiService changeMenuStatusBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectAllMenuTreeBusiService selectAllMenuTreeBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectMgrMenuTreeBusiService selectMgrMenuTreeBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelMenuTreeToManagerBusiService selMenuTreeToManagerBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private DeleteMenuBusiService deleteMenuBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private ChangeMenuOrderUpBusiService changeMenuOrderUpBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private ChangeMenuOrderDownBusiService changeMenuOrderDownBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectMenuTreeByOrgBusiService selectMenuTreeByOrgBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SaveMenusByOrgTreePathBusiService saveMenusByOrgTreePathBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectMenuTreeByUserBusiService selectMenuTreeByUserBusiService;

    @RequestMapping(value={"/selectCatalog"})
    @BusiResponseBody
    public Object selectCatalog(@RequestBody SelectMenuCatalogReqBO selectMenuCatalogReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectMenuCatalogBusiService.selectMenuCatalog(selectMenuCatalogReqBO);
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/addCatalog"})
    @BusiResponseBody
    @BussinessLog(module="\u83dc\u5355\u7ba1\u7406", operat="\u65b0\u589e\u76ee\u5f55")
    public Object addCatalog(@RequestBody AddMenuCatalogReqBO addMenuCatalogReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addMenuCatalogReqBO.setMenuId(Long.valueOf(l));
            if (StringUtils.isEmpty((CharSequence)addMenuCatalogReqBO.getExtApplicationCode())) {
                addMenuCatalogReqBO.setExtApplicationCode(null);
            }
            this.addMenuCatalogBusiService.addMenuCatalog(addMenuCatalogReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/selectByMenuId"})
    @BusiResponseBody
    public Object selectByMenuId(@RequestBody SelectDetailByMenuIdReqBO selectDetailByMenuIdReqBO) {
        return this.selectDetailByMenuIdBusiService.selectDetailByMenuId(selectDetailByMenuIdReqBO);
    }

    @RequestMapping(value={"/selectByPId"})
    @BusiResponseBody
    public Object selectByPId(@RequestBody SelectMenuByPIdReqBO selectMenuByPIdReqBO) {
        return this.selectMenuByPIdBusiService.selectMenuByPId(selectMenuByPIdReqBO);
    }

    @RequestMapping(value={"/addSublevelMenu"})
    @BusiResponseBody
    @BussinessLog(module="\u83dc\u5355\u7ba1\u7406", operat="\u65b0\u589e")
    public Object addSublevelMenu(@RequestBody AddSublevelMenuReqBO addSublevelMenuReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            Sequence sequence = Sequence.getInstance();
            long l = sequence.nextId();
            addSublevelMenuReqBO.setMenuId(Long.valueOf(l));
            this.addSublevelMenuBusiService.addSublevelMenu(addSublevelMenuReqBO);
            return null;
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/update"})
    @BusiResponseBody
    @BussinessLog(module="\u83dc\u5355\u7ba1\u7406", operat="\u7f16\u8f91")
    public Object update(@RequestBody UpdateByMenuIdReqBO updateByMenuIdReqBO) {
        try {
            SelectDetailByMenuIdReqBO reqBO = new SelectDetailByMenuIdReqBO();
            reqBO.setMenuId(updateByMenuIdReqBO.getMenuId());
            SelectDetailByMenuIdRspBO rsp = this.selectDetailByMenuIdBusiService.selectDetailByMenuId(reqBO);
            LogObjectHolder.me().set((Object)rsp);
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91", (Throwable)e);
        }
        if (updateByMenuIdReqBO.getParentId() == 0L) {
            updateByMenuIdReqBO.setParentId(null);
        }
        this.updateByMenuIdBusiService.updateByMenuId(updateByMenuIdReqBO);
        return null;
    }

    @RequestMapping(value={"/changeStatus"})
    @BusiResponseBody
    @BussinessLog(module="\u83dc\u5355\u7ba1\u7406", operat="\u663e\u9690")
    public Object changeStatus(@RequestBody ChangeMenuStatusReqBO changeMenuStatusReqBO) {
        this.changeMenuStatusBusiService.changeMenuStatus(changeMenuStatusReqBO);
        return null;
    }

    @RequestMapping(value={"/selMenusByUser"})
    @BusiResponseBody
    public Object selectMenusByUser(@RequestBody SelectMenuTreeReqBO userMenusReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectAllMenuTreeBusiService.selectAllMenuTree(userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            userMenusReqBO.setRoleIdentity("auth:tenant:manage");
            return this.selectMgrMenuTreeBusiService.selectMgrMenuTree(userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:overall:manage")) {
            userMenusReqBO.setRoleIdentity("auth:overall:manage");
            return this.selectMgrMenuTreeBusiService.selectMgrMenuTree(userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            return this.selectMenusByOrgAdminAndUser("auth:org:manage", userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:innerorg:manage")) {
            return this.selectMenusByOrgAdminAndUser("auth:innerorg:manage", userMenusReqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:extorg:manage")) {
            return this.selectMenusByOrgAdminAndUser("auth:extorg:manage", userMenusReqBO);
        }
        throw new ZTBusinessException("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/selectMenusByOrgTreePath"})
    @BusiResponseBody
    public Object selectMenusByOrgTreePath(@RequestBody SelectMenuTreeByOrgReqBO reqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            reqBO.setRoleIdentity("auth:tenant:manage");
            return this.selectMenuTreeByOrgBusiService.select(reqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:org:manage")) {
            return this.selectMenusByOrgAdminAndOrgTreePath("auth:org:manage", reqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:innerorg:manage")) {
            return this.selectMenusByOrgAdminAndOrgTreePath("auth:innerorg:manage", reqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:extorg:manage")) {
            return this.selectMenusByOrgAdminAndOrgTreePath("auth:extorg:manage", reqBO);
        }
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            reqBO.setRoleIdentity("auth:system:manage");
            return this.selectMenuTreeByOrgBusiService.select(reqBO);
        }
        throw new ZTBusinessException("\u7528\u6237\u6743\u9650\u4e0d\u8db3");
    }

    @RequestMapping(value={"/configMenusByOrgTreePath"})
    @BusiResponseBody
    @BussinessLog(module="\u7ba1\u7406\u5458\u7ba1\u7406", operat="\u53d1\u5e03\u8d44\u6e90")
    public Object configMenusByOrgTreePath(@RequestBody SaveMenusByOrgTreePathReqBO reqBO) {
        this.saveMenusByOrgTreePathBusiService.save(reqBO);
        return null;
    }

    @RequestMapping(value={"/selMenusToManager"})
    @BusiResponseBody
    public Object selMenusToManager(@RequestBody SelMenuTreeToManagerReqBO selMenuTreeToManagerReqBO) {
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selMenuTreeToManagerBusiService.selMenuTreeToManager(selMenuTreeToManagerReqBO);
        }
        throw new ZTBusinessException("\u6743\u9650\u4e0d\u8db3\uff0c\u9700\u8981\u7cfb\u7edf\u7ba1\u7406\u5458\u6743\u9650");
    }

    @RequestMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u83dc\u5355\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(@RequestBody DeleteMenuReqBO deleteMenuReqBO) {
        try {
            SelectDetailByMenuIdReqBO reqBO = new SelectDetailByMenuIdReqBO();
            reqBO.setMenuId(deleteMenuReqBO.getMenuId());
            SelectDetailByMenuIdRspBO rsp = this.selectDetailByMenuIdBusiService.selectDetailByMenuId(reqBO);
            LogObjectHolder.me().set((Object)rsp);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664", (Throwable)e);
        }
        this.deleteMenuBusiService.deleteMenu(deleteMenuReqBO);
        return null;
    }

    @RequestMapping(value={"/up"})
    @BusiResponseBody
    public Object upOrder(@RequestBody ChangeMenuOrderReqBO changeMenuOrderReqBO) {
        this.changeMenuOrderUpBusiService.changeMenuOrderUp(changeMenuOrderReqBO);
        return null;
    }

    @RequestMapping(value={"/down"})
    @BusiResponseBody
    public Object downOrder(@RequestBody ChangeMenuOrderReqBO changeMenuOrderReqBO) {
        this.changeMenuOrderDownBusiService.changeMenuOrderDown(changeMenuOrderReqBO);
        return null;
    }

    private SelectMenuTreeByOrgRspBO selectMenusByOrgAdminAndUser(String orgAdminCode, SelectMenuTreeReqBO userMenusReqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        Long userId = currentUser.getUserId();
        SelectMenuTreeByOrgReqBO reqBO = new SelectMenuTreeByOrgReqBO();
        reqBO.setRoleIdentity(orgAdminCode);
        reqBO.setMgrUserId(userId);
        reqBO.setOrgTreePath(userMenusReqBO.getOrgTreePath());
        reqBO.setApplicationCode(userMenusReqBO.getApplicationCode());
        return this.selectMenuTreeByUserBusiService.select(reqBO);
    }

    private SelectMenuTreeByOrgRspBO selectMenusByOrgAdminAndOrgTreePath(String orgAdminCode, SelectMenuTreeByOrgReqBO reqBO) {
        UserInfo currentUser = SecurityHelper.getCurrentUser();
        Long userId = currentUser.getUserId();
        reqBO.setRoleIdentity(orgAdminCode);
        reqBO.setMgrUserId(userId);
        return this.selectMenuTreeByOrgBusiService.select(reqBO);
    }
}

