/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.authority.controller.role;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.authority.log.BussinessLog;
import com.ohaotian.authority.role.bo.CreateRoleTagReqBO;
import com.ohaotian.authority.role.bo.SaveRoleTagSignReqBO;
import com.ohaotian.authority.role.bo.SelectRoleTagDistributionReqBO;
import com.ohaotian.authority.role.bo.SelectRoleTagDistributionRspBO;
import com.ohaotian.authority.role.bo.SelectRoleTagPageReqBO;
import com.ohaotian.authority.role.bo.SelectRoleTagPageRspBO;
import com.ohaotian.authority.role.bo.UpdateRoleTagReqBO;
import com.ohaotian.authority.role.service.CreateRoleTagBusiService;
import com.ohaotian.authority.role.service.DeleteRoleTagBusiService;
import com.ohaotian.authority.role.service.SaveRoleTagSignBusiService;
import com.ohaotian.authority.role.service.SelectRoleTagBusiService;
import com.ohaotian.authority.role.service.SelectRoleTagDistributionBusiService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.security.utils.SecurityHelper;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roleTag"}, method={RequestMethod.GET, RequestMethod.POST})
public class RoleTagController {
    private static final Logger logger = LoggerFactory.getLogger(RoleTagController.class);
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private CreateRoleTagBusiService createRoleTagBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private DeleteRoleTagBusiService deleteRoleTagBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SaveRoleTagSignBusiService saveRoleTagSignBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectRoleTagDistributionBusiService selectRoleTagDistributionBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private SelectRoleTagBusiService selectRoleTagBusiService;

    @PostMapping(value={"/create"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u6807\u7b7e\u7ba1\u7406", operat="\u65b0\u589e")
    public Object create(CreateRoleTagReqBO reqBO) throws Exception {
        if (StringUtils.isEmpty((Object)reqBO.getTagName())) {
            throw new ZTBusinessException("\u89d2\u8272\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTagCode())) {
            throw new ZTBusinessException("\u89d2\u8272\u6807\u7b7e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (SecurityHelper.hasAuthority((String)"auth:system:manage")) {
            reqBO.setTagType("1");
        } else if (SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            reqBO.setTagType("2");
        } else {
            throw new ZTBusinessException("\u8be5\u7528\u6237\u4e0d\u80fd\u521b\u5efa\u89d2\u8272\u6807\u7b7e");
        }
        this.createRoleTagBusiService.create(reqBO);
        return null;
    }

    @PostMapping(value={"/delete"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u6807\u7b7e\u7ba1\u7406", operat="\u5220\u9664")
    public Object delete(UpdateRoleTagReqBO reqBO) throws Exception {
        if (StringUtils.isEmpty((Object)reqBO.getTagId())) {
            throw new ZTBusinessException("\u89d2\u8272\u6807\u7b7eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!SecurityHelper.hasAuthority((String)"auth:system:manage") && !SecurityHelper.hasAuthority((String)"auth:tenant:manage")) {
            throw new ZTBusinessException("\u8be5\u7528\u6237\u4e0d\u80fd\u5220\u9664\u89d2\u8272\u6807\u7b7e");
        }
        this.deleteRoleTagBusiService.delete(reqBO);
        return null;
    }

    @PostMapping(value={"/sign"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u6807\u7b7e\u6253\u6807\u7ba1\u7406", operat="\u6253\u6807")
    public Object sign(SaveRoleTagSignReqBO reqBO) throws Exception {
        if (StringUtils.isEmpty((Object)reqBO.getRoleId())) {
            throw new ZTBusinessException("\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTagIds())) {
            throw new ZTBusinessException("\u89d2\u8272\u6807\u7b7eid\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(SecurityHelper.hasAuthority((String)"auth:system:manage") || SecurityHelper.hasAuthority((String)"auth:tenant:manage") || SecurityHelper.hasAuthority((String)"auth:org:manage") || SecurityHelper.hasAuthority((String)"auth:innerorg:manage") || SecurityHelper.hasAuthority((String)"auth:extorg:manage"))) {
            throw new ZTBusinessException("\u8be5\u7528\u6237\u4e0d\u80fd\u89d2\u8272\u6807\u7b7e\u6253\u6807");
        }
        this.saveRoleTagSignBusiService.sign(reqBO);
        return null;
    }

    @PostMapping(value={"/selectRoleTagDistribution"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u6807\u7b7e\u6253\u6807\u7ba1\u7406", operat="\u6807\u7b7e\u5206\u914d\u60c5\u51b5")
    public SelectRoleTagDistributionRspBO selectRoleTagDistribution(@Valid SelectRoleTagDistributionReqBO reqBO) throws Exception {
        if (StringUtils.isEmpty((Object)reqBO.getDistributionType())) {
            reqBO.setDistributionType("3");
        }
        SelectRoleTagDistributionRspBO rspBO = this.selectRoleTagDistributionBusiService.distribution(reqBO);
        return rspBO;
    }

    @PostMapping(value={"/selectRoleTagPage"})
    @BusiResponseBody
    @BussinessLog(module="\u89d2\u8272\u6807\u7b7e\u6253\u6807\u7ba1\u7406", operat="\u5217\u8868\u5206\u9875")
    public SelectRoleTagPageRspBO selectRoleTagPage(SelectRoleTagPageReqBO reqBO) throws Exception {
        if (StringUtils.isEmpty((Object)reqBO.getOrgWebId())) {
            reqBO.setOrgId(null);
        } else {
            reqBO.setOrgId(Long.valueOf(Long.parseLong(reqBO.getOrgWebId())));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTenantWebId())) {
            reqBO.setTenantId(Long.valueOf(Long.parseLong(reqBO.getTenantWebId())));
            reqBO.setTagType("2");
        }
        SelectRoleTagPageRspBO rspBO = this.selectRoleTagBusiService.page(reqBO);
        return rspBO;
    }
}

