/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.cfc.busi.api.ExtFieldCacheService;
import com.tydic.cfc.busi.bo.CfcExtFieldCacheDataBO;
import com.tydic.cfc.busi.bo.SubFieldConfigDataBO;
import com.tydic.cfc.dao.CfcExtFieldConfigMapper;
import com.tydic.cfc.dao.CfcSubFieldConfigMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcExtFieldConfigPO;
import com.tydic.cfc.po.CfcSubFieldConfigPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="extFieldCacheService")
public class ExtFieldCacheServiceImpl
implements ExtFieldCacheService {
    private static final Logger log = LoggerFactory.getLogger(ExtFieldCacheServiceImpl.class);
    @Autowired
    private CfcExtFieldConfigMapper cfcExtFieldConfigMapper;
    @Autowired
    private CfcSubFieldConfigMapper cfcSubFieldConfigMapper;
    @Autowired
    private CacheClient cacheClient;
    private static final String SUFFIX = "EXT_FIELD";
    private static final String POINT = ".";

    @Override
    public void doCache(String serviceCode, String methodCode) {
        if (StringUtils.isEmpty((Object)serviceCode) || StringUtils.isEmpty((Object)methodCode)) {
            throw new CfcBusinessException("8888", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CfcExtFieldConfigPO extFieldConfigPO = new CfcExtFieldConfigPO();
        extFieldConfigPO.setServiceCode(serviceCode);
        extFieldConfigPO.setMethodCode(methodCode);
        List<CfcExtFieldConfigPO> extFieldConfigMapperList = this.cfcExtFieldConfigMapper.getList(extFieldConfigPO);
        CfcExtFieldConfigPO cfcExtFieldConfigPO = extFieldConfigMapperList.get(0);
        CfcExtFieldCacheDataBO cfcExtFieldCacheDataBO = new CfcExtFieldCacheDataBO();
        cfcExtFieldCacheDataBO.setPrimaryKey(cfcExtFieldConfigPO.getPrivateKey());
        cfcExtFieldCacheDataBO.setDynamicSql(cfcExtFieldConfigPO.getDynamicSql());
        cfcExtFieldCacheDataBO.setOperateType(cfcExtFieldConfigPO.getOperateType().toString());
        CfcSubFieldConfigPO subFieldConfigPO = new CfcSubFieldConfigPO();
        subFieldConfigPO.setExtFieldId(cfcExtFieldConfigPO.getId());
        subFieldConfigPO.setParentId(0);
        List<CfcSubFieldConfigPO> subFieldPOList = this.cfcSubFieldConfigMapper.getList(subFieldConfigPO);
        ArrayList<SubFieldConfigDataBO> subFieldConfigDataBOS = new ArrayList<SubFieldConfigDataBO>();
        cfcExtFieldCacheDataBO.setSubFieldConfig(subFieldConfigDataBOS);
        for (CfcSubFieldConfigPO po : subFieldPOList) {
            SubFieldConfigDataBO subFieldConfigDataBO = new SubFieldConfigDataBO();
            subFieldConfigDataBOS.add(subFieldConfigDataBO);
            subFieldConfigDataBO.setFieldCode(po.getFieldCode());
            subFieldConfigDataBO.setDynamicSql(po.getDynamicSql());
            subFieldConfigDataBO.setPrivateKey(po.getPrivateKey());
            CfcSubFieldConfigPO cfcSubFieldConfigPO = new CfcSubFieldConfigPO();
            cfcSubFieldConfigPO.setExtFieldId(cfcExtFieldConfigPO.getId());
            cfcSubFieldConfigPO.setParentId(po.getId());
            List<CfcSubFieldConfigPO> sub2List = this.cfcSubFieldConfigMapper.getList(cfcSubFieldConfigPO);
            ArrayList<SubFieldConfigDataBO> subFieldConfigDataBOS2 = new ArrayList<SubFieldConfigDataBO>();
            if (CollectionUtils.isEmpty(sub2List)) continue;
            for (CfcSubFieldConfigPO po2 : sub2List) {
                SubFieldConfigDataBO subFieldConfigDataBO2 = new SubFieldConfigDataBO();
                subFieldConfigDataBOS2.add(subFieldConfigDataBO2);
                subFieldConfigDataBO2.setFieldCode(po2.getFieldCode());
                subFieldConfigDataBO2.setDynamicSql(po2.getDynamicSql());
                subFieldConfigDataBO2.setPrivateKey(po2.getPrivateKey());
                CfcSubFieldConfigPO cfcSubFieldConfigPO3 = new CfcSubFieldConfigPO();
                cfcSubFieldConfigPO3.setExtFieldId(cfcExtFieldConfigPO.getId());
                cfcSubFieldConfigPO3.setParentId(po2.getId());
                List<CfcSubFieldConfigPO> sub3List = this.cfcSubFieldConfigMapper.getList(cfcSubFieldConfigPO3);
                ArrayList<SubFieldConfigDataBO> subFieldConfigDataBOS3 = new ArrayList<SubFieldConfigDataBO>();
                if (CollectionUtils.isEmpty(sub3List)) continue;
                for (CfcSubFieldConfigPO po3 : sub3List) {
                    SubFieldConfigDataBO subFieldConfigDataBO3 = new SubFieldConfigDataBO();
                    subFieldConfigDataBOS3.add(subFieldConfigDataBO3);
                    subFieldConfigDataBO3.setFieldCode(po3.getFieldCode());
                    subFieldConfigDataBO3.setDynamicSql(po3.getDynamicSql());
                    subFieldConfigDataBO3.setPrivateKey(po3.getPrivateKey());
                }
            }
        }
        String key = serviceCode + POINT + methodCode + SUFFIX;
        String value = JSON.toJSONString((Object)cfcExtFieldCacheDataBO);
        log.info("\u5f00\u59cb\u7f13\u5b58\u62d3\u5c55\u5b57\u6bb5\u4fe1\u606f\uff1akey:{}------- value:{}", (Object)key, (Object)value);
        this.cacheClient.set(key, (Object)value);
    }
}

