/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.ability.impl;

import com.tydic.cfc.ability.api.CfcUniteParamAccessUploadAddAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamAccessUploadAddAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamAccessUploadAddAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcUniteParamBO;
import com.tydic.cfc.ability.bo.CfcUniteParamVerticalBO;
import com.tydic.cfc.busi.api.CfcUniteParamAddBusiService;
import com.tydic.cfc.busi.bo.CfcUniteParamAddBusiReqBO;
import com.tydic.cfc.busi.bo.CfcUniteParamAddBusiRspBO;
import com.tydic.cfc.exceptions.CfcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"CFC_GROUP_DEV/2.1.0/com.tydic.cfc.ability.api.CfcUniteParamAccessUploadAddAbilityService"})
public class CfcUniteParamAccessUploadAddAbilityServiceImpl
implements CfcUniteParamAccessUploadAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CfcUniteParamAccessUploadAddAbilityServiceImpl.class);
    @Autowired
    private CfcUniteParamAddBusiService cfcUniteParamAddBusiService;

    @PostMapping(value={"addUniteParamAccessUpload"})
    public CfcUniteParamAccessUploadAddAbilityRspBO addUniteParamAccessUpload(@RequestBody CfcUniteParamAccessUploadAddAbilityReqBO reqBO) {
        this.validParam(reqBO);
        CfcUniteParamAddBusiReqBO busiReqBO = new CfcUniteParamAddBusiReqBO();
        CfcUniteParamBO cfcUniteParamBO = new CfcUniteParamBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)cfcUniteParamBO);
        busiReqBO.setCfcUniteParamBO(cfcUniteParamBO);
        busiReqBO.setCfcUniteParamVerticalList(this.composeCfcUniteParamVerticalList(reqBO));
        CfcUniteParamAddBusiRspBO busiRspBO = this.cfcUniteParamAddBusiService.addUniteParam(busiReqBO);
        CfcUniteParamAccessUploadAddAbilityRspBO rspBO = new CfcUniteParamAccessUploadAddAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private List<CfcUniteParamVerticalBO> composeCfcUniteParamVerticalList(CfcUniteParamAccessUploadAddAbilityReqBO reqBO) {
        ArrayList<CfcUniteParamVerticalBO> cfcUniteParamVerticalBOS = new ArrayList<CfcUniteParamVerticalBO>();
        cfcUniteParamVerticalBOS.add(this.composeCfcUniteParamVertical("accessUploadNum", "\u9644\u4ef6\u4e0a\u4f20\u4e2a\u6570", "text", reqBO.getAccessUploadNum()));
        cfcUniteParamVerticalBOS.add(this.composeCfcUniteParamVertical("accessUploadSize", "\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f", "text", reqBO.getAccessUploadSize()));
        String accessUploadType = StringUtils.join((Iterable)reqBO.getAccessUploadType(), (String)",");
        cfcUniteParamVerticalBOS.add(this.composeCfcUniteParamVertical("accessUploadType", "\u9644\u4ef6\u4e0a\u4f20\u7c7b\u578b", "list", accessUploadType));
        return cfcUniteParamVerticalBOS;
    }

    private CfcUniteParamVerticalBO composeCfcUniteParamVertical(String verticalCode, String verticalName, String verticalType, String verticalValue) {
        CfcUniteParamVerticalBO cfcUniteParamVerticalBO = new CfcUniteParamVerticalBO();
        cfcUniteParamVerticalBO.setVerticalCode(verticalCode);
        cfcUniteParamVerticalBO.setVerticalName(verticalName);
        cfcUniteParamVerticalBO.setVerticalType(verticalType);
        cfcUniteParamVerticalBO.setVerticalValue(verticalValue);
        return cfcUniteParamVerticalBO;
    }

    private void validParam(CfcUniteParamAccessUploadAddAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u89c4\u5219\u65b0\u589e\u8bf7\u6c42\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCenter())) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u89c4\u5219\u65b0\u589e\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getParamCode())) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u89c4\u5219\u65b0\u589e\u7f16\u7801\u4e3a\u7a7a");
        }
        if (reqBO.getExceptionMainId() == null) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u89c4\u5219\u65b0\u589e\u4e3b\u4f53\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccessUploadNum())) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u4e2a\u6570\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccessUploadSize())) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u5927\u5c0f\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getAccessUploadType())) {
            throw new CfcBusinessException("221037", "\u9644\u4ef6\u4e0a\u4f20\u7c7b\u578b\u4e3a\u7a7a");
        }
    }
}

