/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.cfc.ability.bo.CFcUmcInfoRspDescConvertBO;
import com.tydic.cfc.busi.api.CfcQryRspInfoListByRedisBusiService;
import com.tydic.cfc.busi.bo.CfcQryRspInfoListByRedisBusiReqBO;
import com.tydic.cfc.busi.bo.CfcQryRspInfoListByRedisBusiRspBO;
import com.tydic.cfc.dao.CFcUmcInfoRspDescConvertMapper;
import com.tydic.cfc.po.CFcUmcInfoRspDescConvertPO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CfcQryRspInfoListByRedisBusiServiceImpl
implements CfcQryRspInfoListByRedisBusiService {
    private static final Logger log = LoggerFactory.getLogger(CfcQryRspInfoListByRedisBusiServiceImpl.class);
    @Autowired
    private CFcUmcInfoRspDescConvertMapper cFcUmcInfoRspDescConvertMapper;
    @Autowired
    private CacheClient cacheService;

    @Override
    public CfcQryRspInfoListByRedisBusiRspBO qryRspInfoListByRedis(CfcQryRspInfoListByRedisBusiReqBO reqBO) {
        String centerRespCode = reqBO.getCenterRespCode();
        if (centerRespCode != null && !"".equals(centerRespCode)) {
            Object dataFromCache = this.getDataFromCache(centerRespCode);
            if (dataFromCache != null) {
                List listBOs = (List)dataFromCache;
                return this.getRspResult(listBOs);
            }
            CFcUmcInfoRspDescConvertPO record = new CFcUmcInfoRspDescConvertPO();
            record.setCenterRespCode(centerRespCode);
            List<CFcUmcInfoRspDescConvertPO> listPOs = this.cFcUmcInfoRspDescConvertMapper.selectByCondition(record);
            List<CFcUmcInfoRspDescConvertBO> listBOs = listPOs.stream().map(po -> (CFcUmcInfoRspDescConvertBO)JSON.parseObject((String)JSON.toJSONString((Object)po), CFcUmcInfoRspDescConvertBO.class)).collect(Collectors.toList());
            this.cacheService.set(centerRespCode, listBOs);
            return this.getRspResult(listBOs);
        }
        List<CFcUmcInfoRspDescConvertPO> cFcUmcInfoRspDescConvertPOS = this.cFcUmcInfoRspDescConvertMapper.selectAll();
        List<CFcUmcInfoRspDescConvertBO> list = cFcUmcInfoRspDescConvertPOS.stream().map(po -> (CFcUmcInfoRspDescConvertBO)JSON.parseObject((String)JSON.toJSONString((Object)po), CFcUmcInfoRspDescConvertBO.class)).collect(Collectors.toList());
        return this.getRspResult(list);
    }

    public Object getDataFromCache(String redisKey) {
        log.info("\u8fd4\u56de\u4fe1\u606f\u5217\u8868\u67e5\u8be2API-redisKey:" + redisKey);
        return this.cacheService.get(redisKey);
    }

    public CfcQryRspInfoListByRedisBusiRspBO getRspResult(List<CFcUmcInfoRspDescConvertBO> listBOs) {
        HashMap<String, String> rspInfoMap = new HashMap<String, String>();
        for (CFcUmcInfoRspDescConvertBO listBO : listBOs) {
            rspInfoMap.put(listBO.getCenterRespCode(), listBO.getAppMsg());
        }
        CfcQryRspInfoListByRedisBusiRspBO rsp = new CfcQryRspInfoListByRedisBusiRspBO();
        rsp.setRows(listBOs);
        rsp.setRspInfoMap(rspInfoMap);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u8fd4\u56de\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u6210\u529f");
        return rsp;
    }
}

