/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.init;

import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.cfc.dao.CfcServiceParamCheckConfigMapper;
import com.tydic.cfc.po.CfcServiceParamCheckConfigPO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class ServiceParamCheckAspect
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ServiceParamCheckAspect.class);
    private static final Map<String, JSONObject> configMap = new HashMap<String, JSONObject>();
    private static final String CENTER = "CFC";
    private static final String redis_prefix = "CFC_PARAM_CHECK_";
    @Autowired
    private CfcServiceParamCheckConfigMapper cfcServiceParamCheckConfigMapper;

    @Pointcut(value="execution(* com.tydic.cfc.ability.impl..*(..))")
    public void intercept() {
    }

    @Around(value="intercept()")
    public Object aroundMethod(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String className = joinPoint.getTarget().getClass().getName();
        String methodName = methodSignature.getMethod().getName();
        String redisKey = redis_prefix + className + "." + methodName;
        if (configMap.get(redisKey) != null) {
            String message;
            JSONObject configJSONObject = JSON.parseObject((String)configMap.get(redisKey).toString());
            if (joinPoint.getArgs() == null || joinPoint.getArgs().length == 0) {
                message = "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a";
            } else {
                JSONObject param = JSON.parseObject((String)JSON.toJSONString((Object)joinPoint.getArgs()[0], (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                message = this.validParam(configJSONObject, null, param);
            }
            if (!StringUtils.isEmpty((Object)message)) {
                Class<?> rspClass = methodSignature.getMethod().getReturnType();
                Object rspObj = rspClass.newInstance();
                this.putCodeMessage(rspObj, message);
                return rspObj;
            }
        }
        return joinPoint.proceed();
    }

    private void putCodeMessage(Object object, String message) throws SecurityException, IllegalArgumentException {
        try {
            ReflectUtil.setFieldValue((Object)object, (String)"respCode", (Object)"8888");
            ReflectUtil.setFieldValue((Object)object, (String)"respDesc", (Object)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ReflectUtil.setFieldValue((Object)object, (String)"code", (Object)"1");
            ReflectUtil.setFieldValue((Object)object, (String)"message", (Object)message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String validParam(JSONObject configJSONObject, String parentKey, JSONObject jsonObject) {
        String message = "";
        for (String key : jsonObject.keySet()) {
            Object value = jsonObject.get((Object)key);
            if (parentKey != null) {
                key = parentKey + "." + key;
            }
            if (value instanceof JSONObject) {
                this.validParam(configJSONObject, key, (JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                for (int i = 0; i < jsonArray.size(); ++i) {
                    Object o = jsonArray.get(i);
                    if (!(o instanceof JSONObject)) continue;
                    this.validParam(configJSONObject, key, (JSONObject)o);
                }
                continue;
            }
            if (configJSONObject.get((Object)key) == null) continue;
            JSONObject config = (JSONObject)configJSONObject.get((Object)key);
            if (config.getBoolean("isNotNull").booleanValue() && (value == null || StringUtils.isEmpty((Object)value.toString()))) {
                message = config.getString("fieldName") + "\u4e0d\u80fd\u4e3a\u7a7a";
                return message;
            }
            if (config.getString("checkReg") != null && value != null && !value.toString().matches(config.getString("checkReg"))) {
                message = config.getString("fieldName") + "\u683c\u5f0f\u4e0d\u6b63\u786e";
                return message;
            }
            if (config.getInteger("dataLength") == null || value == null || value.toString().length() <= config.getInteger("dataLength")) continue;
            message = config.getString("fieldName") + "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7" + config.getInteger("dataLength");
            return message;
        }
        return message;
    }

    public void run(String ... args) throws Exception {
        log.info("\u670d\u52a1\u6821\u9a8c\u914d\u7f6eaop\u521d\u59cb\u5316\u5f00\u59cb==========");
        CfcServiceParamCheckConfigPO cfcServiceParamCheckConfigPO = new CfcServiceParamCheckConfigPO();
        cfcServiceParamCheckConfigPO.setGroupBy(" method_url ");
        cfcServiceParamCheckConfigPO.setCenter(CENTER);
        List<CfcServiceParamCheckConfigPO> pos = this.cfcServiceParamCheckConfigMapper.getList(cfcServiceParamCheckConfigPO);
        if (!StringUtils.isEmpty(pos)) {
            for (CfcServiceParamCheckConfigPO po : pos) {
                CfcServiceParamCheckConfigPO cfcServiceParamCheckConfigPO1 = new CfcServiceParamCheckConfigPO();
                cfcServiceParamCheckConfigPO1.setMethodUrl(po.getMethodUrl());
                List<CfcServiceParamCheckConfigPO> pos1 = this.cfcServiceParamCheckConfigMapper.getList(cfcServiceParamCheckConfigPO1);
                if (CollectionUtils.isEmpty(pos1)) continue;
                Map<String, CfcServiceParamCheckConfigPO> map = pos1.stream().collect(Collectors.toMap(CfcServiceParamCheckConfigPO::getFieldUrl, a -> a, (k1, k2) -> k1));
                String redisKey = redis_prefix + po.getMethodUrl();
                configMap.put(redisKey, JSON.parseObject((String)JSON.toJSONString(map)));
            }
        }
        log.info("\u670d\u52a1\u6821\u9a8c\u914d\u7f6eaop\u521d\u59cb\u5316\u5f00\u59cb\u7ed3\u675f==========" + configMap);
    }
}

