/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.tydic.cfc.busi.api.CfcEncodedRuleDealBusiService;
import com.tydic.cfc.busi.bo.CfcEncodedRuleDealBusiReqBO;
import com.tydic.cfc.busi.bo.CfcEncodedRuleDealBusiRspBO;
import com.tydic.cfc.dao.CfcEncodedRuleDetailedMapper;
import com.tydic.cfc.dao.CfcEncodedRuleMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcEncodedRulePO;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="cfcEncodedRuleDealBusiService")
public class CfcEncodedRuleDealBusiServiceImpl
implements CfcEncodedRuleDealBusiService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedRuleDealBusiServiceImpl.class);
    @Value(value="${encode.rule.allowed.deleted.class.ids:21}")
    private String allowDeletedClassIds;
    @Autowired
    private CfcEncodedRuleMapper cfcEncodedRuleMapper;
    @Autowired
    private CfcEncodedRuleDetailedMapper cfcEncodedRuleDetailedMapper;
    private Set<String> allowDeletedClassIdSet = new HashSet<String>(1);

    @PostConstruct
    public void init() {
        if (!StringUtils.isEmpty((Object)this.allowDeletedClassIds)) {
            Collections.addAll(this.allowDeletedClassIdSet, this.allowDeletedClassIds.split(","));
        }
    }

    @Override
    public CfcEncodedRuleDealBusiRspBO dealEncodedRule(CfcEncodedRuleDealBusiReqBO reqBO) {
        CfcEncodedRuleDealBusiRspBO rspBO = new CfcEncodedRuleDealBusiRspBO();
        CfcEncodedRulePO cfcEncodedRulePO = new CfcEncodedRulePO();
        cfcEncodedRulePO.setId(reqBO.getId());
        if ("3".equals(reqBO.getOperType())) {
            CfcEncodedRulePO po = this.cfcEncodedRuleMapper.selectByPrimaryKey(reqBO.getId());
            BeanUtils.copyProperties((Object)po, (Object)((Object)rspBO));
            if (po == null) {
                throw new CfcBusinessException("223010", "\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u6570\u914d\u7f6e\u4fe1\u606f");
            }
            if ("1".equals(po.getEncodedRuleType()) && !CollectionUtils.isEmpty(this.allowDeletedClassIdSet) && !this.allowDeletedClassIdSet.contains(po.getClassId().toString())) {
                throw new CfcBusinessException("223010", "\u7cfb\u7edf\u53c2\u6570\u914d\u7f6e\u4fe1\u606f\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            this.cfcEncodedRuleMapper.deleteByPrimaryKey(reqBO.getId());
            this.cfcEncodedRuleDetailedMapper.deleteByEncodedRuleId(reqBO.getId());
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

