/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.cfc.busi.api.CfcHsfProxyService;
import com.tydic.cfc.busi.bo.CfcHsfProxyServiceReqBO;
import com.tydic.cfc.busi.bo.CfcHsfProxyServiceRspBO;
import com.tydic.cfc.busi.bo.CfcTransServiceDataBO;
import com.tydic.cfc.dao.CfcRelServiceBackMapper;
import com.tydic.cfc.dao.CfcTransRollbackRecordMapper;
import com.tydic.cfc.po.CfcRelServiceBackPO;
import com.tydic.cfc.po.CfcTransRollbackRecordPO;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="cfcHsfProxyService")
public class CfcHsfProxyServiceImpl
implements CfcHsfProxyService {
    private static final Logger log = LoggerFactory.getLogger(CfcHsfProxyServiceImpl.class);
    private static final String RSP_CODE = "respCode";
    private static final String SUCCESS_CODE = "0000";
    private static final int BACK_STATUS_SUCCESS = 1;
    private static final int BACK_STATUS_FAIL = 0;
    @Autowired
    private CfcRelServiceBackMapper cfcRelServiceBackMapper;
    @Autowired
    private CfcTransRollbackRecordMapper cfcTransRollbackRecordMapper;

    @Override
    public CfcHsfProxyServiceRspBO executeCallChain(CfcHsfProxyServiceReqBO reqBO) {
        CfcHsfProxyServiceRspBO rspBO = new CfcHsfProxyServiceRspBO();
        List<CfcTransServiceDataBO> list = reqBO.getList();
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u56de\u6eda\u4e8b\u52a1\u8c03\u7528\u94fe\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        for (CfcTransServiceDataBO bo : list) {
            CfcRelServiceBackPO relServiceBackPo = new CfcRelServiceBackPO();
            relServiceBackPo.setServiceCode(bo.getServiceCode());
            relServiceBackPo.setMethodCode(bo.getMethodCode());
            CfcRelServiceBackPO resultPo = this.cfcRelServiceBackMapper.getModelBy(relServiceBackPo);
            CfcTransRollbackRecordPO recordPo = new CfcTransRollbackRecordPO();
            BeanUtils.copyProperties((Object)bo, (Object)recordPo);
            recordPo.setBackServiceCode(recordPo.getBackServiceCode());
            recordPo.setBackMethodCode(recordPo.getBackMethodCode());
            recordPo.setCreateTime(new Date());
            this.cfcTransRollbackRecordMapper.insert(recordPo);
            String reqJson = bo.getReqInfo();
            JSONObject reqJsonObj = JSON.parseObject((String)reqJson);
            Map rspInfo = (Map)JSON.parseObject((String)bo.getRspInfo(), Map.class);
            reqJsonObj.putAll(rspInfo);
            reqJson = reqJsonObj.toJSONString();
            Object[] values = new Object[]{reqJson};
            String[] argsTypeArray = new String[]{"java.lang.String"};
            Map rspMap = this.execute(resultPo.getServiceCode(), resultPo.getBackVersion(), resultPo.getBackGroup(), resultPo.getBackMethodCode(), argsTypeArray, values);
            String rspBody = rspMap.toString();
            CfcTransRollbackRecordPO afterCall = new CfcTransRollbackRecordPO();
            afterCall.setTransId(bo.getTransId());
            JSONObject rspJson = JSON.parseObject((String)rspBody);
            if (rspJson.getString(RSP_CODE).equals(SUCCESS_CODE)) {
                afterCall.setBackStatus(1);
            }
            afterCall.setBackStatus(0);
            afterCall.setUpdateTime(new Date());
            this.cfcTransRollbackRecordMapper.updateBy(recordPo, afterCall);
        }
        rspBO.setRespCode(SUCCESS_CODE);
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public Map execute(String interfaceName, String version, String group, String method, String[] argsType, Object[] values) {
        return new HashMap();
    }
}

