/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.ability.impl;

import com.tydic.cfc.ability.api.CfcEncodedRuleAddAbilityService;
import com.tydic.cfc.ability.bo.CfcEncodedRuleAddAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleAddAbilityRspBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleDetailedBO;
import com.tydic.cfc.ability.bo.CfcEncodedRuleSyncBO;
import com.tydic.cfc.busi.api.CfcEncodedRuleAddBusiService;
import com.tydic.cfc.busi.api.CfcEncodedSerialSyncMqSendBusiService;
import com.tydic.cfc.busi.bo.CfcEncodedRuleAddBusiReqBO;
import com.tydic.cfc.busi.bo.CfcEncodedRuleAddBusiRspBO;
import com.tydic.cfc.busi.bo.CfcEncodedSerialSyncMqBusiReqBO;
import com.tydic.cfc.exceptions.CfcBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UMC_GROUP_DEV/2.1.0/com.tydic.cfc.ability.api.CfcEncodedRuleAddAbilityService"})
public class CfcEncodedRuleAddAbilityServiceImpl
implements CfcEncodedRuleAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(CfcEncodedRuleAddAbilityServiceImpl.class);
    @Autowired
    private CfcEncodedRuleAddBusiService cfcEncodedRuleAddBusiService;
    @Autowired
    private CfcEncodedSerialSyncMqSendBusiService cfcEncodedSerialSyncMqSendBusiService;

    @PostMapping(value={"addEncodedRule"})
    public CfcEncodedRuleAddAbilityRspBO addEncodedRule(@RequestBody CfcEncodedRuleAddAbilityReqBO reqBO) {
        this.validParam(reqBO);
        CfcEncodedRuleAddBusiReqBO busiReqBO = new CfcEncodedRuleAddBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        CfcEncodedRuleAddBusiRspBO busiRspBO = this.cfcEncodedRuleAddBusiService.addEncodedRule(busiReqBO);
        CfcEncodedRuleAddAbilityRspBO rspBO = new CfcEncodedRuleAddAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        this.syncMethod(busiReqBO, busiRspBO);
        return rspBO;
    }

    private void syncMethod(CfcEncodedRuleAddBusiReqBO busiReqBO, CfcEncodedRuleAddBusiRspBO busiRspBO) {
        if (!CollectionUtils.isEmpty(busiRspBO.getSyncBOLIst())) {
            for (CfcEncodedRuleSyncBO itemBO : busiRspBO.getSyncBOLIst()) {
                CfcEncodedSerialSyncMqBusiReqBO syncBO = new CfcEncodedSerialSyncMqBusiReqBO();
                BeanUtils.copyProperties((Object)itemBO, (Object)syncBO);
                syncBO.setCenter(busiReqBO.getCenter());
                this.cfcEncodedSerialSyncMqSendBusiService.sendEncodedSerialSyncMsg(syncBO);
            }
        }
    }

    private void validParam(CfcEncodedRuleAddAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new CfcBusinessException("221009", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (reqBO.getGroupId() == null) {
            throw new CfcBusinessException("221009", "\u7f16\u7801\u89c4\u5219\u5206\u7ec4ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleName())) {
            throw new CfcBusinessException("221009", "\u7f16\u7801\u89c4\u5219\u540d\u79f0\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new CfcBusinessException("221009", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
        if (reqBO.getDetaileds() == null || reqBO.getDetaileds().size() < 1) {
            throw new CfcBusinessException("221009", "\u7f16\u7801\u89c4\u5219\u660e\u7ec6\u4e3a\u7a7a");
        }
        if (!"serial".equals(((CfcEncodedRuleDetailedBO)reqBO.getDetaileds().get(reqBO.getDetaileds().size() - 1)).getDetailedType())) {
            throw new CfcBusinessException("221009", "\u7f16\u7801\u660e\u7ec6\u6700\u540e\u4e00\u4f4d\u5fc5\u987b\u662f\u6d41\u6c34\u53f7");
        }
    }
}

