/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.cfc.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.busi.api.CfcPresentAddBusiService;
import com.tydic.cfc.busi.bo.CfcPresentAddBusiReqBO;
import com.tydic.cfc.busi.bo.CfcPresentAddBusiRspBO;
import com.tydic.cfc.dao.CfcPresentMapper;
import com.tydic.cfc.exceptions.CfcBusinessException;
import com.tydic.cfc.po.CfcPresentPO;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="cfcPresentAddBusiService")
public class CfcPresentAddBusiServiceImpl
implements CfcPresentAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(CfcPresentAddBusiServiceImpl.class);
    @Autowired
    private CfcPresentMapper cfcPresentMapper;

    @Override
    public CfcPresentAddBusiRspBO addPresent(CfcPresentAddBusiReqBO reqBO) {
        CfcPresentPO cfcPresentPO = new CfcPresentPO();
        cfcPresentPO.setPresentCode(reqBO.getPresentCode());
        cfcPresentPO.setPresentRangeId(reqBO.getPresentRangeId());
        List<CfcPresentPO> list = this.cfcPresentMapper.getList(cfcPresentPO);
        if (list != null && list.size() > 0) {
            throw new CfcBusinessException("223029", "\u5e94\u7528\u8303\u56f4\u5df2\u5b58\u5728\u8be5\u8ba1\u5212\u63d0\u62a5");
        }
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)cfcPresentPO);
        cfcPresentPO.setId(Sequence.getInstance().nextId());
        cfcPresentPO.setStatus("01");
        cfcPresentPO.setOperateNo(reqBO.getMemIdIn());
        cfcPresentPO.setOperateTime(new Date());
        String presentTypeStr = "";
        if ("week".equals(cfcPresentPO.getPresentType())) {
            presentTypeStr = presentTypeStr + "\u6bcf\u5468 ";
            if (cfcPresentPO.getPresentWeek().contains("1")) {
                presentTypeStr = presentTypeStr + "\u5468\u4e00 ";
            }
            if (cfcPresentPO.getPresentWeek().contains("2")) {
                presentTypeStr = presentTypeStr + "\u5468\u4e8c ";
            }
            if (cfcPresentPO.getPresentWeek().contains("3")) {
                presentTypeStr = presentTypeStr + "\u5468\u4e09 ";
            }
            if (cfcPresentPO.getPresentWeek().contains("4")) {
                presentTypeStr = presentTypeStr + "\u5468\u56db ";
            }
            if (cfcPresentPO.getPresentWeek().contains("5")) {
                presentTypeStr = presentTypeStr + "\u5468\u4e94 ";
            }
            if (cfcPresentPO.getPresentWeek().contains("6")) {
                presentTypeStr = presentTypeStr + "\u5468\u516d ";
            }
            if (cfcPresentPO.getPresentWeek().contains("7")) {
                presentTypeStr = presentTypeStr + "\u5468\u65e5 ";
            }
        }
        if ("month".equals(cfcPresentPO.getPresentType())) {
            presentTypeStr = presentTypeStr + "\u6bcf\u6708 " + cfcPresentPO.getPresentMouthStart() + "\u53f7-" + cfcPresentPO.getPresentMouthEnd() + "\u53f7";
        }
        if (!StringUtils.isEmpty((Object)cfcPresentPO.getPresentDayStart()) && !StringUtils.isEmpty((Object)cfcPresentPO.getPresentDayEnd())) {
            presentTypeStr = presentTypeStr + " " + cfcPresentPO.getPresentDayStart() + "-" + cfcPresentPO.getPresentDayEnd();
        }
        cfcPresentPO.setPresentTypeStr(presentTypeStr);
        if (!StringUtils.isEmpty((Object)presentTypeStr)) {
            cfcPresentPO.setPresentTypeStr(presentTypeStr);
        }
        cfcPresentPO.setStatus("01");
        int insert = this.cfcPresentMapper.insert(cfcPresentPO);
        if (insert < 1) {
            throw new CfcBusinessException("8888", "\u8ba1\u5212\u63d0\u62a5\u65b0\u589e\u5931\u8d25");
        }
        CfcPresentAddBusiRspBO rspBO = new CfcPresentAddBusiRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

