/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.plugin.encoded.dao.EncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.po.EncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.EncodedSerialPO;
import com.tydic.plugin.encoded.exception.EncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.EncodedSerialGetService;
import com.tydic.plugin.encoded.service.RedisSerialService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="redisSerialService")
public class RedisSerialServiceImpl
implements RedisSerialService {
    private static final Logger log = LoggerFactory.getLogger(RedisSerialServiceImpl.class);
    @Value(value="${encodedSerial.redis.enable:true}")
    private Boolean encodedSerialRedisEnable;
    @Value(value="${encodedSerial.updateNum:1000}")
    private Integer encodedSerialUpdateNum;
    public static final String PREFIX = "PKESS";
    public static final String CONNECTOR_UNDERLINE = "_";
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private EncodedSerialGetService encodedSerialGetService;
    @Autowired
    private EncodedSerialGenerateMapper encodedSerialGenerateMapper;

    @Override
    public EncodedSerialGetServiceRspBO getSerial(EncodedSerialGetServiceReqBO reqBO) {
        Object encodedSerial;
        if (reqBO == null) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenter())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrgType())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u673a\u6784\u7c7b\u578b\u4e3a\u7a7a");
        }
        EncodedSerialGetServiceRspBO rspBO = new EncodedSerialGetServiceRspBO();
        EncodedSerialPO encodedSerialPO = null;
        String encodedSerialKey = null;
        String encodedSerialGenerateKey = null;
        String encodedSerialGenerateUpdateKey = null;
        Integer generateValue = null;
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String effDate = df.format(LocalDateTime.now());
        if (this.encodedSerialRedisEnable.booleanValue() && (encodedSerial = this.cacheClient.get(encodedSerialKey = "PKESS_" + reqBO.getCenter() + CONNECTOR_UNDERLINE + reqBO.getEncodedRuleCode() + CONNECTOR_UNDERLINE + reqBO.getOrgType())) != null && (encodedSerialPO = (EncodedSerialPO)JSON.parseObject((String)((String)encodedSerial), EncodedSerialPO.class)) != null && StringUtils.isNotBlank((CharSequence)encodedSerialPO.getEncodedSerialPrefix()) && effDate.equals(encodedSerialPO.getEffDate())) {
            encodedSerialGenerateKey = encodedSerialKey + CONNECTOR_UNDERLINE + encodedSerialPO.getEncodedSerialPrefix();
            generateValue = (Integer)this.cacheClient.get(encodedSerialGenerateKey);
            encodedSerialGenerateUpdateKey = encodedSerialKey + CONNECTOR_UNDERLINE + "UPDATE" + CONNECTOR_UNDERLINE + encodedSerialPO.getEncodedSerialPrefix();
        }
        if (encodedSerialPO != null && generateValue != null) {
            EncodedSerialServiceRspBO encodedSerialServiceRspBO = this.encodedSerialGetService.getSerial(reqBO);
            encodedSerialPO = encodedSerialServiceRspBO.getEncodedSerialPO();
            generateValue = encodedSerialServiceRspBO.getEncodedSerialGeneratePO().getGenerateValue();
            if (this.encodedSerialRedisEnable.booleanValue()) {
                encodedSerialKey = "PKESS_" + encodedSerialPO.getCenter() + CONNECTOR_UNDERLINE + encodedSerialPO.getEncodedRuleCode() + CONNECTOR_UNDERLINE + encodedSerialPO.getOrgType();
                this.cacheClient.set(encodedSerialKey, (Object)JSON.toJSONString((Object)encodedSerialPO));
                encodedSerialGenerateKey = encodedSerialKey + CONNECTOR_UNDERLINE + encodedSerialPO.getEncodedSerialPrefix();
                this.cacheClient.set(encodedSerialGenerateKey, (Object)generateValue);
                encodedSerialGenerateUpdateKey = encodedSerialKey + CONNECTOR_UNDERLINE + "UPDATE" + CONNECTOR_UNDERLINE + encodedSerialPO.getEncodedSerialPrefix();
                this.cacheClient.set(encodedSerialGenerateUpdateKey, (Object)generateValue);
            }
            rspBO.setSerialNoList(encodedSerialServiceRspBO.getSerialNoList());
            return rspBO;
        }
        Integer num = 1;
        if (reqBO.getNum() != null && reqBO.getNum() > 0) {
            num = reqBO.getNum();
        }
        Long newNum = this.cacheClient.incrBy(encodedSerialGenerateKey, (long)num.intValue());
        Integer lastUpdateNum = (Integer)this.cacheClient.get(encodedSerialGenerateUpdateKey);
        if (newNum - (long)lastUpdateNum.intValue() > (long)this.encodedSerialUpdateNum.intValue()) {
            EncodedSerialGeneratePO selectEncodedSerialGeneratePO = new EncodedSerialGeneratePO();
            selectEncodedSerialGeneratePO.setSerialId(encodedSerialPO.getId());
            selectEncodedSerialGeneratePO.setGeneratePrefix(encodedSerialPO.getEncodedSerialPrefix());
            List<EncodedSerialGeneratePO> encodedSerialGenerateResult = this.encodedSerialGenerateMapper.getList(selectEncodedSerialGeneratePO);
            if (encodedSerialGenerateResult != null && encodedSerialGenerateResult.size() > 0) {
                int updateFlag = this.encodedSerialGenerateMapper.updateGenerateValue(encodedSerialGenerateResult.get(0).getId(), num);
                if (updateFlag < 1) {
                    throw new EncodedPluginBusinessException("8888", "\u5c1d\u8bd5\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
                }
                this.cacheClient.set(encodedSerialGenerateUpdateKey, (Object)generateValue);
            } else {
                throw new EncodedPluginBusinessException("8888", "\u6d41\u6c34\u53f7\u4e0d\u5b58\u5728");
            }
        }
        ArrayList<String> serialNoList = new ArrayList<String>();
        for (int i = num - 1; i >= 0; --i) {
            String generatePrefix = encodedSerialPO.getEncodedSerialPrefix();
            if (reqBO.getReplaceJson() != null) {
                for (Map.Entry itemJson : reqBO.getReplaceJson().entrySet()) {
                    String itemJsonKey = "\\$\\{" + (String)itemJson.getKey() + "\\}";
                    generatePrefix = generatePrefix.replaceAll(itemJsonKey, itemJson.getValue().toString());
                }
            }
            String serialNo = generatePrefix + String.format("%0" + encodedSerialPO.getEncodedSerialDigit() + "d", newNum - (long)i);
            serialNoList.add(serialNo);
        }
        rspBO.setSerialNoList(serialNoList);
        return rspBO;
    }
}

