/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.plugin.encoded.service.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.encoded.CfcEncodedRuleSelectCodeAbilityService;
import com.tydic.cfc.ability.encoded.bo.CfcEncodedRuleBO;
import com.tydic.cfc.ability.encoded.bo.CfcEncodedRuleSelectCodeAbilityReqBo;
import com.tydic.cfc.ability.encoded.bo.CfcEncodedRuleSelectCodeAbilityRspBo;
import com.tydic.plugin.encoded.dao.EncodedSerialGenerateMapper;
import com.tydic.plugin.encoded.dao.EncodedSerialMapper;
import com.tydic.plugin.encoded.dao.po.EncodedSerialGeneratePO;
import com.tydic.plugin.encoded.dao.po.EncodedSerialPO;
import com.tydic.plugin.encoded.exception.EncodedPluginBusinessException;
import com.tydic.plugin.encoded.service.EncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceRspBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialServiceRspBO;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="encodedSerialGetService")
public class EncodedSerialGetServiceImpl
implements EncodedSerialGetService {
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV")
    private CfcEncodedRuleSelectCodeAbilityService cfcEncodedRuleSelectCodeAbilityService;
    @Autowired
    private EncodedSerialMapper encodedSerialMapper;
    @Autowired
    private EncodedSerialGenerateMapper encodedSerialGenerateMapper;

    @Override
    @Transactional
    public EncodedSerialGetServiceRspBO getEncodedSerial(EncodedSerialGetServiceReqBO reqBO) {
        EncodedSerialGetServiceRspBO rspBO = new EncodedSerialGetServiceRspBO();
        EncodedSerialServiceRspBO encodedSerialServiceRspBO = this.getSerial(reqBO);
        rspBO.setSerialNoList(encodedSerialServiceRspBO.getSerialNoList());
        return rspBO;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional
    public EncodedSerialServiceRspBO getSerial(EncodedSerialGetServiceReqBO reqBO) {
        void var10_20;
        int i;
        EncodedSerialServiceRspBO rspBO = new EncodedSerialServiceRspBO();
        this.validParam(reqBO);
        EncodedSerialPO esParam = new EncodedSerialPO();
        esParam.setCenter(reqBO.getCenter());
        BeanUtils.copyProperties((Object)reqBO, (Object)esParam);
        esParam.setEffFlag("1");
        List<EncodedSerialPO> encodedSerialPOS = this.encodedSerialMapper.getList(esParam);
        ArrayList<EncodedSerialPO> effList = new ArrayList<EncodedSerialPO>();
        ArrayList<String> serialNoList = new ArrayList<String>();
        EncodedSerialPO encodedSerialPO = null;
        if (encodedSerialPOS != null && encodedSerialPOS.size() > 0) {
            for (EncodedSerialPO encodedSerialPO2 : encodedSerialPOS) {
                String string = this.composeEffDate(encodedSerialPO2);
                if (string == null || !"".equals(string) && !string.equals(encodedSerialPO2.getEffDate())) continue;
                effList.add(encodedSerialPO2);
            }
        }
        if (effList.size() < 1) {
            effList.addAll(this.saveEncodedSerialPO(esParam));
        }
        int extendLength = -1;
        for (EncodedSerialPO encodedSerialPO3 : effList) {
            if (StringUtils.isBlank((CharSequence)reqBO.getRelId())) {
                if (!StringUtils.isBlank((CharSequence)encodedSerialPO3.getRelId())) continue;
                encodedSerialPO = encodedSerialPO3;
                break;
            }
            if (StringUtils.isBlank((CharSequence)encodedSerialPO3.getRelId())) {
                if (encodedSerialPO != null) continue;
                encodedSerialPO = encodedSerialPO3;
                continue;
            }
            if ("1".equals(reqBO.getExtendFlag())) {
                if (!reqBO.getRelId().contains(encodedSerialPO3.getRelId()) || !reqBO.getRelType().equals(encodedSerialPO3.getRelType())) continue;
                String[] ids = reqBO.getRelId().split(",");
                for (int i2 = 0; i2 < ids.length; ++i2) {
                    if (!ids[i2].equals(encodedSerialPO3.getRelId()) || i2 <= extendLength) continue;
                    extendLength = i2;
                    encodedSerialPO = encodedSerialPO3;
                }
                continue;
            }
            if (!reqBO.getRelId().equals(encodedSerialPO3.getRelId()) || !reqBO.getRelType().equals(encodedSerialPO3.getRelType())) continue;
            encodedSerialPO = encodedSerialPO3;
            break;
        }
        EncodedSerialGeneratePO encodedSerialGeneratePO = new EncodedSerialGeneratePO();
        String string = encodedSerialPO.getEncodedSerialPrefix();
        if (reqBO.getReplaceJson() != null) {
            for (Map.Entry itemJson : reqBO.getReplaceJson().entrySet()) {
                void var10_17;
                String itemJsonKey = "\\$\\{" + (String)itemJson.getKey() + "\\}";
                String string2 = var10_17.replaceAll(itemJsonKey, itemJson.getValue().toString());
            }
        } else if (!CollectionUtils.isEmpty(reqBO.getReplaceValue())) {
            String sp = "\\$\\{\\w+\\}";
            Pattern p = Pattern.compile(sp);
            Matcher m = p.matcher(string);
            StringBuffer sb = new StringBuffer();
            i = 0;
            while (m.find()) {
                if (i >= reqBO.getReplaceValue().size()) continue;
                String key = m.group(0);
                m.appendReplacement(sb, reqBO.getReplaceValue().get(i++));
            }
            m.appendTail(sb);
            String string3 = sb.toString();
        }
        encodedSerialGeneratePO.setSerialId(encodedSerialPO.getId());
        encodedSerialGeneratePO.setGeneratePrefix((String)var10_20);
        List<EncodedSerialGeneratePO> esgList = this.encodedSerialGenerateMapper.getList(encodedSerialGeneratePO);
        Integer num = reqBO.getNum() != null ? reqBO.getNum() : 1;
        Long esgId = null;
        if (esgList != null && esgList.size() > 0) {
            esgId = esgList.get(0).getId();
            int updateFlag = this.encodedSerialGenerateMapper.updateGenerateValue(esgId, num);
            if (updateFlag < 1) {
                throw new EncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        } else {
            esgId = Sequence.getInstance().nextId();
            encodedSerialGeneratePO.setId(esgId);
            encodedSerialGeneratePO.setGenerateValue(num);
            int insertFlag = this.encodedSerialGenerateMapper.insert(encodedSerialGeneratePO);
            if (insertFlag < 1) {
                throw new EncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
            }
        }
        EncodedSerialGeneratePO esgPO = this.encodedSerialGenerateMapper.selectByPrimaryKey(esgId);
        for (i = num - 1; i >= 0; --i) {
            String serialNo = esgPO.getGeneratePrefix() + String.format("%0" + encodedSerialPO.getEncodedSerialDigit() + "d", esgPO.getGenerateValue() - i);
            serialNoList.add(serialNo);
        }
        rspBO.setSerialNoList(serialNoList);
        rspBO.setEncodedSerialPO(encodedSerialPO);
        rspBO.setEncodedSerialGeneratePO(esgPO);
        return rspBO;
    }

    private String composeEffDate(EncodedSerialPO encodedSerialPO) {
        if ("none".equals(encodedSerialPO.getEffType())) {
            return "";
        }
        if ("date".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return df.format(LocalDateTime.now());
        }
        if ("year".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy");
            return df.format(LocalDateTime.now());
        }
        if ("mouth".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("MM");
            return df.format(LocalDateTime.now());
        }
        if ("day".equals(encodedSerialPO.getEffType())) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("dd");
            return df.format(LocalDateTime.now());
        }
        return null;
    }

    private List<EncodedSerialPO> saveEncodedSerialPO(EncodedSerialPO esPO) {
        CfcEncodedRuleSelectCodeAbilityReqBo cfcEncodedRuleSelectCodeAbilityReqBo = new CfcEncodedRuleSelectCodeAbilityReqBo();
        BeanUtils.copyProperties((Object)esPO, (Object)cfcEncodedRuleSelectCodeAbilityReqBo);
        CfcEncodedRuleSelectCodeAbilityRspBo cfcEncodedRuleSelectCodeAbilityRspBo = this.cfcEncodedRuleSelectCodeAbilityService.selectEncodedRuleDetail(cfcEncodedRuleSelectCodeAbilityReqBo);
        if (!"0000".equals(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode())) {
            throw new EncodedPluginBusinessException(cfcEncodedRuleSelectCodeAbilityRspBo.getRespCode(), cfcEncodedRuleSelectCodeAbilityRspBo.getRespDesc());
        }
        List encodedRuleList = cfcEncodedRuleSelectCodeAbilityRspBo.getEncodedRuleList();
        ArrayList<EncodedSerialPO> addList = new ArrayList<EncodedSerialPO>();
        for (CfcEncodedRuleBO encodedRuleBO : encodedRuleList) {
            EncodedSerialPO insertPO = new EncodedSerialPO();
            BeanUtils.copyProperties((Object)esPO, (Object)insertPO);
            insertPO.setId(Sequence.getInstance().nextId());
            insertPO.setEncodedSerialPrefix(encodedRuleBO.getEncodedSerialPrefix());
            insertPO.setEncodedSerialDigit(encodedRuleBO.getEncodedSerialDigit());
            insertPO.setEffFlag("1");
            insertPO.setEffType(encodedRuleBO.getEffType());
            insertPO.setEffDate(this.composeEffDate(insertPO));
            insertPO.setRelType(encodedRuleBO.getRelType());
            insertPO.setRelId(encodedRuleBO.getRelId());
            addList.add(insertPO);
        }
        int insertFlag = this.encodedSerialMapper.insertBatch(addList);
        if (insertFlag < 1) {
            throw new EncodedPluginBusinessException("8888", "\u66f4\u65b0\u6d41\u6c34\u53f7\u5931\u8d25");
        }
        return addList;
    }

    private void validParam(EncodedSerialGetServiceReqBO reqBO) {
        if (reqBO == null) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getCenter())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u6240\u5c5e\u4e2d\u5fc3\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getEncodedRuleCode())) {
            throw new EncodedPluginBusinessException("8888", "\u7f16\u7801\u89c4\u5219\u7f16\u7801\u4e3a\u7a7a");
        }
    }
}

