package com.tydic.dyc.base.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 描述：翻页入参基类
 *
 * @author tgy
 * @date 2022/2/13 16:27
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BasePageReqBo extends BaseUmcReqBo{

    private static final long serialVersionUID = 7012335552401619547L;

    @DocField(value = "页码，默认1", required = true, defaultValue = "1")
    private int pageNo = 1;

    @DocField(value = "每页数量，默认10", required = true, defaultValue = "10")
    private int pageSize = 10;

    @DocField(value = "排序字段名称(需要接口支持)")
    private String sortName;

    @DocField(value = "排序顺序(需要接口支持，传值例如：asc、desc)")
    private String sortOrder;
}


