package com.tydic.dyc.base.bo;

import com.tydic.dyc.base.bo.umc.UmcAuthorityInfo;
import com.tydic.dyc.base.bo.umc.UmcStationBO;
import com.tydic.dyc.base.bo.umc.UmcUserRoleBO;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 描述：带有会员信息的基类
 *
 * @author tgy
 * @date 2022/2/13 16:19
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BaseUmcReqBo extends BaseReqBo {
    private static final long serialVersionUID = -5650790231926572234L;
    /**
     * 重构会员中心基类 开始
     * */
    /**
     * 用户ID
     * */
    private Long userIdIn;
    /**
     * 客户ID
     * */
    private Long custIdIn;
    /**
     * 客户名称
     * */
    private String custNameIn;
    /**
     * 主客户ID
     * */
    private Long mainCustIdIn;
    /**
     * 客户类型 1外部个人 2外部企业 3内部个人用户 4内部企业用户
     * */
    private String custTypeIn;
    /**
     * 注册邮箱
     * */
    private String regEmailIn;
    /**
     * 手机号
     * */
    private String regMobileIn;
    /**
     * 登陆账号
     * */
    private String regAccountIn;
    /**
     * 公司ID
     * */
    private Long companyIdIn;
    /**
     * 公司名称
     * */
    private Long companyCodeIn;
    /**
     * 公司编码
     * */
    private Long companyNameIn;
    /**
     * 当前登录身份
     * */
    private String LoginTagIn;
    /**
     * 拥有身份列表
     * */
    private List<String> tagListIn;
    /**
     * 机构树路径
     * */
    private String orgTreePathIn;
    /**
     * 机构树名称
     * */
    private String orgTreePathNameIn;
    /**
     * 机构ID
     * */
    private Long orgIdIn;
    /**
     * 机构类别 1 外部个人 2 外部企业 4 内部企业
     * */
    private String orgClassIn;
    /**
     * 机构名称
     * */
    private String orgNameIn;
    /**
     * 租户ID
     * */
    private Long tenantIdIn;
    /**
     * 租户名称
     * */
    private String tenantNameIn;
    /**
     * 权限列表
     * */
    private Set<UmcAuthorityInfo> permissionIn = new HashSet<>();
    /**
     * 角色信息
     * */
    private Set<String> authPermission = new HashSet<>();
    /**
     * 管理机构列表
     * */
    private List<Long> mgOrgIdsIn;
    /**
     * 是否需要重置密码
     * */
    private Boolean needResetPwd = false;;
    /**
     * 密码到期时间
     * */
    private Date passPwdExpDate ;
    /**
     * 模块编码列表
     * */
    private List<String> moduleCodeListIn;
    /**
     * 角色列表
     * */
    private List<String> roleNamesIn;
    /**
     * 权限菜单编码列表
     * */
    private List<String> menuCodeListIn;
    /**
     * 上次登陆时间
     * */
    private String lastLoginTimeIn;
    /**
     * 黑名单状态
     * */
    private String blackStatusIn;
    /**
     * 登录来源
     * */
    private String loginSourceIn;
    /**
     * 岗位权限
     * */
    private List<UmcStationBO> umcStationsIn;
    /**
     * 角色列表
     * */
    private List<UmcUserRoleBO> umcUserRolesIn;
    /**
     * 重构会员中心基类 结束
     * */

    /**
     * 会员类型，不需要前端传入，会员注入：1外部个人 2外部企业 3内部个人用户 4内部企业用户
     */
    private String memUserType;
    private Integer orgLevel;
    /**
     * 价格体系系数
     */
    private BigDecimal psDiscountRate;
    private String loginSource;

    /**
     * token值
     */
    private String token;
    private String reqNo;
    /**
     * 用户id，不需要前端传入，会员中心注入
     */
    private Long userId;
    /**
     * 用户名称，不需要前端传入，会员中心注入
     */
    private String name;
    /**
     * 用户登陆名称，不需要前端传入，会员中心注入
     */
    private String username;
    private String password;
    private String orgPath;
    /**
     * 会员机构id，不需要前端传入，会员中心注入
     */
    private Long orgId;
    /**
     * 员工工号，不需要前端传入，会员中心注入
     */
    private String workNo;
    private String orgName;
    private String cellphone;
    private String tenantName;
    private Long memIdExt;

    /**
     * 所属公司id,不需要前端传入
     */
    private Long companyId;

    /**
     * 所属公司名称
     */
    private String companyName;
    /**
     * 采购账套编号
     */
    private Long purchaserAccountUser;


    /**
     * 组织机构类型
     */
    private String isprofess;


    /*** 供应商名称*/
    private String supName;

    /*** 所属组织机构全称*/
    private String orgFullName;
    /**
     * 会员ID
     */
    private Long memId;
    /**
     * 会员
     */
    private Long memIdIn;
    /**
     * 支付方式（0： 1：微信 2：支付宝 3：沃支付 4：易支付 5：QQ支付）
     */
    private Integer payTypeIn;
    private Long parentOrgIdIn;
    private Long rootOrgIdIn;
    private List<UmcStationBO> umcStationsListWebExt;
    /**
     * 机构ID List
     * 只有机构管理员才有
     */
    private List<Long> mgOrgIdsExt;
    /**
     * 账号类型
     * 0 运营单位
     * 1 采购单位
     * 2 供应商
     */
    private String isProfessionalOrgExt;
    /**
     * 供应商ID
     */
    private Long supId;
    /**
     * 老系统的用户id
     */
    private String oldMemIdIn;
    /**
     * 角色
     */
    private Set<UmcAuthorityInfo> permission = new HashSet<>();
    /**
     * 角色名称信息
     */
    private List<UmcUserRoleBO> umcUserRoleBOList;

    private List<String> selfStationCodes;
    private String institutionalCode;

    /**
     * 租户ID
     */
    private String tenantId;
}


