package com.tydic.dyc.base.exception;

/**
 * 标题:BaseBusinessException
 * 说明:
 * 时间:2022/2/21 16:45
 * 作者:田桂银
 */
public class BaseBusinessException extends RuntimeException {
    private static final long serialVersionUID = 146688721847685861L;

    private String msgCode;
    private String[] args;

    public String getMsgCode() {
        return this.msgCode;
    }

    public String[] getArgs() {
        return this.args;
    }

    public String getMsgInfo() {
        return this.getMessage();
    }

    public BaseBusinessException(String msgId, String message) {
        super(message);
        this.msgCode = msgId;
    }

    public BaseBusinessException(String msgId, String message, Throwable cause) {
        super(message, cause);
        this.args = new String[1];
        this.args[0] = message;
        this.msgCode = msgId;
    }
}


