/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.base.utils.gendoc;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.utils.gendoc.bo.GenericObject;
import com.tydic.dyc.base.utils.gendoc.bo.ParamBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import com.tydic.utils.generatedoc.annotation.DocInterface;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class GenDocUtil {
    private static final String DEFAULT_FIELD_DESC = " ";
    private static final String REQUIRED_YES = "Y";
    private static final String REQUIRED_NO = "N";
    private static final String VOID_RETURN = "void";
    private static final boolean GEN_INPUT = true;
    private static final boolean GEN_OUTPUT = false;
    private static final String HTML_NAME = "code2Confluence.html";
    private static Set<String> exclude = new HashSet<String>();

    public static String genInput(Class parameterType) {
        StringBuilder sb = new StringBuilder();
        GenDocUtil.genParam(sb, parameterType, true);
        return sb.toString();
    }

    public static String genOutput(Class parameterType) {
        StringBuilder sb = new StringBuilder();
        GenDocUtil.genParam(sb, parameterType, false);
        return sb.toString();
    }

    public static String parseInterface(Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            System.err.println("\u624b\u5de5\u8b66\u544a: \u63a5\u53e3[" + interfaceClass.getName() + "]\u4e0d\u662f\u63a5\u53e3\uff0c\u5df2\u8df3\u8fc7\u751f\u6210\u5176\u6587\u6863");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Method[] methods = interfaceClass.getDeclaredMethods();
        if (methods.length == 0) {
            System.err.println("\u624b\u5de5\u8b66\u544a: \u63a5\u53e3[" + interfaceClass.getName() + "]\u4e00\u4e2a\u65b9\u6cd5\u4e5f\u6ca1\u6709\uff0c\u5df2\u8df3\u8fc7\u751f\u6210\u5176\u6587\u6863");
            return null;
        }
        DocInterface annotation = null;
        for (Method method : methods) {
            DocInterface tmpAnnotation = method.getAnnotation(DocInterface.class);
            if (tmpAnnotation == null) continue;
            annotation = tmpAnnotation;
            break;
        }
        if (annotation == null) {
            System.err.println("\u624b\u5de5\u8b66\u544a: \u63a5\u53e3[" + interfaceClass.getName() + "]\u6ca1\u6709\u65b9\u6cd5\u6709\u6587\u6863\u751f\u6210\u6ce8\u89e3");
            return null;
        }
        String interfaceSimpleName = interfaceClass.getSimpleName();
        String interfaceName = interfaceClass.getName();
        String interfaceDesc = annotation.value();
        String[] logic = annotation.logic();
        String[] keyDataChanges = annotation.keyDataChanges();
        Method method = methods[0];
        String methodName = method.getName();
        sb.append(GenDocUtil.genDesc(interfaceSimpleName + "\u63a5\u53e3\u7684" + methodName + "\u65b9\u6cd5\uff0c\u7528\u4e8e" + interfaceDesc));
        sb.append(GenDocUtil.genUsed(interfaceDesc));
        sb.append(GenDocUtil.genInterBaseInfo(interfaceDesc, interfaceSimpleName));
        boolean noInput = false;
        boolean noReturn = false;
        Class<?> parameterType = null;
        Class<?> returnType = method.getReturnType();
        if (method.getParameterTypes().length == 0) {
            noInput = true;
        } else {
            parameterType = method.getParameterTypes()[0];
        }
        if (VOID_RETURN.equals(returnType.getName())) {
            noReturn = true;
        }
        String inputClassName = noInput ? DEFAULT_FIELD_DESC : parameterType.getName();
        String outputClassName = noReturn ? DEFAULT_FIELD_DESC : returnType.getName();
        sb.append(GenDocUtil.genDeploy(interfaceName, inputClassName, outputClassName, methodName));
        if (!noInput) {
            GenDocUtil.genParam(sb, parameterType, true);
        }
        if (!noReturn) {
            GenDocUtil.genParam(sb, returnType, false);
        }
        sb.append(GenDocUtil.genReturnCode());
        sb.append(GenDocUtil.genLogic(logic));
        sb.append(GenDocUtil.genKey(keyDataChanges));
        sb.append(GenDocUtil.genUseDemo());
        return sb.toString();
    }

    private static void genParam(StringBuilder sb, Class parameterType, boolean isInput) {
        String inputParam = "\n||\u5165\u53c2\uff1a" + parameterType.getName() + "\n|\u540d\u79f0|\u8bf4\u660e|\u7c7b\u578b|\u5fc5\u586b|\u9ed8\u8ba4\u503c|\u957f\u5ea6|\u5e38\u91cf\u5b9a\u4e49\n";
        String outPutParam = "\n||\u51fa\u53c2\uff1a" + parameterType.getName() + "\n|\u540d\u79f0|\u8bf4\u660e|\u7c7b\u578b|\u9ed8\u8ba4\u503c|\u957f\u5ea6|\u5e38\u91cf\u5b9a\u4e49\n";
        if (isInput) {
            sb.append(inputParam);
        } else {
            sb.append(outPutParam);
        }
        List<Field> fields = GenDocUtil.getAllFields(parameterType);
        List<Class> allGeneric = GenDocUtil.getAllGeneric(parameterType);
        if (fields.size() == 0) {
            return;
        }
        LinkedHashSet<Class> classHashSet = new LinkedHashSet<Class>(allGeneric);
        for (Field field : fields) {
            ParamBo paramBo = new ParamBo();
            paramBo.setName(field.getName());
            if (exclude.contains(field.getName())) {
                paramBo.setName(field.getName() + "_");
            }
            paramBo.setDesc(DEFAULT_FIELD_DESC);
            paramBo.setRequired(REQUIRED_NO);
            Class<?> typeClass = field.getType();
            if (field.isAnnotationPresent(DocField.class)) {
                DocField annotation = field.getAnnotation(DocField.class);
                paramBo.setDesc(annotation.value());
                if (annotation.required()) {
                    paramBo.setRequired(REQUIRED_YES);
                }
            } else {
                if ("code".equals(field.getName())) {
                    paramBo.setDesc("\u5e94\u7b54\u8fd4\u56de\u72b6\u6001\u7801");
                }
                if ("message".equals(field.getName())) {
                    paramBo.setDesc("\u5e94\u7b54\u8fd4\u56de\u63cf\u8ff0");
                }
            }
            GenericObject genericType = GenDocUtil.getGenericType(field);
            String fieldTypeStr = genericType.getGenericStr();
            paramBo.setType(fieldTypeStr);
            if (isInput) {
                sb.append("| ").append(paramBo.getName()).append("| ").append(paramBo.getDesc()).append(" | ").append(paramBo.getType()).append("|").append(paramBo.getRequired()).append("| | | |\n");
            } else {
                sb.append("| ").append(paramBo.getName()).append("| ").append(paramBo.getDesc()).append(" | ").append(paramBo.getType()).append("| | | |\n");
            }
            if (!GenDocUtil.isJavaClass(typeClass)) {
                classHashSet.add(typeClass);
            }
            if (!genericType.isGeneric()) continue;
            classHashSet.addAll(genericType.getGenericClasses());
        }
        sb.append("\n\n");
        for (Class aClass : classHashSet) {
            if (parameterType.equals(aClass) || GenDocUtil.isJavaClass(aClass)) continue;
            GenDocUtil.genParam(sb, aClass, isInput);
        }
    }

    private static String isListField(Field field) {
        Class<List> fieldClazz = field.getType();
        if (fieldClazz.isPrimitive()) {
            return null;
        }
        if (fieldClazz.isAssignableFrom(List.class)) {
            Type fc = field.getGenericType();
            if (fc == null) {
                return null;
            }
            if (fc instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)fc;
                Class genericClazz = (Class)pt.getActualTypeArguments()[0];
                return "List<" + genericClazz.getSimpleName() + ">";
            }
        }
        return null;
    }

    private static Class getListFieldClass(Field field) {
        Class<List> fieldClazz = field.getType();
        if (fieldClazz.isPrimitive()) {
            return null;
        }
        if (fieldClazz.isAssignableFrom(List.class)) {
            Type fc = field.getGenericType();
            if (fc == null) {
                return null;
            }
            if (fc instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)fc;
                return (Class)pt.getActualTypeArguments()[0];
            }
        }
        return null;
    }

    private static boolean isJavaClass(Class<?> clz) {
        return clz != null && clz.getClassLoader() == null;
    }

    private static String genDesc(String desc) {
        return "||*\u63cf\u8ff0*\n|" + desc + "\n";
    }

    private static String genUsed(String used) {
        return "\nh2. \u4f7f\u7528\u573a\u666f\uff1a\n||*\u4f7f\u7528\u573a\u666f*\n|" + used + "\n";
    }

    private static String genInterBaseInfo(String desc, String intName) {
        return "\nh2. \u63a5\u53e3\u57fa\u672c\u4fe1\u606f\uff1a\n\n||\u63a5\u53e3\u57fa\u672c\u4fe1\u606f\n|\u63a5\u53e3\u540d\u79f0|" + desc + "\n|HTTP\u8bf7\u6c42\u65b9\u5f0f|HTTP-POST\n|\u63a5\u53e3\u5730\u5740|\u6b63\u5f0f\uff1a[http://ip:port/ ] \n\u6d4b\u8bd5\uff1a[http://ip:port/ ]\n|rap\u8c03\u7528\u5730\u5740| |\n";
    }

    private static String genDeploy(String intName, String inputName, String outPutParam, String methodName) {
        return "\nh2. \u5e73\u53f0\u7ec4\u90e8\u7f72\u4f9d\u636e\uff1a\n\n||\u5e73\u53f0\u7ec4\u90e8\u7f72\u4f9d\u636e|\n|\u670d\u52a1\u5b9a\u4e49|\u503c\n|\u670d\u52a1\u540d\u79f0|" + intName + "\n|\u5165\u53c2\u7c7b\u540d|" + inputName + "\n|\u51fa\u53c2\u7c7b\u540d|" + outPutParam + "\n|\u65b9\u6cd5\u540d\u79f0|" + methodName + "\n\nh2. \u53c2\u6570\u8bf4\u660e\uff1a\n";
    }

    private static List<Class> getAllGeneric(Class clazz) {
        LinkedList<Class> list = new LinkedList<Class>();
        if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
            Type[] actualTypeArguments;
            ParameterizedType pt = (ParameterizedType)clazz.getGenericSuperclass();
            for (Type actualTypeArgument : actualTypeArguments = pt.getActualTypeArguments()) {
                try {
                    Class<?> aClazz = Class.forName(actualTypeArgument.getTypeName());
                    if (aClazz.isInterface()) continue;
                    list.add(aClazz);
                }
                catch (ClassNotFoundException e) {
                    System.err.println("\u83b7\u53d6\u7c7b\u5f97\u6cdb\u578b\u65f6\u6709\u4e0d\u660e\u786e\u7684\u6cdb\u578b\u7c7b\uff1a[" + actualTypeArgument.getTypeName() + "],\u5df2\u5ffd\u7565\u6389\u9012\u5f52\u89e3\u6790");
                }
            }
        }
        return list;
    }

    private static List<Field> getAllFields(Class inputClass) {
        ArrayList<Field> retList = new ArrayList<Field>();
        Stack classStack = new Stack();
        LinkedList classList = new LinkedList();
        for (Class clazz = inputClass; clazz != null; clazz = clazz.getSuperclass()) {
            classStack.push(clazz);
        }
        while (!classStack.empty()) {
            classList.add(classStack.pop());
        }
        for (Class aClass : classList) {
            Field[] fieldList;
            if ("java.lang.Object".equals(aClass.getName())) continue;
            for (Field field : fieldList = aClass.getDeclaredFields()) {
                if (!"serialVersionUID".equals(field.getName()) && field.getAnnotation(DocField.class) != null) {
                    retList.add(field);
                }
                if (!"code".equals(field.getName()) && !"message".equals(field.getName()) || !"com.tydic.dyc.base.bo.RspBO".equals(aClass.getName())) continue;
                retList.add(field);
            }
        }
        return retList;
    }

    private static String genReturnCode() {
        return "\n||\u8fd4\u56de\u7801\n|\u8fd4\u56de\u7f16\u7801|\u8fd4\u56de\u63cf\u8ff0|\u8fd4\u56de\u573a\u666f\u63cf\u8ff0\n|0000|\u6210\u529f| |\n|8888|\u7cfb\u7edf\u5f02\u5e38| |\n";
    }

    private static String genLogic(String[] logic) {
        StringBuilder logicSb = new StringBuilder("\nh2. \u4e1a\u52a1\u903b\u8f91\uff1a\n\n||\u4e1a\u52a1\u903b\u8f91\n|\u6b65\u9aa4|\u63cf\u8ff0\n");
        for (int i = 0; i < logic.length; ++i) {
            logicSb.append("|").append(i + 1).append("|").append(logic[i]).append(" |\n");
        }
        return logicSb.toString();
    }

    private static String genKey(String[] keyChange) {
        StringBuilder keyChangeSb = new StringBuilder("\nh2. \u5173\u952e\u6570\u636e\u53d8\u5316\uff1a\n\n||\u5173\u952e\u6570\u636e\u53d8\u5316\n|\u8868\u540d|\u53d8\u5316\u63cf\u8ff0\n");
        for (int i = 0; i < keyChange.length; ++i) {
            if (!ObjectUtil.isNotEmpty((Object)keyChange[i])) continue;
            String[] split = keyChange[i].split(":");
            keyChangeSb.append("|").append(split[0]).append("|").append(split[1]).append(" |\n");
        }
        return keyChangeSb.toString();
    }

    private static String genUseDemo() {
        return "\nh2. \u4f7f\u7528\u793a\u4f8b\uff1a\n\n||\u793a\u4f8b\u62a5\u6587| |\n|\u5165\u53c2\u62a5\u6587| |\n|\u51fa\u53c2\u62a5\u6587| |";
    }

    private static GenericObject getGenericType(Field field) {
        GenericObject rsp = new GenericObject();
        Class<?> type = field.getType();
        rsp.setSelfClass(type);
        LinkedList<Class> genericClasses = new LinkedList<Class>();
        rsp.setGenericClasses(genericClasses);
        Type genericType = field.getGenericType();
        StringBuilder sb = new StringBuilder();
        if (genericType instanceof ParameterizedType) {
            rsp.setGeneric(true);
            ParameterizedType pt = (ParameterizedType)genericType;
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            sb.append(type.getSimpleName()).append("<");
            for (Type actualTypeArgument : actualTypeArguments) {
                try {
                    Class<?> clazz = Class.forName(actualTypeArgument.getTypeName());
                    if (clazz.isInterface()) continue;
                    genericClasses.add(clazz);
                    sb.append(clazz.getSimpleName()).append(",");
                }
                catch (ClassNotFoundException e) {
                    System.err.println("\u6709\u4e0d\u660e\u786e\u7684\u6cdb\u578b\u7c7b\uff1a[" + actualTypeArgument.getTypeName() + "],\u5df2\u5ffd\u7565\u6389\u9012\u5f52\u89e3\u6790");
                    sb.append(actualTypeArgument.getTypeName()).append(",");
                }
            }
            String willStr = sb.toString();
            rsp.setGenericStr(willStr.substring(0, willStr.length() - 1) + ">");
        } else {
            rsp.setGeneric(false);
            sb.append(type.getSimpleName());
            rsp.setGenericStr(sb.toString());
        }
        return rsp;
    }

    static {
        exclude.add("hostName");
    }
}

