package com.tydic.dyc.base.utils;

import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Field;

/**
 * 类名：StrUtil
 * 说明：字符串处理
 * 作者：lishiqing
 * 时间： 2025/1/21 14:05
 */
public class StrUtil {
    /**
     * 把对象中的 String 类型的null字段，转换为空字符串
     *
     * @param <T> 待转化对象类型
     * @param cls 待转化对象
     * @return 转化好的对象
     */
    public static <T> T noNullStringAttr(T cls) {
        Field[] fields = cls.getClass().getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return cls;
        }
        for (Field field : fields) {
            if(field.getType().isAssignableFrom(String.class)){
                field.setAccessible(true);
                try {
                    Object value = field.get(cls);
                    if (value != null) {
                        if(StringUtils.length(StringUtils.trim(String.valueOf(value)))==0) {
                            field.set(cls, null);
                        }else{
                            field.set(cls, StringUtils.trim(String.valueOf(value)));
                        }
                    }
                } catch (IllegalArgumentException | IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return cls;
    }
}
