/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.resource.access.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReThirdSourceAccessController {
    @Value(value="${portal_server_ip_inner}")
    private String portalServerIpInner;
    @Value(value="${portal_server_ip_out}")
    private String portalServerIpOut;
    @Value(value="${file.access.url}")
    private String fileAccessUrl;
    @Value(value="${file.cycle.num:10}")
    private int fileCycleNum;

    @RequestMapping(value={"/dyc-ext-resource/**"})
    public void accessThirdSource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String nginxIp = request.getRemoteAddr();
        String requestUrl = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != queryString) {
            requestUrl = requestUrl + "?" + queryString;
        }
        String fileName = ReThirdSourceAccessController.getFileName(requestUrl);
        String innerUrl = this.fileAccessUrl + "/dyc-ext-resource" + ReThirdSourceAccessController.getFileUrl(requestUrl) + fileName;
        String outUrl = "http:/" + requestUrl.substring(requestUrl.indexOf("/dyc-ext-resource/") + 17);
        if (nginxIp.equals(this.portalServerIpInner.substring(this.portalServerIpInner.indexOf("://") + 3))) {
            int bytesRead;
            URL url = new URL(innerUrl);
            InputStream inputStream = null;
            HttpURLConnection urlConnection = null;
            try {
                urlConnection = (HttpURLConnection)url.openConnection();
                String contentType = urlConnection.getContentType();
                inputStream = urlConnection.getInputStream();
                response.setContentType(contentType);
            }
            catch (FileNotFoundException e) {
                int cycleNum = ReThirdSourceAccessController.getCycleNum(requestUrl);
                if (cycleNum >= this.fileCycleNum) {
                    response.sendRedirect("/404.html");
                    return;
                }
                ++cycleNum;
                try {
                    Thread.sleep(cycleNum * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                String redirectUrl = "/dyc-ext-resource/&" + cycleNum + "&" + ReThirdSourceAccessController.getFileUrl(requestUrl) + ReThirdSourceAccessController.getFileName(requestUrl);
                response.sendRedirect(redirectUrl);
                return;
            }
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
        } else {
            response.sendRedirect(outUrl);
        }
    }

    private static int getCycleNum(String url) {
        int recycleEndIndex;
        int cycleNum = 0;
        int recycleStartIndex = url.indexOf("/&");
        if (recycleStartIndex != -1) {
            url = url.substring(recycleStartIndex + 2);
        }
        if ((recycleEndIndex = url.indexOf("&/")) != -1) {
            cycleNum = Integer.parseInt(url.substring(0, recycleEndIndex));
        }
        return cycleNum;
    }

    private static String getFileUrl(String url) {
        int indexOfQuestionMark;
        int recycleEndIndex;
        String fileUrl = url.substring(17);
        int recycleStartIndex = fileUrl.indexOf("/&");
        if (recycleStartIndex != -1) {
            fileUrl = fileUrl.substring(recycleStartIndex + 2);
        }
        if ((recycleEndIndex = fileUrl.indexOf("&/")) != -1) {
            fileUrl = fileUrl.substring(recycleEndIndex + 1);
        }
        if ((indexOfQuestionMark = fileUrl.indexOf("?")) != -1) {
            fileUrl = fileUrl.substring(0, indexOfQuestionMark);
        }
        int lastSlashIndex = fileUrl.lastIndexOf(47);
        fileUrl = fileUrl.substring(0, lastSlashIndex + 1);
        if (url.indexOf("?") != -1) {
            String[] pairs;
            String query = url.substring(url.indexOf("?") + 1);
            for (String pair : pairs = query.split("&")) {
                int indexOfEqualsSign = pair.indexOf("=");
                if (indexOfEqualsSign == -1) continue;
                try {
                    String value = URLDecoder.decode(pair.substring(indexOfEqualsSign + 1), "UTF-8");
                    fileUrl = fileUrl + value + "/";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return fileUrl;
    }

    private static String getFileName(String url) {
        int startIndex = url.indexOf("/dyc-ext-resource/");
        String fileUrl = url.substring(startIndex + 1);
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0, indexOfQuestionMark);
        }
        int lastSlashIndex = fileUrl.lastIndexOf(47);
        String fileName = fileUrl.substring(lastSlashIndex + 1);
        return fileName;
    }

    public static void main(String[] args) {
        String url = "/dyc-ext-resource/{111}/esp-oss.zkh360.com/Webshop/images/product_detail_v1.css";
        System.out.println(ReThirdSourceAccessController.getFileUrl(url));
        System.out.println(ReThirdSourceAccessController.getCycleNum(url));
    }
}

