/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.resource.access.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReThirdSourceAccessController {
    @Value(value="${portal_server_ip_inner}")
    private String portalServerIpInner;
    @Value(value="${portal_server_ip_out}")
    private String portalServerIpOut;
    @Value(value="${file.access.url}")
    private String fileAccessUrl;
    @Value(value="${file.cycle.num:10}")
    private int fileCycleNum;

    @RequestMapping(value={"/dyc-ext-resource/**"})
    public void accessThirdSource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String nginxIp = request.getRemoteAddr();
        String requestUrl = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != queryString) {
            requestUrl = requestUrl + "?" + queryString;
        }
        String fileUrl = ReThirdSourceAccessController.getFileUrl(requestUrl);
        String innerUrl = this.fileAccessUrl + "/dyc-ext-resource" + fileUrl;
        String outUrl = "http:/" + requestUrl.substring(requestUrl.indexOf("/dyc-ext-resource/") + 17);
        if (nginxIp.equals(this.portalServerIpInner.substring(this.portalServerIpInner.indexOf("//") + 2))) {
            int bytesRead;
            URL url = new URL(innerUrl);
            InputStream inputStream = null;
            HttpURLConnection urlConnection = null;
            try {
                urlConnection = (HttpURLConnection)url.openConnection();
                String contentType = urlConnection.getContentType();
                inputStream = urlConnection.getInputStream();
                response.setContentType(contentType);
            }
            catch (FileNotFoundException e) {
                int cycleNum = ReThirdSourceAccessController.getCycleNum(requestUrl);
                if (cycleNum >= this.fileCycleNum) {
                    response.sendRedirect("/404.html");
                    return;
                }
                ++cycleNum;
                try {
                    Thread.sleep(cycleNum * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                String redirectUrl = "/dyc-ext-resource/&" + cycleNum + "&" + fileUrl;
                response.sendRedirect(redirectUrl);
                return;
            }
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
        } else {
            response.sendRedirect(outUrl);
        }
    }

    private static int getCycleNum(String url) {
        int recycleEndIndex;
        int cycleNum = 0;
        int recycleStartIndex = url.indexOf("/&");
        if (recycleStartIndex != -1) {
            url = url.substring(recycleStartIndex + 2);
        }
        if ((recycleEndIndex = url.indexOf("&/")) != -1) {
            cycleNum = Integer.parseInt(url.substring(0, recycleEndIndex));
        }
        return cycleNum;
    }

    private static String getFileUrl(String url) {
        int recycleEndIndex;
        String fileUrl = url.substring(17);
        int recycleStartIndex = fileUrl.indexOf("/&");
        if (recycleStartIndex != -1) {
            fileUrl = fileUrl.substring(recycleStartIndex + 2);
        }
        if ((recycleEndIndex = fileUrl.indexOf("&/")) != -1) {
            fileUrl = fileUrl.substring(recycleEndIndex + 1);
        }
        return fileUrl;
    }

    private static String getFileName(String url) {
        int startIndex = url.indexOf("/dyc-ext-resource/");
        String fileUrl = url.substring(startIndex + 1);
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0, indexOfQuestionMark);
        }
        int lastSlashIndex = fileUrl.lastIndexOf(47);
        String fileNameFull = fileUrl.substring(lastSlashIndex + 1);
        String fileName = fileNameFull.substring(0, fileNameFull.indexOf(".") + 1);
        String fileSuffix = fileNameFull.substring(fileNameFull.indexOf(".") + 1).replaceAll("[^a-zA-Z0-9]", "/");
        fileSuffix = fileSuffix.substring(0, fileSuffix.indexOf("/"));
        fileName = fileName + fileSuffix;
        return fileName;
    }

    public static void main(String[] args) {
        String url = "//dyc-ext-resource/&111&/esp-oss.zkh360.com/Webshop/images/product_detail_v1.css_abc";
        int startIndex = url.indexOf("//");
        System.out.println(url.substring(startIndex + 2));
        System.out.println(ReThirdSourceAccessController.getCycleNum(url));
    }
}

