/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.resource.access.controller;

import com.ohaotian.plugin.file.FileClient;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReThirdSourceAccessController {
    private static final Logger log = LoggerFactory.getLogger(ReThirdSourceAccessController.class);
    @Value(value="${file.cycle.num:10}")
    private int fileCycleNum;
    @Value(value="${re.access.url.mapping:ngIp:ossUrl}")
    private String[] accessUrlMap;
    @Autowired
    private FileClient fileClient;

    @RequestMapping(value={"/dyc-ext-resource/**"})
    public void accessThirdSource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String nginxIps = request.getHeader("X-forwarded-for");
        log.info("nginxIps:{}", (Object)nginxIps);
        String requestUrl = request.getRequestURI();
        String queryString = request.getQueryString();
        if (null != queryString) {
            requestUrl = requestUrl + "?" + queryString;
        }
        String fileUrl = ReThirdSourceAccessController.getFileUrl(requestUrl);
        String outUrl = "https:/" + requestUrl.substring(requestUrl.indexOf("/dyc-ext-resource/") + 17);
        Boolean exist = false;
        for (String accessUrl : this.accessUrlMap) {
            int bytesRead;
            String[] accessUrl1 = accessUrl.split("->");
            if (!nginxIps.contains(accessUrl1[0])) continue;
            String innerUrl = "/dyc-ext-resource" + fileUrl;
            InputStream inputStream = null;
            try {
                inputStream = this.fileClient.downLoadToInputStream(innerUrl);
            }
            catch (Exception e) {
                int cycleNum = ReThirdSourceAccessController.getCycleNum(requestUrl);
                if (cycleNum >= this.fileCycleNum) {
                    response.sendRedirect("/404.html");
                    return;
                }
                ++cycleNum;
                try {
                    Thread.sleep(cycleNum * 1000);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                String redirectUrl = "/dyc-ext-resource/&" + cycleNum + "&" + fileUrl;
                response.sendRedirect(redirectUrl);
                return;
            }
            ServletOutputStream outputStream = response.getOutputStream();
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
            exist = true;
            break;
        }
        if (!exist.booleanValue()) {
            response.sendRedirect(outUrl);
        }
    }

    private static int getCycleNum(String url) {
        int recycleEndIndex;
        int cycleNum = 0;
        int recycleStartIndex = url.indexOf("/&");
        if (recycleStartIndex != -1) {
            url = url.substring(recycleStartIndex + 2);
        }
        if ((recycleEndIndex = url.indexOf("&/")) != -1) {
            cycleNum = Integer.parseInt(url.substring(0, recycleEndIndex));
        }
        return cycleNum;
    }

    private static String getFileUrl(String url) {
        int indexOfQuestionMark;
        int recycleEndIndex;
        String fileUrl = url.substring(17);
        int recycleStartIndex = fileUrl.indexOf("/&");
        if (recycleStartIndex != -1) {
            fileUrl = fileUrl.substring(recycleStartIndex + 2);
        }
        if ((recycleEndIndex = fileUrl.indexOf("&/")) != -1) {
            fileUrl = fileUrl.substring(recycleEndIndex + 1);
        }
        if ((indexOfQuestionMark = fileUrl.indexOf("?")) != -1) {
            fileUrl = fileUrl.substring(0, indexOfQuestionMark);
        }
        return fileUrl;
    }

    private static String getFileName(String url) {
        int startIndex = url.indexOf("/dyc-ext-resource/");
        String fileUrl = url.substring(startIndex + 1);
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0, indexOfQuestionMark);
        }
        int lastSlashIndex = fileUrl.lastIndexOf(47);
        String fileNameFull = fileUrl.substring(lastSlashIndex + 1);
        String fileName = fileNameFull.substring(0, fileNameFull.indexOf(".") + 1);
        String fileSuffix = fileNameFull.substring(fileNameFull.indexOf(".") + 1).replaceAll("[^a-zA-Z0-9]", "/");
        fileSuffix = fileSuffix.substring(0, fileSuffix.indexOf("/"));
        fileName = fileName + fileSuffix;
        return fileName;
    }

    public static void main(String[] args) {
        String nginxIps = "11.11.123.134";
        String a = "11.11.123.134->abc";
        String[] b = a.split("->");
        System.out.println(b[0]);
        System.out.println(b[1]);
        System.out.println(nginxIps.contains(b[0]));
        String url = "/dyc-ext-resource/sku-market-gw.jd.com/css/pc/100056468024.css?t=1688019853857";
        System.out.println(ReThirdSourceAccessController.getFileUrl(url));
    }
}

