package com.tydic.dyc.resource.access.controller;

import com.ohaotian.plugin.file.FileClient;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * 标题:ReThirdSourceAccessController
 * 说明:TODO
 * 时间:2023/9/12 15:09
 * 作者:代愿愿
 */
@RestController
@Slf4j
public class ReThirdSourceAccessController {
    @Value("${file.cycle.num:10}")
    private int fileCycleNum;

    @Value("${re.access.url.mapping:ngIp:ossUrl}")
    private String[] accessUrlMap;
    @Autowired
    private FileClient fileClient;
    @RequestMapping("/dyc-ext-resource/**")
    public void accessThirdSource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        // 获取Ip
        String nginxIps = request.getHeader("X-forwarded-for");
        log.info("nginxIps:{}",nginxIps);
        // 获取访问路径
        String requestUrl = request.getRequestURI();
        if(requestUrl.contains("/noauth")){
            requestUrl = requestUrl.replace("/noauth","");
        }
        // 获取访问参数
        String queryString = request.getQueryString();
        if (null != queryString) {
            requestUrl = requestUrl + "?" + queryString;
        }
        // 内网访问地址
        // 获取文件路径
        String fileUrl = getFileUrl(requestUrl);
        //String innerUrl = fileAccessUrl +"/dyc-ext-resource"+fileUrl;
        // 外网访问地址
        String outUrl = "https:/" + requestUrl.substring(requestUrl.indexOf("/dyc-ext-resource/") + 17);
        Boolean exist = false;
        for (String accessUrl : accessUrlMap) {
            String[] accessUrl1 =  accessUrl.split("->");
            if(nginxIps.contains(accessUrl1[0])){
                // String innerUrl = accessUrl1[1]+"/dyc-ext-resource"+fileUrl;
                String innerUrl ="dyc-ext-resource"+fileUrl;
                InputStream inputStream = null;
                try {
                    // 获取文件连接
                    //urlConnection = (HttpURLConnection) url.openConnection();
                    // 获取类型
                    //String contentType = urlConnection.getContentType();
                    // 获取文件流
                    inputStream = fileClient.downLoadToInputStream(innerUrl);
                    //response.setContentType(contentType);
                } catch (Exception e) {
                    // 获取轮询次数
                    int cycleNum = getCycleNum(requestUrl);
                    if(cycleNum >= fileCycleNum){
                        // 轮询次数大于等于配置的轮询次数,重定向到404页面
                        response.sendRedirect("/404.html");
                        return;
                    }
                    cycleNum++;
                    // 睡眠1秒
                    try {
                        Thread.sleep(cycleNum*1000);
                    } catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    // 重定向到入参访问的地址
                    String redirectUrl = "/dyc-ext-resource/"+"&"+cycleNum+"&"+fileUrl;
                    response.sendRedirect(redirectUrl);
                    return;
                }
                // 输出文件内容
                OutputStream outputStream = response.getOutputStream();
                byte[] buffer = new byte[1024];
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                // 关闭流
                inputStream.close();
                outputStream.close();
                exist = true;
                break;
            }
        }
        if(!exist){
            response.sendRedirect(outUrl);
        }
    }
    private static int getCycleNum(String url){
        int cycleNum = 0;
        int recycleStartIndex = url.indexOf("/&");
        if (recycleStartIndex != -1) {
            url = url.substring(recycleStartIndex+2);
        }
        int recycleEndIndex = url.indexOf("&/");
        if (recycleEndIndex != -1) {
            cycleNum = Integer.parseInt(url.substring(0,recycleEndIndex));
        }
        return cycleNum;
    }
    private static String getFileUrl(String url){
        // 去掉 "/dyc-ext-resource"
        String fileUrl = url.substring(17);
        // 去掉{x}
        int recycleStartIndex = fileUrl.indexOf("/&");
        if (recycleStartIndex != -1) {
            fileUrl = fileUrl.substring(recycleStartIndex+2);
        }
        int recycleEndIndex = fileUrl.indexOf("&/");
        if (recycleEndIndex != -1) {
            fileUrl = fileUrl.substring(recycleEndIndex+1);
        }
        // 去掉参数
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0,indexOfQuestionMark);
        }
        return fileUrl;
/*

        // 去掉参数
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0,indexOfQuestionMark);
        }
        // 获取文件路径
        int lastSlashIndex = fileUrl.lastIndexOf('/');
        fileUrl = fileUrl.substring(0,lastSlashIndex+1);
        // 获取参数
        if(url.indexOf("?")!=-1){
            String query = url.substring(url.indexOf("?") + 1);
            // 获取参数把每个参数值作为文件夹拼接到文件路径后面
            String[] pairs = query.split("&");
            for (String pair : pairs) {
                int indexOfEqualsSign = pair.indexOf("=");
                if (indexOfEqualsSign != -1) {
                    try {
                        String value = URLDecoder.decode(pair.substring(indexOfEqualsSign + 1), "UTF-8");
                        fileUrl = fileUrl + value + "/";
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
*/

       /* return fileUrl;*/

    }
    private static String getFileName(String url){
        int startIndex = url.indexOf("/dyc-ext-resource/");
        String fileUrl = url.substring(startIndex+1);
        // 去掉参数
        int indexOfQuestionMark = fileUrl.indexOf("?");
        if (indexOfQuestionMark != -1) {
            fileUrl = fileUrl.substring(0,indexOfQuestionMark);
        }
        // 去掉非文件后缀信息
        int lastSlashIndex = fileUrl.lastIndexOf('/');
        String fileNameFull = fileUrl.substring(lastSlashIndex + 1);
        String fileName = fileNameFull.substring(0,fileNameFull.indexOf(".")+1);
        String fileSuffix = fileNameFull.substring(fileNameFull.indexOf(".")+1).replaceAll("[^a-zA-Z0-9]", "/");
        fileSuffix = fileSuffix.substring(0,fileSuffix.indexOf("/"));
        fileName = fileName+fileSuffix;
        return fileName;
    }

    public static void main(String[] args) {
        String nginxIps = "11.11.123.134";
        String a = "11.11.123.134->abc";
        String[] b = a.split("->");
        System.out.println(b[0]);
        System.out.println(b[1]);
        System.out.println(nginxIps.contains(b[0]));
        String url = "/dyc-ext-resource/sku-market-gw.jd.com/css/pc/100056468024.css?t=1688019853857";
        System.out.println(getFileUrl(url));
    }
}
