/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.utils.npc.aop;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.tydic.utils.npc.bo.NpcBaseRspBo;
import com.tydic.utils.npc.bo.NpcRpcControllerReqBo;
import com.tydic.utils.npc.bo.NpcRpcControllerRspBo;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import lombok.extern.ohaotian.TempServiceInfo;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpcNativeRpcCallAdvice
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(NpcNativeRpcCallAdvice.class);
    private final boolean isCall;
    private final String rpcCallUrl;
    private static final String SUCCESS_CODE = "0";

    public NpcNativeRpcCallAdvice(boolean isCall, String rpcCallUrl) {
        this.isCall = isCall;
        this.rpcCallUrl = rpcCallUrl;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Method method;
        Class<?> aClass;
        TempServiceInfo tempAnnotation;
        if (this.isCall && null != (tempAnnotation = (aClass = (method = methodInvocation.getMethod()).getDeclaringClass()).getAnnotation(TempServiceInfo.class))) {
            String responseBody;
            NpcBaseRspBo baseRspBo;
            NpcRpcControllerReqBo reqBo = new NpcRpcControllerReqBo();
            reqBo.setInterClass(aClass.getName());
            reqBo.setMethod(method.getName());
            reqBo.setData(methodInvocation.getArguments()[0]);
            String reqBoJson = JSON.toJSONString((Object)reqBo);
            HttpResponse response = HttpRequest.post((String)this.rpcCallUrl).body(reqBoJson).timeout(60000).execute();
            if (200 != response.getStatus()) {
                String failureDesc = "\u8c03\u7528\u670d\u52a1\u5668RPC ControllerHttp\u8bf7\u6c42\u5931\u8d25\uff0c\u72b6\u6001\u7801\u4e3a\uff1a" + response.getStatus() + "\uff1b\u8bf7\u6c42\u5165\u53c2\uff1a" + reqBoJson + "\uff1b\u8bf7\u6c42\u5730\u5740\uff1a" + this.rpcCallUrl;
                log.info(failureDesc);
                baseRspBo = new NpcBaseRspBo();
                baseRspBo.setRespCode("8888");
                baseRspBo.setRespDesc(failureDesc);
                baseRspBo.setCode("1");
                baseRspBo.setMessage(failureDesc);
                responseBody = JSON.toJSONString((Object)baseRspBo);
            } else {
                responseBody = response.body();
            }
            NpcRpcControllerRspBo rspBo = (NpcRpcControllerRspBo)JSON.parseObject((String)responseBody, NpcRpcControllerRspBo.class);
            if (!SUCCESS_CODE.equals(rspBo.getCode())) {
                baseRspBo = new NpcBaseRspBo();
                baseRspBo.setRespCode("8888");
                baseRspBo.setRespDesc(rspBo.getMessage());
                baseRspBo.setCode(rspBo.getCode());
                baseRspBo.setMessage(rspBo.getMessage());
                rspBo.setData(baseRspBo);
            }
            AnnotatedType annotatedReturnType = methodInvocation.getMethod().getAnnotatedReturnType();
            return JSON.parseObject((String)JSONObject.toJSONString((Object)rspBo.getData()), (Type)annotatedReturnType.getType(), (Feature[])new Feature[0]);
        }
        return methodInvocation.proceed();
    }
}

