/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.utils.npc.config;

import com.tydic.utils.npc.aop.NpcNativeRpcCallAdvice;
import com.tydic.utils.npc.properties.NpcNativeProperties;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(name={"npc.native.is-call"}, havingValue="true")
@EnableConfigurationProperties(value={NpcNativeProperties.class})
public class NpcConfigurableAdvisorConfig {
    private static final Logger log = LoggerFactory.getLogger(NpcConfigurableAdvisorConfig.class);
    private static final String DEFAULT_NATIVE_RPC_PACKAGE = "com.tydic.utils.npc.aaa";
    private static final String NATIVE_RPC_PACKAGE_DELIMITER = ",";
    @Autowired
    private NpcNativeProperties npcNativeProperties;

    @Bean
    public AspectJExpressionPointcutAdvisor configurableAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.npcNativeProperties.getPointcutPackage())) {
            if (this.npcNativeProperties.getPointcutPackage().contains(NATIVE_RPC_PACKAGE_DELIMITER)) {
                String[] nativeRpcPackageSplit;
                for (String nativeRpcPackageString : nativeRpcPackageSplit = this.npcNativeProperties.getPointcutPackage().split(NATIVE_RPC_PACKAGE_DELIMITER)) {
                    if (!StringUtils.hasText((String)nativeRpcPackageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(nativeRpcPackageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.npcNativeProperties.getPointcutPackage()).append("..*(..)))");
            }
        }
        if (null == expressionBuilder) {
            expressionBuilder = new StringBuilder();
            expressionBuilder.append("(execution(* ").append(DEFAULT_NATIVE_RPC_PACKAGE).append("..*(..)))");
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setExpression(expression);
        advisor.setAdvice((Advice)new NpcNativeRpcCallAdvice(this.npcNativeProperties.getIsCall(), this.npcNativeProperties.getServerAddress()));
        log.info("\u672c\u673aRPC\u8c03\u7528\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u662f\u5426\u542f\u7528\u672c\u673aRPC\u8c03\u7528\uff1a{}\uff1bRPC Controller\u5730\u5740\uff1a{}\uff1b\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", new Object[]{this.npcNativeProperties.getIsCall(), this.npcNativeProperties.getServerAddress(), expression});
        return advisor;
    }
}

