/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.extend.field.config;

import com.tydic.extend.field.advice.ConvertExtendFieldByPointCutAdvice;
import com.tydic.extend.field.properties.ExtendFieldConvertProperties;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="extend.field.converter", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={ExtendFieldConvertProperties.class})
public class ExtendFieldConvertConfigurableAdvisorConfig {
    private static final Logger log = LoggerFactory.getLogger(ExtendFieldConvertConfigurableAdvisorConfig.class);
    private static final String POINT_CUT_DELIMITER = ",";
    private ExtendFieldConvertProperties extendFieldConvertProperties;

    public ExtendFieldConvertConfigurableAdvisorConfig(ExtendFieldConvertProperties extendFieldConvertProperties) {
        this.extendFieldConvertProperties = extendFieldConvertProperties;
    }

    @Bean
    @Order(value=-1)
    public AspectJExpressionPointcutAdvisor logCaptureAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.extendFieldConvertProperties.getPointCutPackage())) {
            if (this.extendFieldConvertProperties.getPointCutPackage().contains(POINT_CUT_DELIMITER)) {
                String[] pointCutPackageSplit;
                for (String packageString : pointCutPackageSplit = this.extendFieldConvertProperties.getPointCutPackage().split(POINT_CUT_DELIMITER)) {
                    if (!StringUtils.hasText((String)packageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(packageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(packageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.extendFieldConvertProperties.getPointCutPackage()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setOrder(-100);
        advisor.setExpression(expression);
        advisor.setAdvice((Advice)new ConvertExtendFieldByPointCutAdvice());
        log.info("\u6269\u5c55\u5b57\u6bb5\u8f6c\u6362\u5668\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", (Object)expression);
        return advisor;
    }
}

