/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.extend.field.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.extend.field.advice.HandleExtendFieldByPointCutAdvice;
import com.tydic.extend.field.properties.ExtendFieldConvertProperties;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(prefix="extend.field.handle", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={ExtendFieldConvertProperties.class})
public class HandleExtendFieldConfigurable {
    private static final Logger log = LoggerFactory.getLogger(HandleExtendFieldConfigurable.class);
    private static final String POINT_CUT_DELIMITER = ",";
    private ExtendFieldConvertProperties extendFieldConvertProperties;

    public HandleExtendFieldConfigurable(ExtendFieldConvertProperties extendFieldConvertProperties) {
        this.extendFieldConvertProperties = extendFieldConvertProperties;
    }

    @Bean
    @Order
    public AspectJExpressionPointcutAdvisor extendFieldAdvisor(CacheClient cacheClient, JdbcTemplate jdbcTemplate) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText((String)this.extendFieldConvertProperties.getExtendHandlePointCutPackage())) {
            if (this.extendFieldConvertProperties.getExtendHandlePointCutPackage().contains(POINT_CUT_DELIMITER)) {
                String[] pointCutPackageSplit;
                for (String packageString : pointCutPackageSplit = this.extendFieldConvertProperties.getExtendHandlePointCutPackage().split(POINT_CUT_DELIMITER)) {
                    if (!StringUtils.hasText((String)packageString)) continue;
                    if (null == expressionBuilder) {
                        expressionBuilder = new StringBuilder();
                        expressionBuilder.append("(execution(* ").append(packageString).append("..*(..)))");
                        continue;
                    }
                    expressionBuilder.append(" || (execution(* ").append(packageString).append("..*(..)))");
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(this.extendFieldConvertProperties.getExtendHandlePointCutPackage()).append("..*(..)))");
            }
        }
        String expression = String.valueOf(expressionBuilder);
        advisor.setOrder(-10);
        advisor.setExpression(expression);
        advisor.setAdvice((Advice)new HandleExtendFieldByPointCutAdvice(cacheClient, jdbcTemplate));
        log.info("\u6269\u5c55\u5b57\u6bb5\u5904\u7406\u5207\u9762\u914d\u7f6e\u5b8c\u6210\uff0c\u5207\u70b9\u89c4\u5219\u4e3a\uff1a{}", (Object)expression);
        return advisor;
    }
}

