package com.tydic.extend.field.advice;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ReflectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BaseExtendBo;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import lombok.extern.slf4j.Slf4j;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import static com.tydic.extend.field.constants.ExtFieldConvertConstants.*;

/**
 * @ClassName ConvertExtendFieldByPointCutAdvice
 * @Description 转换器
 * @Author liugs
 * @Date 2022/5/16 16:40
 */
@Slf4j
public class ConvertExtendFieldByPointCutAdvice implements MethodInterceptor {

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        // 入参
        Object[] args = invocation.getArguments();
        if (null != args && args.length > 0) {
            for (Object arg : args) {
                if (arg instanceof BaseExtendBo) {
                    Object extFieldListObj = BeanUtil.getFieldValue(arg, EXT_FILED_NAME);
                    List<BaseExtendFieldBo> extFieldList = JSON.parseArray(JSON.toJSONString(extFieldListObj), BaseExtendFieldBo.class);
                    // 扩展字段对象列表为空，直接返回
                    if (CollectionUtils.isEmpty(extFieldList)) {
                        log.info("==扩展字段为空，无需转换");
                        continue;
                    }
                    // 将扩展字段列表赋值到对应的对象
                    convertExtendField(arg, null, extFieldList);
                    log.info("==扩展字段赋值完成");
                }
            }
        }

        Object result = invocation.proceed();
        return result;
    }

    /**
     * 描述 扩展字段赋值
     * @param obj               参数
     * @param keyPrefix         扩展字段名前缀
     * @param extFieldDataList  扩展字段对象列表
     * @return void
     * @author liugs
     * @date 2022/5/17 12:55
     */
    private void convertExtendField(Object obj, String keyPrefix, List<BaseExtendFieldBo> extFieldDataList) {
        // 对象本身的扩展字段对象列表
        List<BaseExtendFieldBo> ownExtFields;
        String extFieldNamePrefix = StringUtils.isEmpty(keyPrefix) ? POINT : keyPrefix + POINT;

        // 顶层对象属性编码路径不带点 [.]
        if (StringUtils.isEmpty(keyPrefix)) {
            ownExtFields = extFieldDataList.stream().filter(item -> !item.getFieldCode().contains(POINT)).collect(Collectors.toList());
        } else {
            // 子对象属性编码路径为字段名称 + . 作层级间隔
            ownExtFields = extFieldDataList.stream().filter(item -> item.getFieldCode().startsWith(extFieldNamePrefix)).collect(Collectors.toList());
            // 将对象属性编码路径作裁剪，去除前缀（包括自身和子对象的都会被截取）
            ownExtFields = ownExtFields.stream().
                    peek(item -> item.setFieldCode(item.getFieldCode().substring(item.getFieldCode().indexOf(POINT) + 1))).collect(Collectors.toList());
            // 不包含间隔符【.】的就是自身的扩展属性
            ownExtFields = ownExtFields.stream().filter(item -> !item.getFieldCode().contains(POINT)).collect(Collectors.toList());
        }

        BeanUtil.setFieldValue(obj, EXT_FILED_NAME, ownExtFields);
        // 将自身的扩展属性移除
        extFieldDataList.removeAll(ownExtFields);
        if (CollectionUtils.isEmpty(extFieldDataList)) {
            return;
        }
        // 取出剩余的扩展对象列表对象编码的第一层，第一层对应字段本身字段。
        Set<String> extFieldCodePrefixSet = extFieldDataList.stream().map(item -> item.getFieldCode().substring(0, item.getFieldCode().indexOf(POINT))).collect(Collectors.toSet());

        // 获取对象的所有字段
        Class<?> objClass = obj.getClass();
        List<String> objFields = Arrays.asList(ReflectUtil.getFields(objClass)).stream().map(item -> item.getName()).collect(Collectors.toList());

        // 上面取出来的字段可能会包含列表，有方括号，处理；同对象的字段取交集
        Set<String> haveExtendFieldNameSet = new HashSet<>(2);
        extFieldCodePrefixSet.forEach(item -> {
            if (item.contains(SQUARE_BRACKETS_OPEN)) {
                item = item.substring(0, item.indexOf(SQUARE_BRACKETS_OPEN));
            }
            if (objFields.contains(item)) {
                haveExtendFieldNameSet.add(item);
            }
        });

        // 遍历字段集合，按集合中的字段反射取值
        for (String fieldName : haveExtendFieldNameSet) {
            Object fieldValue = ReflectUtil.getFieldValue(obj, fieldName);
            if (fieldValue instanceof List) {
                Class clazz = fieldValue.getClass();
                // 反射调用获取list的size方法
                Method sizeMethod = ReflectUtil.getMethod(clazz, SIZE);
                // 获取集合大小
                int size = ReflectUtil.invoke(fieldValue, sizeMethod);
                // 反射获取到list的get方法
                Method getMethod = ReflectUtil.getMethod(clazz, GET, int.class);
                // 调用get方法获取数据
                Object firstListItem = ReflectUtil.invoke(fieldValue, getMethod, 0);
                if (!(firstListItem instanceof BaseExtendBo)) {
                    continue;
                }
                for (int i = 0; i < size; i++) {
                    Object listItem = ReflectUtil.invoke(fieldValue, getMethod, i);
                    convertExtendField(listItem, fieldName + SQUARE_BRACKETS_OPEN + i + SQUARE_BRACKETS_CLOSE, extFieldDataList);
                    if (CollectionUtils.isEmpty(extFieldDataList)) {
                        break;
                    }
                }
            } else if (fieldValue instanceof BaseExtendBo) {
                // 只有继承于基类的对象才有扩展字段，才需要转换
                convertExtendField(fieldValue, fieldName, extFieldDataList);
            }
            // 如果扩展字段为空，结束
            if (CollectionUtils.isEmpty(extFieldDataList)) {
                break;
            }
        }
    }
}
