package com.tydic.extend.field.config;

import com.tydic.extend.field.advice.ConvertExtendFieldByPointCutAdvice;
import com.tydic.extend.field.properties.ExtendFieldConvertProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;
/**
 * @ClassName ExtendFieldConvertConfigurableAdvisorConfig
 * @Description 配置
 * @Author liugs
 * @Date 2022/5/16 16:37
 */
@Slf4j
@Configuration
@ConditionalOnProperty(prefix = "extend.field.converter", name = "enable", havingValue = "true")
@EnableConfigurationProperties(ExtendFieldConvertProperties.class)
public class ExtendFieldConvertConfigurableAdvisorConfig {

    /** 切点分割符 */
    private static final String POINT_CUT_DELIMITER = ",";

    /** 扩展字段转换器配置项 */
    private ExtendFieldConvertProperties extendFieldConvertProperties;

    public ExtendFieldConvertConfigurableAdvisorConfig(ExtendFieldConvertProperties extendFieldConvertProperties) {
        this.extendFieldConvertProperties = extendFieldConvertProperties;
    }

    @Bean
    @Order(-1)
    public AspectJExpressionPointcutAdvisor logCaptureAdvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        // 组装切点规则
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText(extendFieldConvertProperties.getPointCutPackage())) {
            if (extendFieldConvertProperties.getPointCutPackage().contains(POINT_CUT_DELIMITER)) {
                String[] pointCutPackageSplit = extendFieldConvertProperties.getPointCutPackage().split(POINT_CUT_DELIMITER);
                for (String packageString : pointCutPackageSplit) {
                    if (StringUtils.hasText(packageString)) {
                        if (null == expressionBuilder) {
                            expressionBuilder = new StringBuilder();
                            expressionBuilder.append("(execution(* ").append(packageString).append("..*(..)))");
                        } else {
                            expressionBuilder.append(" || (execution(* ").append(packageString).append("..*(..)))");
                        }
                    }
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(extendFieldConvertProperties.getPointCutPackage()).append("..*(..)))");
            }
        }

        String expression = String.valueOf(expressionBuilder);
        advisor.setOrder(-100);
        advisor.setExpression(expression);
        advisor.setAdvice(new ConvertExtendFieldByPointCutAdvice());
        log.info("扩展字段转换器切面配置完成，切点规则为：{}",  expression);
        return advisor;
    }


}
