package com.tydic.extend.field.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.extend.field.advice.HandleExtendFieldByPointCutAdvice;
import com.tydic.extend.field.properties.ExtendFieldConvertProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

/**
 * @ClassName HandleExtendFieldConfigurable
 * @Description 阔字段处理配置
 * @Author liugs
 * @Date 2022/10/17 14:57
 */
@Slf4j
@Configuration
@ConditionalOnProperty(prefix = "extend.field.handle", name = "enable", havingValue = "true")
@EnableConfigurationProperties(ExtendFieldConvertProperties.class)
public class HandleExtendFieldConfigurable {

    /** 切点分割符 */
    private static final String POINT_CUT_DELIMITER = ",";

    /** 扩展字段转换器配置项 */
    private ExtendFieldConvertProperties extendFieldConvertProperties;

    public HandleExtendFieldConfigurable(ExtendFieldConvertProperties extendFieldConvertProperties) {
        this.extendFieldConvertProperties = extendFieldConvertProperties;
    }

    @Bean
    @Order
    public AspectJExpressionPointcutAdvisor extendFieldAdvisor(CacheClient cacheClient, JdbcTemplate jdbcTemplate) {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        // 组装切点规则
        StringBuilder expressionBuilder = null;
        if (StringUtils.hasText(extendFieldConvertProperties.getExtendHandlePointCutPackage())) {
            if (extendFieldConvertProperties.getExtendHandlePointCutPackage().contains(POINT_CUT_DELIMITER)) {
                String[] pointCutPackageSplit = extendFieldConvertProperties.getExtendHandlePointCutPackage().split(POINT_CUT_DELIMITER);
                for (String packageString : pointCutPackageSplit) {
                    if (StringUtils.hasText(packageString)) {
                        if (null == expressionBuilder) {
                            expressionBuilder = new StringBuilder();
                            expressionBuilder.append("(execution(* ").append(packageString).append("..*(..)))");
                        } else {
                            expressionBuilder.append(" || (execution(* ").append(packageString).append("..*(..)))");
                        }
                    }
                }
            } else {
                expressionBuilder = new StringBuilder();
                expressionBuilder.append("(execution(* ").append(extendFieldConvertProperties.getExtendHandlePointCutPackage()).append("..*(..)))");
            }
        }

        String expression = String.valueOf(expressionBuilder);
        advisor.setOrder(-10);
        advisor.setExpression(expression);
        advisor.setAdvice(new HandleExtendFieldByPointCutAdvice(cacheClient, jdbcTemplate));
        log.info("扩展字段处理切面配置完成，切点规则为：{}",  expression);
        return advisor;
    }
}
