/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.ability.api.FscBillInvoiceApplyAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillInvoiceApplyAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillInvoiceApplyAbilityRspBO;
import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busi.api.FscBillInvoiceApplyBusiService;
import com.tydic.fsc.busi.api.bo.FscBillInvoiceApplyBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillInvoiceApplyBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillInvoiceApplyAbilityService.class)
public class FscBillInvoiceApplyAbilityServiceImpl
implements FscBillInvoiceApplyAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillInvoiceApplyBusiService fscBillInvoiceApplyBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Value(value="${FSC_INVOICE_APLLY_TOPIC:FSC_INVOICE_APLLY_TOPIC}")
    private String FSC_INVOICE_APLLY_TOPIC;
    @Value(value="${FSC_INVOICE_APPLY_TAG:*}")
    private String FSC_INVOICE_APPLY_TAG;
    @Resource(name="fscInvoiceApplyProvider")
    private ProxyMessageProducer fscInvoiceApplyProvider;

    @FscDuplicateCommitLimit
    public FscBillInvoiceApplyAbilityRspBO dealInvoiceApply(FscBillInvoiceApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        for (Long orderId : reqBO.getOrderIds()) {
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(orderId);
            FscOrderPO modelBy = this.fscOrderMapper.getModelBy(fscOrderPo);
            if (null == modelBy) {
                throw new FscBusinessException("188888", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u4e3a\u7a7a");
            }
            if (modelBy.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER)) {
                throw new FscBusinessException("188680", "\u5f00\u7968\u65b9\u4e0d\u80fd\u4e3a\u4f9b\u5e94\u5546");
            }
            if (!modelBy.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
                throw new FscBusinessException("188680", "\u5f53\u524d\u53d1\u7968\u975e\u5bf9\u8d26\u5f85\u786e\u8ba4\u72b6\u6001\u6216\u8005\u521b\u5efa\u72b6\u6001");
            }
            FscBillInvoiceApplyBusiReqBO fscBillInvoiceApplyBusiReqBO = new FscBillInvoiceApplyBusiReqBO();
            fscBillInvoiceApplyBusiReqBO.setOrderId(orderId);
            fscBillInvoiceApplyBusiReqBO.setOrderState(modelBy.getOrderState());
            FscBillInvoiceApplyBusiRspBO fscBillInvoiceApplyBusiRspBO = this.fscBillInvoiceApplyBusiService.dealInvoiceApply(fscBillInvoiceApplyBusiReqBO);
            if ("0000".equals(fscBillInvoiceApplyBusiRspBO.getRespCode())) continue;
            throw new FscBusinessException("188680", fscBillInvoiceApplyBusiRspBO.getRespDesc());
        }
        return new FscBillInvoiceApplyAbilityRspBO();
    }

    private void val(FscBillInvoiceApplyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderIds()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[orderIds]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillInvoiceApplyAbilityReqBO reqBO) {
        ArrayList<Long> orderIds = new ArrayList<Long>();
        orderIds.add(reqBO.getOrderId());
        JSONObject fscOrderIdJson = new JSONObject();
        fscOrderIdJson.put("orderId", orderIds);
        this.fscInvoiceApplyProvider.send(new ProxyMessage(this.FSC_INVOICE_APLLY_TOPIC, this.FSC_INVOICE_APPLY_TAG, fscOrderIdJson.toJSONString()));
    }
}

