/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillOrderCreateAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busi.api.FscBillOrderCreateBusiService;
import com.tydic.fsc.busi.api.bo.FscBillOrderCreateBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillOrderCreateBusiRspBO;
import com.tydic.fsc.common.bo.FscOrderInfoBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.common.bo.SplitOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.po.FscCheckResultPO;
import com.tydic.fsc.enums.FscBillInvoiceSerial;
import com.tydic.fsc.enums.FscOrderFlowEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.plugin.encoded.service.EncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.EncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillOrderCreateAbilityService.class)
public class FscBillOrderCreateAbilityServiceImpl
implements FscBillOrderCreateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderCreateAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderCreateBusiService fscBillOrderCreateBusiService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    private static final String DEAL_DESC = "\u5f00\u7968\u4e3b\u5355\u521b\u5efa";
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private EncodedSerialGetService encodedSerialGetService;
    @Value(value="${FSC_INVOICE_APLLY_TOPIC:FSC_INVOICE_APLLY_TOPIC}")
    private String FSC_INVOICE_APLLY_TOPIC;
    @Value(value="${FSC_INVOICE_APPLY_TAG:*}")
    private String FSC_INVOICE_APPLY_TAG;
    @Resource(name="fscInvoiceApplyProvider")
    private ProxyMessageProducer fscInvoiceApplyProvider;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @FscDuplicateCommitLimit
    public FscBillOrderCreateAbilityRspBO dealCreate(FscBillOrderCreateAbilityReqBO reqBO) {
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO;
        this.val(reqBO);
        if (null == reqBO.getOrderFlow()) {
            reqBO.setOrderFlow(FscOrderFlowEnum.INVOICE.getCode());
        }
        ArrayList<Long> inspectionVoucherIdList = new ArrayList<Long>();
        for (SplitOrderBO splitOrderBO : reqBO.getSplitOrderList()) {
            splitOrderBO.getRelOrderList().forEach(relOrderBO -> {
                if (null == relOrderBO.getAcceptOrderId()) {
                    throw new FscBusinessException("188888", "\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
                }
                inspectionVoucherIdList.add(relOrderBO.getAcceptOrderId());
            });
        }
        this.checkResult(reqBO, inspectionVoucherIdList);
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
        fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
        }
        if (null == (fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO)).getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
            throw new FscBusinessException("188888", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        FscOrderInfoBO fscOrderInfoBO = this.checkOrderParam(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap(), reqBO);
        FscBillOrderCreateBusiReqBO fscBillOrderCreateBusiReqBO = (FscBillOrderCreateBusiReqBO)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderCreateBusiReqBO.class);
        fscBillOrderCreateBusiReqBO.setRelType(fscAcceptOrderListQueryAtomReqBO.getRelType());
        fscBillOrderCreateBusiReqBO.setSupplierName(fscOrderInfoBO.getSupplierName());
        fscBillOrderCreateBusiReqBO.setProOrgName(fscOrderInfoBO.getProOrgName());
        fscBillOrderCreateBusiReqBO.setPurchaserName(fscOrderInfoBO.getPurchaserName());
        fscBillOrderCreateBusiReqBO.setFscOrderInfoBoMap(fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap());
        fscBillOrderCreateBusiReqBO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        fscBillOrderCreateBusiReqBO.setBusiName(FscOrderFlowEnum.INVOICE.getDescr());
        fscBillOrderCreateBusiReqBO.setBusiCode(FscOrderFlowEnum.INVOICE.getCode().toString());
        fscBillOrderCreateBusiReqBO.setDealDesc(DEAL_DESC);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.SUPPLIER_START);
        }
        if (FscConstants.FscOrderMakeType.SUPPLIER.equals(reqBO.getMakeType()) && !FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_START);
        }
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.ELECTRONIC);
        }
        fscBillOrderCreateBusiReqBO.setParamMap(paramMap);
        StringBuffer keySb = new StringBuffer();
        keySb.append(reqBO.getReceiveType());
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
            keySb.append(FscConstants.FscBusiModel.TRADE);
        } else {
            keySb.append(FscConstants.FscBusiModel.MATCHING);
        }
        keySb.append(reqBO.getOrderSource());
        fscBillOrderCreateBusiReqBO.setOrderNos(this.getSerial(keySb.toString(), reqBO.getSplitOrderList().size()));
        this.setPayInfo(fscBillOrderCreateBusiReqBO);
        FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO = this.fscBillOrderCreateBusiService.dealCreate(fscBillOrderCreateBusiReqBO);
        if (!"0000".equals(fscBillOrderCreateBusiRspBO.getRespCode())) {
            throw new FscBusinessException("188888", fscBillOrderCreateBusiRspBO.getRespDesc());
        }
        this.sendMq(fscBillOrderCreateBusiRspBO, reqBO);
        return new FscBillOrderCreateAbilityRspBO();
    }

    private void val(FscBillOrderCreateAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getMakeType()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[purchaserId]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOrderSource())) {
            throw new FscBusinessException("184000", "\u5165\u53c2[orderSource]\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSplitOrderList())) {
            throw new FscBusinessException("184000", "\u5165\u53c2[splitOrderList]\u4e3a\u7a7a");
        }
        if (null == reqBO.getTaxNo()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getBuyName()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[buyName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRuleType()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[ruleType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCategory()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[invoiceCategory]\u4e3a\u7a7a");
        }
        if (!FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) && !FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory())) {
            throw new FscBusinessException("184000", "\u5165\u53c2[invoiceCategory]\u53d1\u7968\u7c7b\u522b\u53ea\u80fd\u4e3a1\u62160");
        }
        if (FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) && StringUtils.isBlank((CharSequence)reqBO.getReceiveEmail())) {
            throw new FscBusinessException("184000", "\u63d0\u4ea4\u7535\u7968\u65f6\uff0c\u5165\u53c2[receiveEmail]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getProvince())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[province]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getProvinceCode())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[provinceCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCity())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[city]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCityCode())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[cityCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getArea())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[area]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAreaCode())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[areaCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveAddr())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveAddr]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveName())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceivePhone())) {
                throw new FscBusinessException("184000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receivePhone]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (null == reqBO.getInvoiceType()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[invoiceType]\u4e3a\u7a7a");
        }
    }

    private void checkResult(FscBillOrderCreateAbilityReqBO reqBO, List<Long> inspectionVoucherIdList) {
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType()) || FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
            Integer checkCount;
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderIds(inspectionVoucherIdList);
            if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType())) {
                fscCheckResultPO.setStatus(FscConstants.BillCheck.EQUALS);
            }
            if (!(checkCount = Integer.valueOf(this.fscCheckResultMapper.getCheckBy(fscCheckResultPO))).equals(inspectionVoucherIdList.size())) {
                throw new FscBusinessException("188888", "\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u5f00\u7968");
            }
        }
    }

    private List<String> getSerial(String key, Integer num) {
        EncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new EncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        EncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("188888", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void sendMq(FscBillOrderCreateBusiRspBO fscBillOrderCreateBusiRspBO, FscBillOrderCreateAbilityReqBO reqBO) {
        if (FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
            JSONObject fscOrderIdJson = new JSONObject();
            fscOrderIdJson.put("orderId", (Object)fscBillOrderCreateBusiRspBO.getFscOrderIds());
            this.fscInvoiceApplyProvider.send(new ProxyMessage(this.FSC_INVOICE_APLLY_TOPIC, this.FSC_INVOICE_APPLY_TAG, fscOrderIdJson.toJSONString()));
        }
        for (Long fscOrderId : fscBillOrderCreateBusiRspBO.getFscOrderIds()) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
    }

    private FscOrderInfoBO checkOrderParam(Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscBillOrderCreateAbilityReqBO reqBO) {
        FscOrderInfoBO fscOrderInfoBO = fscOrderInfoBoMap.get(((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId());
        if (null == fscOrderInfoBO) {
            throw new FscBusinessException("188888", "\u67e5\u8be2\u8ba2\u5355\u9a8c\u6536\u5355[" + ((RelOrderBO)((SplitOrderBO)reqBO.getSplitOrderList().get(0)).getRelOrderList().get(0)).getAcceptOrderId() + "]\u4fe1\u606f\u4e3a\u7a7a");
        }
        fscOrderInfoBoMap.forEach((acceptOrderId, fscOrderInfo) -> {
            if (!fscOrderInfoBO.getPayType().equals(fscOrderInfo.getPayType())) {
                throw new FscBusinessException("188888", "\u8ba2\u5355\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
            }
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderInfo.getPayType())) {
                if (!fscOrderInfoBO.getPayRule().equals(fscOrderInfo.getPayRule())) {
                    throw new FscBusinessException("188888", "\u8ba2\u5355\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                }
                if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
                    if (!fscOrderInfoBO.getPayNodeRule().equals(fscOrderInfo.getPayNodeRule())) {
                        throw new FscBusinessException("188888", "\u8ba2\u5355\u8d26\u671f\u8d77\u7b97\u7279\u5b9a\u4e1a\u52a1\u8282\u70b9\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                    if (!fscOrderInfoBO.getPayNodeAccountDays().equals(fscOrderInfo.getPayNodeAccountDays())) {
                        throw new FscBusinessException("188888", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                } else if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
                    if (!fscOrderInfoBO.getPayAccountDayRule().equals(fscOrderInfo.getPayAccountDayRule())) {
                        throw new FscBusinessException("188888", "\u8ba2\u5355\u8d26\u671f\u65e5\u7ed3\u7b97\u8ba2\u5355\u89c4\u5219\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                    if (!fscOrderInfoBO.getPayAccountDay().equals(fscOrderInfo.getPayAccountDay())) {
                        throw new FscBusinessException("188888", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u4e00\u8d77\u5f00\u7968");
                    }
                } else {
                    String orderNo = fscOrderInfo.getPurchaseOrderNo();
                    if (FscConstants.FscBusiModel.MATCHING.equals(fscOrderInfo.getTradeMode())) {
                        orderNo = fscOrderInfo.getSaleOrderNo();
                    }
                    throw new FscBusinessException("188888", "\u8ba2\u5355\u3010" + orderNo + "\u3011\u8d26\u671f\u652f\u4ed8\u7ed3\u7b97\u89c4\u5219\u3010" + fscOrderInfoBO.getPayRule() + "\u3011\u9519\u8bef\uff0c\u4e0d\u5141\u8bb8\u5f00\u7968");
                }
            }
            if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !fscOrderInfoBO.getPurchaserId().equals(fscOrderInfo.getPurchaserId())) {
                throw new FscBusinessException("188888", "\u6536\u7968\u65b9\u4e3a\u91c7\u8d2d\u5355\u4f4d\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u91c7\u8d2d\u5355\u4f4d\u7684\u8ba2\u5355");
            }
            if (!FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType()) && !fscOrderInfoBO.getSupplierId().equals(fscOrderInfo.getSupplierId())) {
                throw new FscBusinessException("188888", "\u5f00\u7968\u65b9\u4e3a\u8fd0\u8425\u65b9\u65f6\uff0c\u53ea\u80fd\u9009\u62e9\u76f8\u540c\u4f9b\u5e94\u5546\u7684\u8ba2\u5355");
            }
        });
        return fscOrderInfoBO;
    }

    private void setPayInfo(FscBillOrderCreateBusiReqBO fscBillOrderCreateBusiReqBO) {
        if (FscConstants.FscOrderMakeType.OPERTION.equals(fscBillOrderCreateBusiReqBO.getMakeType())) {
            fscBillOrderCreateBusiReqBO.setPayeeId(fscBillOrderCreateBusiReqBO.getProOrgId());
            fscBillOrderCreateBusiReqBO.setPayeeName(fscBillOrderCreateBusiReqBO.getProOrgName());
        } else {
            fscBillOrderCreateBusiReqBO.setPayeeId(fscBillOrderCreateBusiReqBO.getSupplierId());
            fscBillOrderCreateBusiReqBO.setPayeeName(fscBillOrderCreateBusiReqBO.getSupplierName());
        }
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(fscBillOrderCreateBusiReqBO.getReceiveType())) {
            fscBillOrderCreateBusiReqBO.setPayerId(fscBillOrderCreateBusiReqBO.getProOrgId());
            fscBillOrderCreateBusiReqBO.setPayerName(fscBillOrderCreateBusiReqBO.getProOrgName());
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(fscBillOrderCreateBusiReqBO.getReceiveType())) {
            fscBillOrderCreateBusiReqBO.setPayerId(fscBillOrderCreateBusiReqBO.getPurchaserId());
            fscBillOrderCreateBusiReqBO.setPayerName(fscBillOrderCreateBusiReqBO.getPurchaserName());
        }
        if (FscConstants.FscOrderReceiveType.SUPPLIER.equals(fscBillOrderCreateBusiReqBO.getReceiveType())) {
            fscBillOrderCreateBusiReqBO.setPayerId(fscBillOrderCreateBusiReqBO.getSupplierId());
            fscBillOrderCreateBusiReqBO.setPayerName(fscBillOrderCreateBusiReqBO.getSupplierName());
        }
    }
}

