/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.ability.api.FscBillOrderInvoiceSignAbilityService;
import com.tydic.fsc.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillOrderInvoiceSignAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillOrderInvoiceSignAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busi.api.FscBillOrderInvoiceSignBusiService;
import com.tydic.fsc.busi.api.bo.FscBillOrderInvoiceSignBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillOrderInvoiceSignBusiRspBO;
import com.tydic.fsc.common.bo.FscOrderInfoBO;
import com.tydic.fsc.common.bo.FscShouldPayBO;
import com.tydic.fsc.common.bo.InvoiceCmpResultBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.po.FscOrderPO;
import com.tydic.fsc.enums.FscInvoiceSignErrorMsgEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillOrderInvoiceSignAbilityService.class)
public class FscBillOrderInvoiceSignAbilityServiceImpl
implements FscBillOrderInvoiceSignAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillOrderInvoiceSignBusiService fscBillOrderInvoiceSignBusiService;
    private static final String SYS_LIMIT_SIGN_CMP_AMT = "3";
    private static final String REPLACE_KEY = "#replace#";
    private static final String REPLACE_LIMIT_AMT = "##";
    private static final String ERROR_MSG_TITLE_BEGIN = "\u7ed3\u7b97\u5355";
    private static final String ERROR_MSG_TITLE_END = "\u4e0d\u7b26\u5408\u7b7e\u6536\u89c4\u5219\uff0c\u539f\u56e0\u5982\u4e0b\uff1a\n";
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;

    @FscDuplicateCommitLimit
    public FscBillOrderInvoiceSignAbilityRspBO dealOrderInvoiceSign(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("188888", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("188888", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u7b7e\u6536");
        }
        this.checkCmpResult(reqBO.getInvoiceCmpResult(), fscOrderPO);
        FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO = (FscBillOrderInvoiceSignBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignBusiReqBO.class);
        fscBillOrderInvoiceSignBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO);
        FscBillOrderInvoiceSignBusiRspBO fscBillOrderInvoiceSignBusiRspBO = this.fscBillOrderInvoiceSignBusiService.dealOrderInvoiceSign(fscBillOrderInvoiceSignBusiReqBO);
        if (!"0000".equals(fscBillOrderInvoiceSignBusiRspBO.getRespCode())) {
            throw new FscBusinessException("188888", fscBillOrderInvoiceSignBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillOrderInvoiceSignAbilityRspBO();
    }

    private void checkCmpResult(InvoiceCmpResultBO invoiceCmpResultBO, FscOrderPO fscOrderPO) {
        this.CheckCfcParam(invoiceCmpResultBO, fscOrderPO.getOrderSource());
        if (invoiceCmpResultBO.getCmpResultStr().contains(FscConstants.FscInvoiceVerifyResult.NO.toString())) {
            StringBuffer errorMsg = new StringBuffer();
            errorMsg.append(ERROR_MSG_TITLE_BEGIN);
            errorMsg.append(fscOrderPO.getOrderNo());
            errorMsg.append(ERROR_MSG_TITLE_END);
            int strLen = invoiceCmpResultBO.getCmpResultStr().length();
            int seq = 1;
            for (int i = 0; i < strLen; ++i) {
                if (invoiceCmpResultBO.getCmpResultStr().charAt(i) == FscConstants.FscInvoiceVerifyResult.NO.toString().charAt(0)) {
                    errorMsg.append(seq);
                    errorMsg.append(FscInvoiceSignErrorMsgEnum.getInstance((Integer)seq).getDescr());
                    ++seq;
                }
                if (i == 5) break;
            }
            if (invoiceCmpResultBO.getAmountMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getAmountMargin().toString()));
                ++seq;
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.UNTAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getUntaxAmtMargin().toString()).replace(REPLACE_LIMIT_AMT, SYS_LIMIT_SIGN_CMP_AMT));
                ++seq;
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getTaxMargin().toString()).replace(REPLACE_LIMIT_AMT, SYS_LIMIT_SIGN_CMP_AMT));
                ++seq;
            }
            if (invoiceCmpResultBO.getItemNumMargin().compareTo(BigDecimal.ZERO) != 0) {
                errorMsg.append(seq);
                errorMsg.append(FscInvoiceSignErrorMsgEnum.TAX_AMT.getDescr().replace(REPLACE_KEY, invoiceCmpResultBO.getItemNumMargin().toString()).replace(REPLACE_LIMIT_AMT, SYS_LIMIT_SIGN_CMP_AMT));
                ++seq;
            }
            throw new FscBusinessException("188888", errorMsg.toString());
        }
    }

    private void val(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult()) {
            throw new FscBusinessException("184000", "\u5165\u53c2invoiceCmpResult\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getUntaxAmtMargin()) {
            throw new FscBusinessException("184000", "\u5165\u53c2untaxAmtMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getTaxMargin()) {
            throw new FscBusinessException("184000", "\u5165\u53c2taxMargin\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCmpResult().getAmountMargin()) {
            throw new FscBusinessException("184000", "\u5165\u53c2amountMargin\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getInvoiceCmpResult().getCmpResultStr())) {
            throw new FscBusinessException("184000", "\u5165\u53c2cmpResultStr\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillOrderInvoiceSignAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }

    private void dealAccountRule(FscBillOrderInvoiceSignBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscAcceptOrderListQueryAtomReqBO.getOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("188888", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("188888", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            FscOrderInfoBO fscOrderInfoBO = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime)).get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("188888", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            if (FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.COMMON_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource()));
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(Boolean.valueOf(true));
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource) {
        Calendar now = Calendar.getInstance();
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("188888", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("188888", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private void CheckCfcParam(InvoiceCmpResultBO invoiceCmpResultBO, Integer orderSource) {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoiceCheck");
        fscCfcUniteParamQryListDetailExternalReqBO.setBusiType(orderSource.toString());
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("188888", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        StringBuffer cmpResult = new StringBuffer(invoiceCmpResultBO.getCmpResultStr());
        char resultYesChar = FscConstants.FscInvoiceVerifyResult.YES.toString().charAt(0);
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getInvoiceTitleCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BUY_NAME.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxpayerIdCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.TAX_NO.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAddressCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ADDRESS.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getPhoneCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.PHONE.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getBankCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.BANK.getCode() - 1, resultYesChar);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getAccountCheck())) {
            cmpResult.setCharAt(FscInvoiceSignErrorMsgEnum.ACCOUNT.getCode() - 1, resultYesChar);
        }
        invoiceCmpResultBO.setCmpResultStr(cmpResult.toString());
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountCheck())) {
            invoiceCmpResultBO.setAmountMargin(BigDecimal.ZERO);
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExCheck())) {
            invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ZERO);
        } else {
            BigDecimal diffUntaxAmt = BigDecimal.ZERO;
            if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck())) {
                diffUntaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTotalAmountExOtherCheck());
            }
            if (invoiceCmpResultBO.getUntaxAmtMargin().compareTo(diffUntaxAmt.divide(BigDecimal.valueOf(100L), 2, 4)) > 0 || invoiceCmpResultBO.getUntaxAmtMargin().compareTo(BigDecimal.ZERO) < 0) {
                invoiceCmpResultBO.setUntaxAmtMargin(BigDecimal.ONE);
            }
        }
        if (!"1".equals(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountCheck())) {
            invoiceCmpResultBO.setTaxMargin(BigDecimal.ZERO);
        } else {
            BigDecimal diffTaxAmt = BigDecimal.ZERO;
            if (!StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck())) {
                diffTaxAmt = new BigDecimal(fscCfcUniteParamQryListDetailExternalRspBO.getTaxAmountOtherCheck());
            }
            if (invoiceCmpResultBO.getTaxMargin().compareTo(diffTaxAmt.divide(BigDecimal.valueOf(100L), 2, 4)) > 0 || invoiceCmpResultBO.getTaxMargin().compareTo(BigDecimal.ZERO) < 0) {
                invoiceCmpResultBO.setTaxMargin(BigDecimal.ONE);
            }
        }
    }
}

