/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.fsc.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.ability.api.FscGetInvoiceDataAbilityService;
import com.tydic.fsc.ability.api.bo.FscComInvoiceDeleteSyncAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscGetInvoiceDataAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.busi.api.FscGetInvoiceDataBusiService;
import com.tydic.fsc.busi.api.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.common.bo.AttachmentBO;
import com.tydic.fsc.common.bo.FscInvoiceInfoBO;
import com.tydic.fsc.common.bo.InvoiceItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.po.FscOrderInvoicePO;
import com.tydic.fsc.dao.po.FscOrderItemPO;
import com.tydic.fsc.enums.FscBillStatus;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscGetInvoiceInfoItemReqBO;
import com.tydic.fsc.external.api.bo.FscGetInvoiceInfoItemRspBO;
import com.tydic.fsc.external.api.bo.FscGetInvoiceInfoItemSkuRspBO;
import com.tydic.fsc.external.api.bo.FscGetInvoiceInfoListRspBO;
import com.tydic.fsc.external.api.bo.FscGetInvoiceInfoReqBO;
import com.tydic.fsc.external.api.bo.FscGetInvoiceInfoRspBO;
import com.tydic.fsc.external.api.esb.FscGetInvoiceInfoExternalService;
import com.tydic.fsc.external.api.esb.FscGetInvoiceInfoItemExternalService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscGetInvoiceDataAbilityService.class)
public class FscGetInvoiceDataAbilityServiceImpl
implements FscGetInvoiceDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGetInvoiceDataAbilityServiceImpl.class);
    @Autowired
    private FscGetInvoiceDataBusiService fscGetInvoiceDataBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscGetInvoiceInfoExternalService fscGetInvoiceInfoExternalService;
    @Autowired
    private FscGetInvoiceInfoItemExternalService fscGetInvoiceInfoItemExternalService;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    private static final String BUSI_NAME = "\u83b7\u53d6\u7535\u5546\u53d1\u7968";

    public FscGetInvoiceDataAbilityRspBO getInvoiceData(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscGetInvoiceInfoReqBO fscGetInvoiceInfoReqBO = new FscGetInvoiceInfoReqBO();
        fscGetInvoiceInfoReqBO.setMarkId(String.valueOf(reqBO.getFscOrderId()));
        fscGetInvoiceInfoReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        FscGetInvoiceInfoRspBO invoiceInfo = this.fscGetInvoiceInfoExternalService.getInvoiceInfo(fscGetInvoiceInfoReqBO);
        if (!"0000".equals(invoiceInfo.getRespCode())) {
            throw new FscBusinessException("188687", invoiceInfo.getRespDesc());
        }
        List invoiceInfoResultList = invoiceInfo.getResult();
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (null == fscOrderInvoicePo) {
            throw new FscBusinessException("184000", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemPos = this.fscOrderItemMapper.getList(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPos)) {
            throw new FscBusinessException("184000", "\u67e5\u8be2\u4e3b\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBos = new ArrayList<FscInvoiceInfoBO>();
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoResultList)) {
            for (FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO : invoiceInfoResultList) {
                FscInvoiceInfoBO fscInvoiceInfoBO = this.createEntity(fscGetInvoiceInfoListRspBO, reqBO, fscOrderInvoicePo, fscOrderItemPos);
                fscInvoiceInfoBos.add(fscInvoiceInfoBO);
            }
        }
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBos);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillInvoiceUploadBusiReqBO.setBusiName(BUSI_NAME);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("188888", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscGetInvoiceDataAbilityRspBO();
    }

    private void val(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }

    private FscInvoiceInfoBO createEntity(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataAbilityReqBO reqBO, FscOrderInvoicePO fscOrderInvoicePo, List<FscOrderItemPO> fscOrderItemPos) {
        FscGetInvoiceInfoItemReqBO fscGetInvoiceInfoItemReqBO = new FscGetInvoiceInfoItemReqBO();
        fscGetInvoiceInfoItemReqBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscGetInvoiceInfoItemReqBO.setInvoiceId(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscGetInvoiceInfoItemReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoItemReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        FscGetInvoiceInfoItemRspBO invoiceInfoItem = this.fscGetInvoiceInfoItemExternalService.getInvoiceInfoItem(fscGetInvoiceInfoItemReqBO);
        if (!"0000".equals(invoiceInfoItem.getRespCode())) {
            throw new FscBusinessException("188687", invoiceInfoItem.getRespDesc());
        }
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        List skuEntity = invoiceInfoItem.getSkuEntity();
        Map<String, FscGetInvoiceInfoItemSkuRspBO> extInvoiceItemMap = skuEntity.stream().collect(Collectors.toMap(FscGetInvoiceInfoItemSkuRspBO::getExtSkuId, v -> v));
        ArrayList invoiceItemBOList = new ArrayList();
        fscOrderItemPos.forEach(fscOrderItemPo -> {
            InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
            invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
            invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
            invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
            invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
            invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
            invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
            invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
            invoiceItemBO.setModel(fscOrderItemPo.getModel());
            invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
            invoiceItemBO.setTaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getTaxAmount());
            invoiceItemBO.setUnit(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getSettleUnit());
            invoiceItemBO.setTaxCode(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getTaxId());
            invoiceItemBO.setNum(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getNum());
            invoiceItemBO.setAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getAmount());
            invoiceItemBO.setUntaxAmt(((FscGetInvoiceInfoItemSkuRspBO)extInvoiceItemMap.get(fscOrderItemPo.getSkuIdExt())).getAmountUnTax());
            invoiceItemBOList.add(invoiceItemBO);
        });
        fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOList);
        fscInvoiceInfoBO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePo.getInvoiceType());
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePo.getInvoiceCategory());
        fscInvoiceInfoBO.setCreateTime(fscOrderInvoicePo.getBillTime());
        fscInvoiceInfoBO.setCreateOperId(fscOrderInvoicePo.getBillOperId());
        fscInvoiceInfoBO.setCreateOperName(fscOrderInvoicePo.getBillOperName());
        fscInvoiceInfoBO.setBank(fscGetInvoiceInfoListRspBO.getBank());
        fscInvoiceInfoBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
        fscInvoiceInfoBO.setInvoiceNo(fscGetInvoiceInfoListRspBO.getInvoiceId());
        fscInvoiceInfoBO.setBillDate(fscGetInvoiceInfoListRspBO.getInvoiceDate());
        fscInvoiceInfoBO.setUntaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceNakedAmount());
        fscInvoiceInfoBO.setTax(fscGetInvoiceInfoListRspBO.getInvoiceTaxRate());
        fscInvoiceInfoBO.setTaxAmt(fscGetInvoiceInfoListRspBO.getInvoiceTaxAmount());
        fscInvoiceInfoBO.setAmt(fscGetInvoiceInfoListRspBO.getInvoiceAmount());
        fscInvoiceInfoBO.setBuyName(fscGetInvoiceInfoListRspBO.getTitle());
        fscInvoiceInfoBO.setTaxNo(fscGetInvoiceInfoListRspBO.getEnterpriseTaxpayer());
        fscInvoiceInfoBO.setAddress(fscGetInvoiceInfoListRspBO.getAddress());
        fscInvoiceInfoBO.setPhone(fscGetInvoiceInfoListRspBO.getTel());
        fscInvoiceInfoBO.setAccount(fscGetInvoiceInfoListRspBO.getAccount());
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getFileUrl())) {
            ArrayList<AttachmentBO> attachmentBos = new ArrayList<AttachmentBO>();
            AttachmentBO attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            attachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getFileUrl());
            attachmentBos.add(attachmentBo);
            fscInvoiceInfoBO.setAttachmentList(attachmentBos);
        }
        return fscInvoiceInfoBO;
    }

    private void sendMq(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceDeleteSyncAbilityReqBO fscComInvoiceDeleteSyncAbilityReqBO = new FscComInvoiceDeleteSyncAbilityReqBO();
        fscComInvoiceDeleteSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }
}

