/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.tydic.fsc.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busi.api.FscBillSupCheckConfirmBusiService;
import com.tydic.fsc.busi.api.bo.FscBillSupCheckConfirmBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillSupCheckConfirmBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.po.FscCheckResultPO;
import com.tydic.fsc.dao.po.FscOrderRelationPO;
import com.tydic.fsc.enums.FscBillStatus;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillSupCheckConfirmBusiServiceImpl
implements FscBillSupCheckConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupCheckConfirmBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final String BUSI_NAME = "\u5bf9\u8d26\u5f85\u786e\u8ba4";
    public static final String BUSI_CODE = "1015";

    public FscBillSupCheckConfirmBusiRspBO dealSupCheckConfirm(FscBillSupCheckConfirmBusiReqBO reqBO) {
        FscOrderStatusFlowAtomRspBO flowAtomRspBO;
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        List orderRelationPos = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (orderRelationPos.size() == 0) {
            throw new FscBusinessException("188667", fscOrderRelationPo.getOrderId() + ":\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u6570\u636e");
        }
        List accepteOrderIdList = orderRelationPos.stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
        List fscCheckResultPos = this.fscCheckResultMapper.selectByAcceptOrderIds(accepteOrderIdList);
        if (FscConstants.ReconciliationCheckFlag.CONFIRM.equals(reqBO.getResult())) {
            boolean allMatch = fscCheckResultPos.stream().allMatch(fscCheckResultPo -> FscConstants.BillCheck.EQUALS.equals(fscCheckResultPo.getStatus()));
            if (!allMatch) {
                throw new FscBusinessException("188667", "\u7ed3\u7b97\u5355[" + reqBO.getOrderId() + "]\u5bf9\u8d26\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5bf9\u8d26");
            }
            List acceptOrderIds = fscCheckResultPos.stream().map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
            int updated = this.fscCheckResultMapper.updateStatusByAcceptOrderIds(acceptOrderIds, FscConstants.BillCheck.CONFIRMED);
            if (updated < 1) {
                throw new FscBusinessException("188667", "\u66f4\u65b0\u6570\u636e\u5e93\u9519\u8bef");
            }
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.RECONCILIATION_TO_BE_CONFIRMED.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        if (FscConstants.ReconciliationCheckFlag.RE_CHECK.equals(reqBO.getResult())) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
            paramMap.put("redoFlag", FscConstants.BillOrderRedoFlag.RE_DO);
            flowAtomReqBO.setParamMap(paramMap);
        }
        if (!"0000".equals((flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO)).getRespCode())) {
            throw new FscBusinessException("188666", flowAtomRspBO.getRespDesc());
        }
        return new FscBillSupCheckConfirmBusiRspBO();
    }
}

