/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.ability.api.FscBillSupplierCheckAbilityService;
import com.tydic.fsc.ability.api.bo.FscBillSupplierCheckAbilityReqBO;
import com.tydic.fsc.ability.api.bo.FscBillSupplierCheckAbilityRspBO;
import com.tydic.fsc.ability.api.bo.FscBillSupplierCheckOrderItemBO;
import com.tydic.fsc.busi.api.FscBillSupplierCheckBusiService;
import com.tydic.fsc.busi.api.bo.FscBillSupplierCheckBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillSupplierCheckBusiRspBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV", serviceInterface=FscBillSupplierCheckAbilityService.class)
public class FscBillSupplierCheckAbilityServiceImpl
implements FscBillSupplierCheckAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSupplierCheckAbilityServiceImpl.class);
    @Autowired
    private FscBillSupplierCheckBusiService fscBillSupplierCheckBusiService;

    public FscBillSupplierCheckAbilityRspBO dealSupplierCheck(FscBillSupplierCheckAbilityReqBO reqBO) {
        this.verification(reqBO);
        String jsonString = JSON.toJSONString((Object)reqBO);
        FscBillSupplierCheckBusiReqBO busiReqBO = (FscBillSupplierCheckBusiReqBO)JSON.parseObject((String)jsonString, FscBillSupplierCheckBusiReqBO.class);
        FscBillSupplierCheckBusiRspBO busiRspBO = this.fscBillSupplierCheckBusiService.dealSupplierCheck(busiReqBO, "2");
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("188666", busiRspBO.getRespDesc());
        }
        return new FscBillSupplierCheckAbilityRspBO();
    }

    private void verification(FscBillSupplierCheckAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("184000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("184000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getRelOrderList() || reqBO.getRelOrderList().size() == 0) {
            throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e3a\u7a7a");
        }
        List relOrderList = reqBO.getRelOrderList();
        for (FscBillSupplierCheckOrderItemBO relOrderBO : relOrderList) {
            if (null == relOrderBO.getOrderId()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[orderId]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getAcceptOrderId()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[acceptOrderId]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getAmount()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[amount]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getRelAmount()) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[relAmount]\u4e3a\u7a7a");
            }
            if (null == relOrderBO.getRelOrderitemList() || relOrderBO.getRelOrderitemList().size() == 0) {
                throw new FscBusinessException("184000", "\u5165\u53c2[relOrderList]\u4e2d[relOrderitemList]\u4e3a\u7a7a");
            }
            List relOrderitemList = relOrderBO.getRelOrderitemList();
            BigDecimal totalItemAmt = relOrderitemList.stream().map(relOrderItemBO -> relOrderItemBO.getOtherNum().multiply(relOrderItemBO.getPrice())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (relOrderBO.getRelAmount().compareTo(totalItemAmt) == 0) continue;
            throw new FscBusinessException("188666", relOrderBO.getOrderId() + "\uff1a\u5546\u54c1\u603b\u91d1\u989d\u4e0e\u9a8c\u6536\u5355\u603b\u989d\u4e0d\u7b26");
        }
    }
}

