/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.service.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.atom.api.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.atom.api.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busi.api.FscBillEcomCheckBusiService;
import com.tydic.fsc.busi.api.bo.FscBillEcomCheckBusiReqBO;
import com.tydic.fsc.busi.api.bo.FscBillEcomCheckBusiRspBO;
import com.tydic.fsc.common.bo.FscOrderInfoBO;
import com.tydic.fsc.common.bo.RelOrderBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.po.FscCheckResultItemPO;
import com.tydic.fsc.dao.po.FscCheckResultPO;
import com.tydic.fsc.dao.po.FscOrderItemPO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.external.api.bo.FscBillCheckOrderAccountReqBO;
import com.tydic.fsc.external.api.bo.FscBillCheckOrderAccountRspBO;
import com.tydic.fsc.external.api.bo.FscCheckOrderEntity;
import com.tydic.fsc.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.external.api.esb.FscBillCheckOrderAccountService;
import com.tydic.fsc.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscBillEcomCheckBusiServiceImpl
implements FscBillEcomCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckBusiServiceImpl.class);
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Autowired
    private FscBillCheckOrderAccountService fscBillCheckOrderAccountService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    public static final String OPER_TYPE = "2";

    public FscBillEcomCheckBusiRspBO dealEcomCheck(FscBillEcomCheckBusiReqBO reqBO) {
        List relOrderList = reqBO.getRelOrderList();
        List acceptIds = relOrderList.stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList());
        FscCheckResultPO fscCheckResult = new FscCheckResultPO();
        fscCheckResult.setAcceptOrderIds(acceptIds);
        fscCheckResult.setStatus(FscConstants.BillCheck.NOT_CHECK);
        List fscCheckResultPoList = this.fscCheckResultMapper.getList(fscCheckResult);
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setAcceptOrderIds(acceptIds);
        List fscOrderItemPos = this.fscOrderItemMapper.getList(fscOrderItemPo);
        List otherNos = fscCheckResultPoList.stream().map(FscCheckResultPO::getOtherNo).collect(Collectors.toList());
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(acceptIds);
        FscAcceptOrderListQueryAtomRspBO queryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        if (!"0000".equals(queryAtomRspBO.getRespCode())) {
            throw new FscBusinessException("188684", queryAtomRspBO.getRespDesc());
        }
        Map fscOrderInfoBoMap = queryAtomRspBO.getFscOrderInfoBoMap();
        String proOrgId = ((FscOrderInfoBO)fscOrderInfoBoMap.get(acceptIds.get(0))).getProOrgId();
        FscBillCheckOrderAccountReqBO fscBillCheckOrderAccountReqBO = new FscBillCheckOrderAccountReqBO();
        fscBillCheckOrderAccountReqBO.setPurchaseNo(proOrgId);
        fscBillCheckOrderAccountReqBO.setSupplierId(((FscCheckResultPO)fscCheckResultPoList.get(0)).getSupplierId());
        fscBillCheckOrderAccountReqBO.setOperType(OPER_TYPE);
        fscBillCheckOrderAccountReqBO.setOrderIdList(otherNos);
        FscBillCheckOrderAccountRspBO checkOrderAccountRspBO = this.fscBillCheckOrderAccountService.checkOrderAccount(fscBillCheckOrderAccountReqBO);
        if (!"0000".equals(checkOrderAccountRspBO.getRespCode())) {
            throw new FscBusinessException("188684", checkOrderAccountRspBO.getRespDesc());
        }
        if (checkOrderAccountRspBO.getResult().getOrders().size() == 0) {
            throw new FscBusinessException("188684", "\u672a\u67e5\u8be2\u5230\u7535\u5546\u5bf9\u8d26\u6570\u636e");
        }
        this.check(fscCheckResultPoList, fscOrderItemPos, checkOrderAccountRspBO.getResult().getOrders(), reqBO);
        return new FscBillEcomCheckBusiRspBO();
    }

    private void check(List<FscCheckResultPO> fscCheckResultPoList, List<FscOrderItemPO> fscOrderItemPos, List<FscCheckOrderEntity> extOrders, FscBillEcomCheckBusiReqBO reqBO) {
        Map<Long, RelOrderBO> relOrderBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getOrderId, o -> o));
        Map<Long, String> orderMap = fscCheckResultPoList.stream().collect(Collectors.toMap(FscCheckResultPO::getOrderId, FscCheckResultPO::getOtherNo));
        HashMap ours = new HashMap(16);
        fscOrderItemPos.forEach(fscOrderItemPo -> {
            BigDecimal orderPrice = fscOrderItemPos.stream().filter(fscOrderItem -> fscOrderItemPo.getOrderId().equals(fscOrderItem.getOrderId())).map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            ours.put(fscOrderItemPo.getOrderId(), orderPrice);
        });
        if (log.isDebugEnabled()) {
            log.debug("\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(ours));
        }
        Map<String, FscCheckOrderEntity> exts = extOrders.stream().collect(Collectors.toMap(FscCheckOrderEntity::getOrderId, f -> f));
        if (log.isDebugEnabled()) {
            log.debug("\u5916\u90e8\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(exts));
        }
        ArrayList uocOrderSyncCheckStatusReqBoList = new ArrayList();
        orderMap.forEach((k, v) -> {
            BigDecimal ourPrice = (BigDecimal)ours.get(k);
            BigDecimal extPrice = ((FscCheckOrderEntity)exts.get(v)).getOrderPrice();
            FscCheckResultPO fscCheckResult = new FscCheckResultPO();
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            fscCheckResult.setOrderId(k);
            fscCheckResult.setCheckTime(new Date());
            fscCheckResult.setOperId(reqBO.getUserId());
            fscCheckResult.setOperName(reqBO.getName());
            fscCheckResult.setOtherAmount(((FscCheckOrderEntity)exts.get(v)).getOrderPrice());
            if (ourPrice.compareTo(extPrice) == 0) {
                fscCheckResult.setStatus(FscConstants.BillCheck.EQUALS);
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.EQUALS);
            } else {
                fscCheckResult.setStatus(FscConstants.BillCheck.NOT_EQUALS);
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.NOT_EQUALS);
            }
            int i = this.fscCheckResultMapper.updateByOrderId(fscCheckResult);
            List skuList = fscOrderItemPos.stream().filter(fscOrderItem -> k.equals(fscOrderItem.getOrderId())).collect(Collectors.toList());
            for (FscOrderItemPO fscOrderItemPo : skuList) {
                FscCheckResultItemPO fscCheckResultItem = new FscCheckResultItemPO();
                long id = Sequence.getInstance().nextId();
                fscCheckResultItem.setId(Long.valueOf(id));
                fscCheckResultItem.setOrderId(k);
                fscCheckResultItem.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                fscCheckResultItem.setFscOrderId(fscOrderItemPo.getFscOrderId());
                fscCheckResultItem.setSkuId(fscOrderItemPo.getSkuId());
                fscCheckResultItem.setPrice(fscOrderItemPo.getPrice());
                fscCheckResultItem.setAmount(fscOrderItemPo.getAmt());
                int insert = this.fscCheckResultItemMapper.insert(fscCheckResultItem);
                if (insert == 1) continue;
                throw new FscBusinessException("188684", "\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25");
            }
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(((FscOrderItemPO)skuList.get(0)).getAcceptOrderId());
            uocOrderSyncCheckStatusReqBO.setOrderId(k);
            uocOrderSyncCheckStatusReqBoList.add(uocOrderSyncCheckStatusReqBO);
        });
        for (FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO : uocOrderSyncCheckStatusReqBoList) {
            FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
            if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
            this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, relOrderBoMap);
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, Map<Long, RelOrderBO> relOrderBoMap) {
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(relOrderBoMap.get(uocOrderSyncCheckStatusReqBO.getOrderId()).getOtherNo());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("188684", "\u8bb0\u5f55\u5931\u8d25\u65e5\u5fd7\u51fa\u9519");
        }
    }
}

